/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import oracle.dbtools.importer.core.ImportKeys;
import oracle.dbtools.importer.core.ImportProperties;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class ImportLogFilePanel
extends JPanel {
    private URLFileChooser.URLFileChooserPanel _importFilePanel;
    private ImportProperties _iProps;
    private static final long serialVersionUID = -2739487292165944123L;

    public ImportLogFilePanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.initFilePanel();
    }

    public String getSelectedDirectory() {
        return this._importFilePanel.getText();
    }

    void initFilePanel() {
        int n = 0;
        this._importFilePanel = URLFileChooser.createURLFileChooserPanel(0, PreferencesArb.getString("IMPORT_LOG_DIR"), true, true);
        this._importFilePanel.setSelectionMode(1);
        this._importFilePanel.setSelectionScope(1);
        this._importFilePanel.setPathContext(this.getClass().getName() + "._logFileChooser");
        this.add((Component)this._importFilePanel, new GridBagConstraints(1, ++n, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void onEntry() {
        DBConfig dBConfig = DBConfig.getInstance();
        this.setOptions(dBConfig.getString("IMPORT_LDR_LOG_DIR"));
    }

    public void onEntry(TraversableContext traversableContext) {
        this._iProps = (ImportProperties)traversableContext.get("IMPORT_PROPERTIES");
        if (this._iProps != null) {
            if ((String)this._iProps.get(ImportKeys.LOGDIRNAME) != null) {
                this.setOptions((String)this._iProps.get(ImportKeys.LOGDIRNAME));
            } else {
                DBConfig dBConfig = DBConfig.getInstance();
                this.setOptions(dBConfig.getString("IMPORT_LDR_LOG_DIR"));
            }
        } else {
            DBConfig dBConfig = DBConfig.getInstance(traversableContext);
            this.setOptions(dBConfig.getString("IMPORT_LDR_LOG_DIR"));
        }
    }

    private void setOptions(String string) {
        this._importFilePanel.setText(string);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putString("IMPORT_LDR_LOG_DIR", this._importFilePanel.getText());
    }
}

