/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.importer.writers.ImportWriteStream;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.dbtools.raptor.controls.ImportFilePanel;
import oracle.dbtools.raptor.data.ui.BatchSizePanel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public class ImportModeInsertPreferences
extends DefaultTraversablePanel {
    private JCheckBox _sqlGen;
    private BatchSizePanel _batchSizePanel;
    private ImportFilePanel _genFilePanel;
    private JCheckBox _genTemp;
    private static final long serialVersionUID = -2739487292165944123L;
    private String _defaultDir;
    private String _importDir;
    private String _tempDir;

    public ImportModeInsertPreferences() {
        this.setHelpID("f1_dbworksheetImportparam_html");
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        int n = 1;
        this._batchSizePanel = new BatchSizePanel();
        this.add(this._batchSizePanel.getBatchSizeLabel(), new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 18, 0, new Insets(8, 0, 0, 8), 0, 0));
        this.add((Component)this._batchSizePanel.getBatchSizeSpinBox(), new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 0, 0, 0), 0, 0));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(null, PreferencesArb.getString("IMPORT_GEN_FILES"), 0, 0, null, null));
        JLabel jLabel = new JLabel(StringUtils.stripMnemonic((String)PreferencesArb.getString("IMPORT_GEN_DIR")));
        jLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString("IMPORT_GEN_DIR")));
        this._genFilePanel = new ImportFilePanel((Component)((Object)this), false);
        this._genFilePanel.setSelectionMode(1);
        jLabel.setLabelFor(this._genFilePanel);
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(8, 0, 6, 8), 0, 0));
        jPanel.add((Component)this._genFilePanel, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(6, 0, 6, 6), 0, 0));
        this._genTemp = new JCheckBox(PreferencesArb.getString("IMPORT_TEMP"));
        ResourceUtils.resButton((AbstractButton)this._genTemp, (String)PreferencesArb.getString("IMPORT_TEMP"));
        this._genTemp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ImportModeInsertPreferences.this._genTemp.isSelected()) {
                    ImportModeInsertPreferences.this._genFilePanel.setDefaultDir(ImportModeInsertPreferences.this._tempDir);
                    ImportModeInsertPreferences.this._genFilePanel.setFileName(ImportModeInsertPreferences.this._tempDir);
                } else {
                    ImportModeInsertPreferences.this._genFilePanel.setDefaultDir(ImportModeInsertPreferences.this._importDir);
                    ImportModeInsertPreferences.this._genFilePanel.setFileName(ImportModeInsertPreferences.this._importDir);
                }
            }
        });
        jPanel.add((Component)this._genTemp, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(jPanel, new GridBagConstraints(0, ++n, 2, 1, 1.0, 0.0, 18, 2, new Insets(16, 0, 0, 0), 0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.setBorder(new TitledBorder(null, Messages.getString("ImportPreferences.1"), 0, 0, null, null));
        this.add(jPanel2, new GridBagConstraints(0, ++n, 2, 1, 0.0, 0.0, 18, 2, new Insets(16, 0, 0, 0), 0, 0));
        this._sqlGen = new JCheckBox(Messages.getString("ImportPreferences.2"));
        ResourceUtils.resButton((AbstractButton)this._sqlGen, (String)Messages.getString("ImportPreferences.2"));
        jPanel2.add((Component)this._sqlGen, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        jPanel2.add(Box.createVerticalGlue(), new GridBagConstraints(0, 0, 3, 1, 0.5, 0.5, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(Box.createGlue(), new GridBagConstraints(0, ++n, 2, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
        this.init(traversableContext);
        this._batchSizePanel.onEntry(traversableContext);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putString("IMPORT_INS_GEN_DIR", this._genFilePanel.getFileName());
        dBConfig.putBoolean("IMPORT_INS_GEN_TEMP", this._genTemp.isSelected());
        dBConfig.putBoolean("IMPORT_SQLGEN_CASE_SENSITIVITY", this._sqlGen.isSelected());
        this._batchSizePanel.onExit(traversableContext);
    }

    private void init(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        this._defaultDir = dBConfig.getString("IMPORT_INS_GEN_DIR");
        this._genTemp.setSelected(dBConfig.getBoolean("IMPORT_INS_GEN_TEMP"));
        this._importDir = dBConfig.getString("IMPORTDIR");
        this._tempDir = "";
        try {
            this._tempDir = ImportWriteStream.getTempDir();
        }
        catch (Exception exception) {
            this._tempDir = this._importDir;
        }
        if (this._defaultDir == null || this._defaultDir.length() == 0) {
            this._defaultDir = this._importDir;
            if (this._genTemp.isSelected()) {
                this._defaultDir = this._tempDir;
            }
        }
        this._genFilePanel.setDefaultDir(this._defaultDir);
        this._genFilePanel.setFileName(this._defaultDir);
        this._sqlGen.setSelected(dBConfig.getBoolean("IMPORT_SQLGEN_CASE_SENSITIVITY"));
    }
}

