/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.connection;

import java.net.URI;
import javax.naming.Reference;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.connections.ConnectionReference;
import oracle.dbtools.http.SessionInfo;
import oracle.dbtools.raptor.utils.persistence.ConnectionReferenceFactory;

abstract class SessionInfoFactory
extends ConnectionReferenceFactory {
    static final String NAME = "CONNECTION_NAME";
    protected static final String USERNAME = "USERNAME";
    protected static final String AUTHENTICATION = "AUTHENTICATION";
    protected static final String ROOT = "ROOT_URI";
    protected static final String SERVICE_URI = "SERVICE_URI";
    protected static final String SFTP_USERNAME = "SFTP_USERNAME";
    protected static final String SFTP_AUTHENTICATION = "SFTP_AUTHENTICATION";
    protected static final String SFTP_HOST = "SFTP_HOST";
    protected static final String SFTP_PORT = "SFTP_PORT";
    protected static final String OSS_ENABLED = "OSS_ENABLED";
    protected static final String OSS_SERVICE_NAME = "OSS_SERVICE_NAME";
    protected static final String OSS_IDENTITY_DOMAIN = "OSS_IDENTITY_DOMAIN";
    protected static final String OSS_USERNAME = "OSS_USERNAME";
    protected static final String OSS_AUTHENTICATION = "OSS_AUTHENICATION";
    protected static final String OSS_SERVICE_URL = "OSS_SERVICE_URL";

    protected SessionInfo createSessionInfo(String string, Reference reference) {
        Object object;
        SessionInfo sessionInfo = null;
        URI uRI = SessionInfoFactory.getURIValue(reference, ROOT);
        URI uRI2 = SessionInfoFactory.getURIValue(reference, SERVICE_URI);
        String string2 = SessionInfoFactory.getStringValue(reference, USERNAME);
        char[] cArray = SessionInfoFactory.getSecureValue(reference, AUTHENTICATION, string);
        SessionInfo.SftpInfo sftpInfo = null;
        String string3 = SessionInfoFactory.getStringValue(reference, SFTP_HOST);
        if (ModelUtil.hasLength((String)string3)) {
            int n = SessionInfoFactory.getIntValue(reference, SFTP_PORT);
            object = SessionInfoFactory.getStringValue(reference, SFTP_USERNAME);
            char[] cArray2 = SessionInfoFactory.getSecureValue(reference, SFTP_AUTHENTICATION, string);
            sftpInfo = new SessionInfo.SftpInfo((String)object, cArray2, string3, n);
        }
        SessionInfo.OssInfo ossInfo = null;
        object = SessionInfoFactory.getBooleanValue(reference, OSS_ENABLED);
        if (object != null) {
            boolean bl = (Boolean)object;
            String string4 = SessionInfoFactory.getStringValue(reference, OSS_SERVICE_NAME);
            String string5 = SessionInfoFactory.getStringValue(reference, OSS_IDENTITY_DOMAIN);
            String string6 = SessionInfoFactory.getStringValue(reference, OSS_USERNAME);
            char[] cArray3 = SessionInfoFactory.getSecureValue(reference, OSS_AUTHENTICATION, string);
            String string7 = SessionInfoFactory.getStringValue(reference, OSS_SERVICE_URL);
            ossInfo = new SessionInfo.OssInfo(bl, string4, string5, string6, cArray3, string7);
        }
        sessionInfo = new SessionInfo(string, uRI, uRI2, string2, cArray, sftpInfo, ossInfo);
        return sessionInfo;
    }

    protected SessionInfo createSessionInfo(String string, ConnectionReference connectionReference) {
        Object object;
        SessionInfo sessionInfo = null;
        URI uRI = SessionInfoFactory.getURIValue(connectionReference, ROOT);
        URI uRI2 = SessionInfoFactory.getURIValue(connectionReference, SERVICE_URI);
        String string2 = SessionInfoFactory.getStringValue(connectionReference, USERNAME);
        char[] cArray = SessionInfoFactory.getSecureValue(connectionReference, AUTHENTICATION, string);
        SessionInfo.SftpInfo sftpInfo = null;
        String string3 = SessionInfoFactory.getStringValue(connectionReference, SFTP_HOST);
        if (ModelUtil.hasLength((String)string3)) {
            int n = SessionInfoFactory.getIntValue(connectionReference, SFTP_PORT);
            object = SessionInfoFactory.getStringValue(connectionReference, SFTP_USERNAME);
            char[] cArray2 = SessionInfoFactory.getSecureValue(connectionReference, SFTP_AUTHENTICATION, string);
            sftpInfo = new SessionInfo.SftpInfo((String)object, cArray2, string3, n);
        }
        SessionInfo.OssInfo ossInfo = null;
        object = SessionInfoFactory.getBooleanValue(connectionReference, OSS_ENABLED);
        if (object != null) {
            boolean bl = (Boolean)object;
            String string4 = SessionInfoFactory.getStringValue(connectionReference, OSS_SERVICE_NAME);
            String string5 = SessionInfoFactory.getStringValue(connectionReference, OSS_IDENTITY_DOMAIN);
            String string6 = SessionInfoFactory.getStringValue(connectionReference, OSS_USERNAME);
            char[] cArray3 = SessionInfoFactory.getSecureValue(connectionReference, OSS_AUTHENTICATION, string);
            String string7 = SessionInfoFactory.getStringValue(connectionReference, OSS_SERVICE_URL);
            ossInfo = new SessionInfo.OssInfo(bl, string4, string5, string6, cArray3, string7);
        }
        sessionInfo = new SessionInfo(string, uRI, uRI2, string2, cArray, sftpInfo, ossInfo);
        return sessionInfo;
    }
}

