/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util;

import java.io.PrintWriter;

public final class DebugUtils {
    private static volatile int DEFAULT_STACK_TRACE_DEPTH = 1;
    private static final PrintWriter out = new PrintWriter(System.out, true);
    private static final PrintWriter err = new PrintWriter(System.err, true);
    private static final boolean areAssertionsEnabled;

    private DebugUtils() {
    }

    public static void setDefaultStackTraceDepth(int depth) {
        DEFAULT_STACK_TRACE_DEPTH = depth;
    }

    public static boolean areAssertionsEnabled() {
        return areAssertionsEnabled;
    }

    public static boolean warning(String message) {
        if (message == null) {
            return true;
        }
        DebugUtils.outputStackTrace(2, message, "Warning", DEFAULT_STACK_TRACE_DEPTH, err);
        return true;
    }

    public static boolean warning(String message, int stackDepth) {
        if (message == null) {
            return true;
        }
        DebugUtils.outputStackTrace(2, message, "Warning", stackDepth, err);
        return true;
    }

    public static boolean trace(Object ... args) {
        if (args == null) {
            DebugUtils.outputStackTrace(2, "null", "Trace", DEFAULT_STACK_TRACE_DEPTH, out);
            return true;
        }
        if (args.length == 0) {
            DebugUtils.outputStackTrace(2, "", "Trace", DEFAULT_STACK_TRACE_DEPTH, out);
            return true;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            buf.append(args[i] != null ? args[i] : "null");
            if (i == args.length - 1) continue;
            buf.append(",");
        }
        DebugUtils.outputStackTrace(2, buf.toString(), "Trace", DEFAULT_STACK_TRACE_DEPTH, out);
        return true;
    }

    public static String argStr(Object ... args) {
        if (args == null) {
            return "null";
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            buf.append(args[i] != null ? args[i] : "null");
            if (i == args.length - 1) continue;
            buf.append(",");
        }
        return buf.toString();
    }

    public static boolean outputException(Throwable e) {
        if (e == null) {
            return true;
        }
        DebugUtils.outputStackTrace(2, "", "Handled exception", 1, err);
        e.printStackTrace(err);
        return true;
    }

    public static boolean dumpStack() {
        DebugUtils.outputStackTrace(2, "", "Stack dump", Integer.MAX_VALUE, out);
        return true;
    }

    public static boolean dumpStack(int stackDepth) {
        DebugUtils.outputStackTrace(2, "", "Stack dump", stackDepth, out);
        return true;
    }

    private static void outputStackTrace(int level, String message, String title, int stackDepth, PrintWriter writer) {
        assert (writer != null);
        assert (level >= 0);
        Throwable t = new Throwable();
        t.fillInStackTrace();
        StackTraceElement[] stackTrace = t.getStackTrace();
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(title).append((String)(DebugUtils.isNotBlank(message) ? ": " + message + " " : " "));
        if (stackDepth <= 0) {
            writer.println(strBuilder.toString());
            return;
        }
        int upperLimit = 0;
        upperLimit = stackDepth == Integer.MAX_VALUE ? stackTrace.length : Math.min(stackDepth + level, stackTrace.length);
        if (upperLimit - level > 0) {
            strBuilder.append(System.getProperty("line.separator"));
        }
        for (int i = level; i < upperLimit; ++i) {
            strBuilder.append("\tat ").append(stackTrace[i].toString());
            if (i == upperLimit - 1) continue;
            strBuilder.append(System.getProperty("line.separator"));
        }
        writer.println(strBuilder.toString());
    }

    private static boolean isNotBlank(String str) {
        int strLen;
        int n = strLen = str != null ? str.length() : 0;
        if (str == null || strLen == 0) {
            return false;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        assert (DebugUtils.warning("some message"));
        int a = 1;
        String str = "string";
        Object obj = new Object();
        assert (DebugUtils.trace(a, str, obj, null));
        IllegalArgumentException e = new IllegalArgumentException("test exception");
        assert (DebugUtils.outputException(e));
        assert (DebugUtils.dumpStack());
    }

    static {
        boolean b = false;
        if (!$assertionsDisabled) {
            b = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        areAssertionsEnabled = b;
    }
}

