/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.ocsp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownServiceException;
import oracle.security.crypto.ocsp.InvalidHttpRequestException;
import oracle.security.crypto.ocsp.OCSPRequest;
import oracle.security.crypto.ocsp.OCSPResponse;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public class HttpOCSPRequest {
    private OCSPRequest request;
    private URL url;

    public HttpOCSPRequest(OCSPRequest request, URL url) {
        this.url = url;
        this.request = request;
    }

    public HttpOCSPRequest(InputStream is) throws IOException {
        String str = this.readLine(is);
        if (str.startsWith("POST /")) {
            boolean contentTypeVerified = false;
            while (!str.equals("")) {
                str = this.readLine(is);
                if (!str.toLowerCase().startsWith("content-type")) continue;
                String contType = str.substring("content-type: ".length());
                if (!contType.equalsIgnoreCase("application/ocsp-request")) {
                    throw new InvalidHttpRequestException("Expected content type 'application/ocsp-request', got '" + contType + "'");
                }
                contentTypeVerified = true;
            }
            if (!contentTypeVerified) {
                throw new InvalidHttpRequestException("Content-Type missing");
            }
        } else {
            throw new InvalidHttpRequestException("HTTP request method not supported");
        }
        this.request = new OCSPRequest(is);
    }

    public static OCSPResponse getResponse(OCSPRequest request, HttpURLConnection conn) throws IOException {
        HttpOCSPRequest.sendRequest(request, conn);
        if (conn.getContentType().equalsIgnoreCase("application/ocsp-response")) {
            Object obj = conn.getContent();
            if (obj instanceof InputStream) {
                return new OCSPResponse((InputStream)obj);
            }
            if (obj instanceof OCSPResponse) {
                return (OCSPResponse)obj;
            }
            throw new UnknownServiceException("OCSPResponse expected");
        }
        return null;
    }

    public OCSPResponse getResponse() throws IOException {
        HttpURLConnection conn = (HttpURLConnection)this.url.openConnection();
        HttpOCSPRequest.sendRequest(this.request, conn);
        if (conn.getContentType().equalsIgnoreCase("application/ocsp-response")) {
            return (OCSPResponse)conn.getContent();
        }
        return null;
    }

    private static void sendRequest(OCSPRequest request, HttpURLConnection conn) throws IOException {
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setUseCaches(false);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/ocsp-request");
        conn.setRequestProperty("Content-Length", String.valueOf(request.length()));
        OutputStream os = conn.getOutputStream();
        os.write(Utils.toBytes((Streamable)request));
        os.flush();
        conn.getInputStream();
    }

    public OCSPRequest getRequest() {
        return this.request;
    }

    private String readLine(InputStream is) throws IOException {
        byte[] buf = new byte[1];
        String s = new String();
        while (is.read(buf) != -1) {
            if (!(s = s + new String(buf)).endsWith("\r\n")) continue;
            return s.substring(0, s.length() - 2);
        }
        return s;
    }
}

