/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ButtonUI;
import oracle.javatools.ui.plaf.theme.ThemedToolBarButtonUI;
import oracle.javatools.util.Log;

public class MenuDropDownButton
extends JToggleButton
implements MenuElement {
    private AbstractButton button;
    private transient Tracker tracker = new Tracker();
    private transient Dimension preferredSize = new Dimension();
    private transient JPopupMenu popupMenu;
    private final Object key;
    private static final Icon ARROW_ICON = new ArrowIcon();
    private static final int ARROW_WIDTH = ARROW_ICON.getIconWidth();
    private static final int ARROW_HEIGHT = ARROW_ICON.getIconHeight();
    private static final Log LOG = new Log("menudrop");
    private static final int UNSPLIT_BUTTON_GAP = 2;
    private static final int SPLIT_BUTTON_SEPARATOR_WIDTH = 2;

    public MenuDropDownButton(String text, Icon icon, Component ... components) {
        this(text, icon, (String)null, components);
    }

    public MenuDropDownButton(Icon icon, Component ... components) {
        this((String)null, icon, (String)null, components);
    }

    public MenuDropDownButton(Icon icon, String tip, Component ... components) {
        this(null, icon, tip, components);
    }

    public MenuDropDownButton(String text, Icon icon, String tip, Component ... components) {
        super(text, icon);
        this.setToolTipText(tip);
        String key = this.getText();
        if (key == null || key.isEmpty()) {
            key = tip;
        }
        Object object = this.key = key != null && !key.isEmpty() ? key : Integer.valueOf(System.identityHashCode(this));
        if (key != null) {
            LOG.trace("{0}: created {1}", (Object)key, (Object)this);
        }
        this.setHorizontalAlignment(10);
        DropDownButtonModel model = new DropDownButtonModel();
        this.setModel(model);
        model.addItemListener(this.tracker);
        this.add(components);
    }

    public MenuDropDownButton(AbstractButton button, Component ... components) {
        this(button, (String)null, components);
    }

    public MenuDropDownButton(AbstractButton button, String tip, Component ... components) {
        this((Icon)new PreferredSizeIcon(button), tip, new Component[0]);
        this.button = button;
        this.setFocusable(false);
        button.setBorder(this.getBorder());
        button.setRolloverEnabled(this.isRolloverEnabled());
        button.setMargin(this.getMargin());
        super.add(button);
        ButtonListener buttonListener = new ButtonListener();
        this.addMouseListener(buttonListener);
        this.addMouseMotionListener(buttonListener);
        button.addMouseListener(buttonListener);
        button.addMouseMotionListener(buttonListener);
        if (this.key != null) {
            LOG.trace("{0}: split with {1}", this.key, (Object)button);
        }
        this.add(components);
        LOG.trace("parent: {0}, ui {1}", (Object)this, (Object)this.getUI());
        LOG.trace("button: {0}, ui {1}", (Object)button, (Object)button.getUI());
        LOG.trace("model initialized: {0}", (Object)this.string(button.getModel()));
        button.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                LOG.trace("model changed: {0}", (Object)MenuDropDownButton.this.string((ButtonModel)e.getSource()));
            }
        });
    }

    @Override
    public void setUI(ButtonUI newUI) {
        LOG.trace("MenuDropDownButton.setUI: new UI ", (Object)newUI);
        super.setUI(newUI);
        if (this.button != null && newUI instanceof ThemedToolBarButtonUI) {
            this.button.setUI(newUI);
        }
    }

    private String string(ButtonModel model) {
        StringBuilder builder = new StringBuilder("[");
        if (!model.isEnabled()) {
            builder.append("disabled");
        }
        if (model.isArmed()) {
            MenuDropDownButton.comma(builder).append("armed");
        }
        if (model.isPressed()) {
            MenuDropDownButton.comma(builder).append("pressed");
        }
        if (model.isSelected()) {
            MenuDropDownButton.comma(builder).append("selected");
        }
        if (this.button.isOpaque()) {
            builder.append(";opaque");
        }
        builder.append(']');
        return builder.toString();
    }

    private static StringBuilder comma(StringBuilder builder) {
        if (builder.length() > 0) {
            builder.append(',');
        }
        return builder;
    }

    public void addPopupMenuListener(PopupMenuListener listener) {
        this.ensurePopupMenuCreated();
        this.popupMenu.addPopupMenuListener(listener);
    }

    public void removePopupMenuListener(PopupMenuListener listener) {
        if (this.popupMenu != null) {
            this.popupMenu.removePopupMenuListener(listener);
        }
    }

    @Override
    public void setIcon(Icon icon) {
        if (this.button != null) {
            throw new IllegalStateException("icon unsupported with nested button");
        }
        super.setIcon(icon);
    }

    @Override
    public void setDisabledIcon(Icon disabledIcon) {
        if (this.button != null) {
            throw new IllegalStateException("icon unsupported with nested button");
        }
        super.setDisabledIcon(disabledIcon);
    }

    @Override
    public void setDisabledSelectedIcon(Icon disabledSelectedIcon) {
        if (this.button != null) {
            throw new IllegalStateException("icon unsupported with nested button");
        }
        super.setDisabledSelectedIcon(disabledSelectedIcon);
    }

    @Override
    public void setPressedIcon(Icon pressedIcon) {
        if (this.button != null) {
            throw new IllegalStateException("icon unsupported with nested button");
        }
        super.setPressedIcon(pressedIcon);
    }

    @Override
    public void setRolloverIcon(Icon rolloverIcon) {
        if (this.button != null) {
            throw new IllegalStateException("icon unsupported with nested button");
        }
        super.setRolloverIcon(rolloverIcon);
    }

    @Override
    public void setRolloverSelectedIcon(Icon rolloverSelectedIcon) {
        if (this.button != null) {
            throw new IllegalStateException("icon unsupported with nested button");
        }
        super.setRolloverSelectedIcon(rolloverSelectedIcon);
    }

    @Override
    public void setSelectedIcon(Icon selectedIcon) {
        if (this.button != null) {
            throw new IllegalStateException("icon unsupported with nested button");
        }
        super.setSelectedIcon(selectedIcon);
    }

    @Override
    public void setMargin(Insets margin) {
        if (this.key != null) {
            LOG.trace("{0}: setBorder {1}", this.key, (Object)margin);
        }
        super.setMargin(margin);
        if (this.button != null) {
            this.button.setMargin(margin);
        }
    }

    @Override
    public void setBorder(Border border) {
        if (this.key != null) {
            LOG.trace("{0}: setBorder {1}", this.key, (Object)border);
        }
        super.setBorder(border);
        if (this.button != null) {
            this.button.setBorder(border);
        }
    }

    @Override
    public void setRolloverEnabled(boolean enabled) {
        if (this.key != null) {
            LOG.trace("{0}: setRolloverEnabled {1}", this.key, (Object)enabled);
        }
        super.setRolloverEnabled(enabled);
        if (this.button != null) {
            this.button.setRolloverEnabled(enabled);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        int height;
        int width;
        if (this.button == null) {
            Dimension size = super.getPreferredSize();
            width = size.width + 2 + ARROW_WIDTH;
            height = Math.max(size.height, ARROW_HEIGHT);
        } else {
            Dimension size = this.button.getPreferredSize();
            int gap = this.getInsets().right - 1;
            width = size.width + gap + 2 + gap + ARROW_WIDTH;
            height = Math.max(size.height, ARROW_HEIGHT);
            LOG.trace("{0}: button preferred size {1}, gap {2}", this.key, (Object)size, (Object)gap);
        }
        if (this.preferredSize.width != width || this.preferredSize.height != height) {
            this.preferredSize = new Dimension(width, height);
            LOG.trace("{0}: preferred size {1}", this.key, (Object)this.preferredSize);
        }
        return this.preferredSize;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void layout() {
        if (this.button != null) {
            Dimension size = this.button.getPreferredSize();
            LOG.trace("{0}: layout, size {1}, button size {2}", this.key, (Object)this.getSize(), (Object)size);
            this.button.setBounds(0, 0, size.width, size.height);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        int shift = this.button != null ? 2 : 0;
        Insets insets = this.getInsets();
        int x = this.getWidth() - insets.right - ARROW_WIDTH - shift;
        int y = (this.getHeight() - ARROW_HEIGHT) / 2;
        ARROW_ICON.paintIcon(this, g, x, y);
        if (this.shouldPaintSeparator()) {
            x = this.button.getWidth() - shift;
            int yTop = 1;
            int yBottom = this.getHeight() - 2;
            Color oldColor = g.getColor();
            g.setColor(SystemColor.controlShadow);
            g.drawLine(x, yTop, x, yBottom);
            g.setColor(SystemColor.controlLtHighlight);
            g.drawLine(x + 1, yTop, x + 1, yBottom);
            g.setColor(oldColor);
        }
    }

    boolean shouldPaintSeparator() {
        return this.button != null && this.isEnabled() && this.isRolloverEnabled() && (this.getModel().isRollover() || this.getModel().isSelected());
    }

    private void ensurePopupMenuCreated() {
        if (this.popupMenu != null) {
            return;
        }
        this.popupMenu = new JPopupMenu();
        this.popupMenu.setInvoker(this);
        this.popupMenu.addPropertyChangeListener("visible", this.tracker);
        this.popupMenu.addMenuKeyListener(this.tracker);
        this.addComponentListener(this.tracker);
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            window.addWindowListener(this.tracker);
        }
    }

    public JPopupMenu getPopupMenu() {
        this.ensurePopupMenuCreated();
        return this.popupMenu;
    }

    public JMenuItem add(JMenuItem menuItem) {
        return this.getPopupMenu().add(menuItem);
    }

    @Override
    public Component add(Component c) {
        return this.getPopupMenu().add(c);
    }

    @Override
    public Component add(Component component, int index) {
        return this.getPopupMenu().add(component, index);
    }

    public void add(Component ... components) {
        if (components != null && components.length > 0) {
            this.ensurePopupMenuCreated();
            for (Component component : components) {
                this.popupMenu.add(component);
            }
        }
    }

    public JMenuItem add(String text) {
        return this.add(new JMenuItem(text));
    }

    public JMenuItem add(Action action) {
        return this.getPopupMenu().add(action);
    }

    public void remove(JMenuItem item) {
        if (this.popupMenu != null) {
            this.popupMenu.remove(item);
        }
    }

    @Override
    public void remove(int position) {
        if (position < 0) {
            throw new IllegalArgumentException("position < 0");
        }
        if (position > this.getMenuComponentCount()) {
            throw new IllegalArgumentException("position >= " + this.getMenuComponentCount());
        }
        if (this.popupMenu != null) {
            this.popupMenu.remove(position);
        }
    }

    @Override
    public void remove(Component component) {
        if (this.popupMenu != null) {
            this.popupMenu.remove(component);
        }
    }

    @Override
    public void removeAll() {
        if (this.popupMenu != null) {
            this.popupMenu.removeAll();
        }
    }

    public int getMenuComponentCount() {
        return this.popupMenu != null ? this.popupMenu.getComponentCount() : 0;
    }

    public Component getMenuComponent(int index) {
        return this.popupMenu != null ? this.popupMenu.getComponent(index) : null;
    }

    public JMenuItem getMenuItem(int index) {
        Component component = this.getMenuComponent(index);
        return component instanceof JMenuItem ? (JMenuItem)component : null;
    }

    public Component[] getMenuComponents() {
        return this.popupMenu != null ? this.popupMenu.getComponents() : new Component[]{};
    }

    protected void showPopup() {
        this.ensurePopupMenuCreated();
        if (this.popupMenu.isVisible()) {
            return;
        }
        this.popupMenu.pack();
        Point location = this.getLocationOnScreen();
        location.y += this.getHeight();
        this.popupMenu.show(this, 0, this.getHeight());
    }

    protected void hidePopup() {
        if (this.isSelected()) {
            this.setSelected(false);
        } else if (this.popupMenu != null && this.popupMenu.isVisible()) {
            this.popupMenu.setVisible(false);
        }
    }

    protected boolean isPopupVisible() {
        return this.popupMenu != null && this.popupMenu.isVisible();
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void processMouseEvent(MouseEvent event, MenuElement[] path, MenuSelectionManager manager) {
    }

    @Override
    public void processKeyEvent(KeyEvent event, MenuElement[] path, MenuSelectionManager manager) {
    }

    @Override
    public void menuSelectionChanged(boolean isIncluded) {
        this.setSelected(isIncluded);
    }

    @Override
    public MenuElement[] getSubElements() {
        if (this.popupMenu == null) {
            return new MenuElement[0];
        }
        return new MenuElement[]{this.popupMenu};
    }

    @Override
    public void processMouseEvent(MouseEvent e) {
        if (this.tracker.popupCancelling()) {
            LOG.trace("{0}: processMouseEvent, consuming, {1}", this.key, (Object)e);
            e.consume();
        } else if (e.getID() == 501 && !this.isPopupVisible() && !this.hasFocus()) {
            LOG.trace("{0}: processMouseEvent, focusing, {1}", this.key, (Object)e);
            this.requestFocus();
            super.processMouseEvent(e);
        } else {
            super.processMouseEvent(e);
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleMenuButton();
        }
        return this.accessibleContext;
    }

    private class Tracker
    implements ItemListener,
    PropertyChangeListener,
    MenuKeyListener,
    ComponentListener,
    WindowListener {
        private boolean cancelling;

        private Tracker() {
        }

        public boolean popupCancelling() {
            return this.cancelling;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            LOG.trace("{0}: itemStateChanged {1}", MenuDropDownButton.this.key, (Object)e);
            if (MenuDropDownButton.this.isSelected()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MenuDropDownButton.this.showPopup();
                    }
                });
            } else {
                MenuDropDownButton.this.hidePopup();
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            boolean visible = (Boolean)e.getNewValue();
            LOG.trace("{0}: propertyChange visible {1}", MenuDropDownButton.this.key, (Object)visible);
            if (visible) {
                this.cancelling = false;
            } else {
                this.cancelling = true;
                MenuDropDownButton.this.setSelected(false);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Tracker.this.cancelling = false;
                    }
                });
            }
        }

        @Override
        public void menuKeyPressed(MenuKeyEvent e) {
            LOG.trace("{0}: menuKeyPressed {1}", MenuDropDownButton.this.key, (Object)e);
            if (e.getKeyCode() == 27) {
                MenuDropDownButton.this.hidePopup();
                e.consume();
            }
        }

        @Override
        public void menuKeyReleased(MenuKeyEvent e) {
        }

        @Override
        public void menuKeyTyped(MenuKeyEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            LOG.trace("{0}: componentResized {1}", MenuDropDownButton.this.key, (Object)e);
            MenuDropDownButton.this.hidePopup();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            LOG.trace("{0}: componentMoved {1}", MenuDropDownButton.this.key, (Object)e);
            MenuDropDownButton.this.hidePopup();
        }

        @Override
        public void componentShown(ComponentEvent e) {
            LOG.trace("{0}: componentShown {1}", MenuDropDownButton.this.key, (Object)e);
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            LOG.trace("{0}: componentHidden {1}", MenuDropDownButton.this.key, (Object)e);
            MenuDropDownButton.this.hidePopup();
        }

        @Override
        public void windowOpened(WindowEvent e) {
            LOG.trace("{0}: windowOpened {1}", MenuDropDownButton.this.key, (Object)e);
        }

        @Override
        public void windowClosing(WindowEvent e) {
            LOG.trace("{0}: windowClosing {1}", MenuDropDownButton.this.key, (Object)e);
            MenuDropDownButton.this.hidePopup();
        }

        @Override
        public void windowClosed(WindowEvent e) {
            LOG.trace("{0}: windowClosed {1}", MenuDropDownButton.this.key, (Object)e);
            MenuDropDownButton.this.hidePopup();
        }

        @Override
        public void windowIconified(WindowEvent e) {
            LOG.trace("{0}: windowIconified {1}", MenuDropDownButton.this.key, (Object)e);
            MenuDropDownButton.this.hidePopup();
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
            LOG.trace("{0}: windowDeiconified {1}", MenuDropDownButton.this.key, (Object)e);
            MenuDropDownButton.this.hidePopup();
        }

        @Override
        public void windowActivated(WindowEvent e) {
            LOG.trace("{0}: windowActivated {1}", MenuDropDownButton.this.key, (Object)e);
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            LOG.trace("{0}: windowDeactivated {1}", MenuDropDownButton.this.key, (Object)e);
            MenuDropDownButton.this.hidePopup();
        }
    }

    private static class DropDownButtonModel
    extends JToggleButton.ToggleButtonModel {
        private DropDownButtonModel() {
        }

        @Override
        public void setArmed(boolean armed) {
            if (this.isArmed() == armed || !this.isEnabled()) {
                return;
            }
            if (!armed && this.isPressed() || this.isSelected()) {
                return;
            }
            super.setArmed(armed);
            if (armed) {
                this.setPressed(true);
            }
        }

        @Override
        public void setPressed(boolean pressed) {
            if (this.isPressed() == pressed || !this.isEnabled()) {
                return;
            }
            if (!pressed && this.isSelected()) {
                return;
            }
            if (pressed) {
                this.setArmed(true);
            }
            this.stateMask = pressed ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
            this.fireStateChanged();
            if (pressed) {
                this.setSelected(true);
            } else {
                this.setArmed(false);
            }
        }

        @Override
        public void setSelected(boolean selected) {
            if (this.isSelected() == selected || !this.isEnabled()) {
                return;
            }
            if (selected) {
                this.setPressed(true);
            }
            super.setSelected(selected);
            if (!selected) {
                this.setPressed(false);
            }
        }
    }

    private static class PreferredSizeIcon
    implements Icon {
        private JComponent component;
        private Insets insets = new Insets(0, 0, 0, 0);

        private PreferredSizeIcon(JComponent component) {
            this.component = component;
        }

        @Override
        public int getIconWidth() {
            Insets insets = this.component.getInsets(this.insets);
            int width = this.component.getPreferredSize().width - insets.left - insets.right;
            return width;
        }

        @Override
        public int getIconHeight() {
            Insets insets = this.component.getInsets(this.insets);
            int height = this.component.getPreferredSize().height - insets.top - insets.bottom;
            return height;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }
    }

    public class ButtonListener
    extends MouseInputAdapter {
        @Override
        public void mouseEntered(MouseEvent e) {
            this.reset(e.getX(), e.getY(), e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.reset(e.getX(), e.getY(), e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.reset(e.getX(), e.getY(), e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.reset(e.getX(), e.getY(), e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.reset(e.getX(), e.getY(), e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.reset(e.getX(), e.getY(), e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.reset(e.getX(), e.getY(), e);
        }

        private void reset(int x, int y, MouseEvent e) {
            boolean rollover = x >= 0 && x < MenuDropDownButton.this.getWidth() && y >= 0 && y < MenuDropDownButton.this.getHeight();
            LOG.trace("{0}: mouse*, rollover {1}, {2}", MenuDropDownButton.this.key, (Object)rollover, (Object)e);
            MenuDropDownButton.this.getModel().setRollover(rollover);
        }
    }

    protected class AccessibleMenuButton
    extends AbstractButton.AccessibleAbstractButton
    implements AccessibleSelection,
    ChangeListener {
        private boolean isArmed;
        private boolean hasFocus;
        private boolean isPressed;
        private boolean isSelected;

        public AccessibleMenuButton() {
            super(MenuDropDownButton.this);
            this.isArmed = false;
            this.hasFocus = false;
            this.isPressed = false;
            this.isSelected = false;
            MenuDropDownButton.this.addChangeListener(this);
        }

        @Override
        public int getAccessibleChildrenCount() {
            Component[] children = MenuDropDownButton.this.getMenuComponents();
            int count = 0;
            for (Component child : children) {
                if (!(child instanceof Accessible)) continue;
                ++count;
            }
            return count;
        }

        @Override
        public Accessible getAccessibleChild(int i) {
            Component[] children = MenuDropDownButton.this.getMenuComponents();
            int count = 0;
            for (Component child : children) {
                if (!(child instanceof Accessible)) continue;
                if (count == i) {
                    if (child instanceof JComponent) {
                        AccessibleContext ac = child.getAccessibleContext();
                        ac.setAccessibleParent(MenuDropDownButton.this);
                    }
                    return (Accessible)((Object)child);
                }
                ++count;
            }
            return null;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU;
        }

        @Override
        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        @Override
        public int getAccessibleSelectionCount() {
            MenuElement[] me = MenuSelectionManager.defaultManager().getSelectedPath();
            if (me != null) {
                for (int i = 0; i < me.length; ++i) {
                    if (me[i] != MenuDropDownButton.this || i + 1 >= me.length) continue;
                    return 1;
                }
            }
            return 0;
        }

        @Override
        public Accessible getAccessibleSelection(int i) {
            if (i < 0 || i >= MenuDropDownButton.this.getMenuComponentCount()) {
                return null;
            }
            MenuElement[] me = MenuSelectionManager.defaultManager().getSelectedPath();
            if (me != null) {
                for (int j = 0; j < me.length; ++j) {
                    if (me[j] != MenuDropDownButton.this) continue;
                    while (++j < me.length) {
                        if (!(me[j] instanceof JMenuItem)) continue;
                        return (Accessible)((Object)me[j]);
                    }
                }
            }
            return null;
        }

        @Override
        public boolean isAccessibleChildSelected(int i) {
            MenuElement[] me = MenuSelectionManager.defaultManager().getSelectedPath();
            if (me != null) {
                JMenuItem mi = MenuDropDownButton.this.getMenuItem(i);
                for (int j = 0; j < me.length; ++j) {
                    if (me[j] != mi) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public void addAccessibleSelection(int i) {
            if (i < 0 || i >= MenuDropDownButton.this.getMenuComponentCount()) {
                return;
            }
            JMenuItem mi = MenuDropDownButton.this.getMenuItem(i);
            if (mi != null) {
                if (mi instanceof JMenu) {
                    MenuElement[] me = this.buildMenuElementArray((JMenu)mi);
                    MenuSelectionManager.defaultManager().setSelectedPath(me);
                } else {
                    MenuSelectionManager.defaultManager().setSelectedPath(null);
                }
            }
        }

        @Override
        public void removeAccessibleSelection(int i) {
            if (i < 0 || i >= MenuDropDownButton.this.getMenuComponentCount()) {
                return;
            }
            JMenuItem mi = MenuDropDownButton.this.getMenuItem(i);
            if (mi instanceof JMenu && mi.isSelected()) {
                MenuElement[] old = MenuSelectionManager.defaultManager().getSelectedPath();
                MenuElement[] me = new MenuElement[old.length - 2];
                for (int j = 0; j < old.length - 2; ++j) {
                    me[j] = old[j];
                }
                MenuSelectionManager.defaultManager().setSelectedPath(me);
            }
        }

        @Override
        public void clearAccessibleSelection() {
            MenuElement[] old = MenuSelectionManager.defaultManager().getSelectedPath();
            if (old != null) {
                for (int j = 0; j < old.length; ++j) {
                    if (old[j] != MenuDropDownButton.this) continue;
                    MenuElement[] me = new MenuElement[j + 1];
                    System.arraycopy(old, 0, me, 0, j);
                    me[j] = MenuDropDownButton.this.getPopupMenu();
                    MenuSelectionManager.defaultManager().setSelectedPath(me);
                }
            }
        }

        @Override
        public void selectAllAccessibleSelection() {
        }

        private MenuElement[] buildMenuElementArray(JMenu leaf) {
            Vector<JComponent> elements = new Vector<JComponent>();
            Component current = leaf.getPopupMenu();
            while (true) {
                if (current instanceof JPopupMenu) {
                    JPopupMenu popup = current;
                    elements.insertElementAt(popup, 0);
                    current = popup.getInvoker();
                    continue;
                }
                if (!(current instanceof MenuDropDownButton)) continue;
                MenuDropDownButton button = (MenuDropDownButton)current;
                elements.insertElementAt(button, 0);
                current = button.getParent();
            }
        }

        private void fireAccessibilityFocusedEvent(MenuDropDownButton toCheck) {
            MenuElement menuItem;
            MenuElement[] path = MenuSelectionManager.defaultManager().getSelectedPath();
            if (path.length > 0 && toCheck == (menuItem = path[path.length - 1])) {
                this.firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.firePropertyChange("AccessibleVisibleData", false, true);
            if (MenuDropDownButton.this.getModel().isArmed()) {
                if (!this.isArmed) {
                    this.isArmed = true;
                    this.firePropertyChange("AccessibleState", null, AccessibleState.ARMED);
                    this.fireAccessibilityFocusedEvent(MenuDropDownButton.this);
                }
            } else if (this.isArmed) {
                this.isArmed = false;
                this.firePropertyChange("AccessibleState", AccessibleState.ARMED, null);
            }
            if (MenuDropDownButton.this.isFocusOwner()) {
                if (!this.hasFocus) {
                    this.hasFocus = true;
                    this.firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
                }
            } else if (this.hasFocus) {
                this.hasFocus = false;
                this.firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
            }
            if (MenuDropDownButton.this.getModel().isPressed()) {
                if (!this.isPressed) {
                    this.isPressed = true;
                    this.firePropertyChange("AccessibleState", null, AccessibleState.PRESSED);
                }
            } else if (this.isPressed) {
                this.isPressed = false;
                this.firePropertyChange("AccessibleState", AccessibleState.PRESSED, null);
            }
            if (MenuDropDownButton.this.isSelected()) {
                if (!this.isSelected) {
                    this.isSelected = true;
                    this.firePropertyChange("AccessibleState", null, AccessibleState.CHECKED);
                    this.fireAccessibilityFocusedEvent(MenuDropDownButton.this);
                }
            } else if (this.isSelected) {
                this.isSelected = false;
                this.firePropertyChange("AccessibleState", AccessibleState.CHECKED, null);
            }
        }
    }

    private static final class ArrowIcon
    extends Polygon
    implements Icon {
        private static final int SIZE = 4;

        public ArrowIcon() {
            this.addPoint(0, 0);
            this.addPoint(2, 2);
            this.addPoint(4, 0);
        }

        @Override
        public int getIconHeight() {
            return this.getBounds().height;
        }

        @Override
        public int getIconWidth() {
            return this.getBounds().width;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color oldColor = g.getColor();
            g.translate(x, y);
            g.setColor(c.isEnabled() ? c.getForeground() : c.getBackground().darker());
            g.fillPolygon(this);
            g.drawPolygon(this);
            g.translate(-x, -y);
            g.setColor(oldColor);
        }
    }
}

