/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;

public class CommandButtonLayout
implements LayoutManager2 {
    public static final float TOP = 0.0f;
    public static final float LEFT = 0.0f;
    public static final float CENTER = 0.5f;
    public static final float BOTTOM = 1.0f;
    public static final float RIGHT = 1.0f;
    public static final float FILL = -1.0f;
    protected float alignmentX;
    protected float alignmentY;
    protected int gap;
    protected static final Dimension MAXIMUM_SIZE = new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);

    public CommandButtonLayout() {
        this(1.0f, 0.0f, 5);
    }

    public CommandButtonLayout(float alignmentX) {
        this(alignmentX, 0.0f, 5);
    }

    public CommandButtonLayout(float alignmentX, int gap) {
        this(alignmentX, 0.0f, gap);
    }

    public CommandButtonLayout(float alignmentX, float alignmentY, int gap) {
        this.alignmentX = alignmentX;
        this.alignmentY = alignmentY;
        this.gap = gap;
    }

    public void setAlignmentX(float newValue) {
        this.alignmentX = newValue;
    }

    public float getAlignmentX() {
        return this.alignmentX;
    }

    public void setAlignmentY(float newValue) {
        this.alignmentY = newValue;
    }

    public float getAlignmentY() {
        return this.alignmentY;
    }

    public void setGap(int newValue) {
        this.gap = newValue;
    }

    public int getGap() {
        return this.gap;
    }

    @Override
    public void addLayoutComponent(String name, Component component) {
    }

    @Override
    public void addLayoutComponent(Component component, Object constraints) {
    }

    @Override
    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        Dimension size = container.getSize();
        int count = container.getComponentCount();
        int childWidth = 0;
        int childHeight = 0;
        for (int i = 0; i < count; ++i) {
            Component child = container.getComponent(i);
            Dimension childSize = child.getPreferredSize();
            if (childSize.width > childWidth) {
                childWidth = childSize.width;
            }
            if (childSize.height <= childHeight) continue;
            childHeight = childSize.height;
        }
        int width = insets.left + (childWidth + this.gap) * count - this.gap + insets.right;
        int extraWidth = Math.max(size.width - width, 0);
        int x = insets.left;
        int gapXDelta = 0;
        int gapXRemainder = 0;
        if (this.alignmentX >= 0.0f) {
            x += (int)((float)extraWidth * this.alignmentX);
        } else if (count > 1) {
            gapXDelta = extraWidth / (count - 1);
            gapXRemainder = extraWidth % (count - 1);
        } else {
            gapXRemainder = extraWidth;
        }
        int y = insets.top;
        if (this.alignmentY >= 0.0f) {
            int extraHeight = Math.max(size.height - childHeight, 0);
            y += (int)((float)extraHeight * this.alignmentY);
        } else {
            childHeight = Math.max(childHeight, size.height);
        }
        for (int i = 0; i < count; ++i) {
            Component child = container.getComponent(i);
            child.setBounds(x, y, childWidth, childHeight);
            x += childWidth + this.gap + gapXDelta;
            if (gapXRemainder-- <= 0) continue;
            ++x;
        }
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return MAXIMUM_SIZE;
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        int height = 0;
        int width = 0;
        int count = container.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component component = container.getComponent(i);
            Dimension size = component.getPreferredSize();
            if (size.width > width) {
                width = size.width;
            }
            if (size.height <= height) continue;
            height = size.height;
        }
        Insets insets = container.getInsets();
        width = (width + this.gap) * count - this.gap;
        return new Dimension(width += insets.left + insets.right, height += insets.top + insets.bottom);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return this.alignmentX < 0.0f ? 0.5f : this.alignmentX;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return this.alignmentY < 0.0f ? 0.5f : this.alignmentY;
    }
}

