/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.log;

import oracle.jdeveloper.audit.service.AuditModelFilter;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdevimpl.audit.util.Cache;

public class SuppressionFilter
extends AuditModelFilter {
    private boolean visible;
    private String key;

    public SuppressionFilter() {
        this(false, null);
    }

    public SuppressionFilter(boolean defaultVisible) {
        this(defaultVisible, null);
    }

    public SuppressionFilter(String persistenceKey) {
        this(false, persistenceKey);
    }

    public SuppressionFilter(boolean defaultVisible, String persistenceKey) {
        this.key = persistenceKey;
        this.visible = Cache.get(this.key, defaultVisible);
    }

    public void setVisible(boolean visible) {
        if (this.visible == visible) {
            return;
        }
        this.visible = visible;
        Cache.put(this.key, visible);
        this.fireStateChanged();
    }

    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public boolean isVisible(Object row) {
        Violation violation = this.getModel().getViolation(row);
        boolean visible = violation == null || violation.getSuppressionCount() == 0 || this.visible;
        return visible;
    }
}

