/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.core;

import java.beans.FeatureDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.el.ArrayELResolver;
import javax.el.BeanELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.FunctionMapper;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.ide.extension.spi.ExtensionLogRecord;
import oracle.ide.ExtensionRegistry;
import oracle.javatools.util.FormatBundle;
import oracle.jdeveloper.audit.analyzer.Parameter;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.analyzer.SuppressionScheme;
import oracle.jdeveloper.audit.extension.ExtensionBean;
import oracle.jdeveloper.audit.service.AuditLogger;
import oracle.jdeveloper.audit.service.TypeSafeEnumeration;
import oracle.jdeveloper.audit.service.TypeSafeEnumerationFactory;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdevimpl.audit.core.CoreBundle;
import oracle.jdevimpl.audit.core.PropertyDeferredException;
import oracle.jdevimpl.audit.util.Beans;
import oracle.jdevimpl.audit.util.PropertyDescriptor;
import org.xml.sax.Locator;

public class AuditELContext
extends ELContext {
    private CompositeELResolver resolver = new CompositeELResolver();
    private Container root;
    private Locator location;
    private ValueExpression expression;
    private static final Reference TRUE_REFERENCE = new ImmediateValueReference(Boolean.TRUE, Boolean.class);
    private static final Reference FALSE_REFERENCE = new ImmediateValueReference(Boolean.FALSE, Boolean.class);
    private static final Reference BOOLEAN_REFERENCE = new DeferredValueReference(Boolean.class);
    private static final FormatBundle BUNDLE = new FormatBundle(CoreBundle.class);
    private static final Parameter[] NO_PARAMETERS = new Parameter[0];

    public AuditELContext() {
        this.resolver.add((ELResolver)new AuditELResolver());
        this.resolver.add((ELResolver)new MapELResolver());
        this.resolver.add((ELResolver)new ListELResolver());
        this.resolver.add((ELResolver)new ArrayELResolver());
        this.resolver.add((ELResolver)new BeanELResolver());
    }

    public void setBean(Object bean) {
        this.root = new RootDefinitionContainer(bean);
        this.location = null;
        this.expression = null;
    }

    public void setBean(Transform transform, ExtensionBean bean, Violation report) {
        this.root = new RootBindingContainer(transform, bean, report);
        this.location = null;
        this.expression = null;
    }

    public void setBean(Transform transform, ExtensionBean bean) {
        this.setBean(transform, bean, null);
    }

    public void setLocation(Locator location) {
        this.location = location;
    }

    public void clear() {
        this.root = null;
        this.location = null;
        this.expression = null;
    }

    public Object evaluateExpression(ValueExpression expression) {
        this.expression = expression;
        expression.getType((ELContext)this);
        Object value = expression.getValue((ELContext)this);
        this.expression = null;
        return value;
    }

    public void log(Level level, String message, Object ... parameters) {
        ExtensionLogRecord record = new ExtensionLogRecord(this.location, level, message);
        if (parameters != null && parameters.length > 0) {
            record.setParameters(parameters);
        }
        ExtensionRegistry.getExtensionRegistry().getManifestLogger().log((LogRecord)record);
    }

    public ELResolver getELResolver() {
        if (this.location == null) {
            IllegalStateException exception = new IllegalStateException("no definition set before evaluation");
            AuditLogger.error(exception, "IllegalStateException: no definition set before evaluation", new Object[0]);
            throw exception;
        }
        return this.resolver;
    }

    public FunctionMapper getFunctionMapper() {
        return null;
    }

    public VariableMapper getVariableMapper() {
        return null;
    }

    private static Collection<String> variations(ExtensionBean bean) {
        return bean instanceof Rule ? ((Rule)bean).variations() : Collections.emptyList();
    }

    private static Parameter[] parameters(ExtensionBean bean) {
        if (bean instanceof Rule) {
            return ((Rule)bean).parameters();
        }
        if (bean instanceof SuppressionScheme) {
            return ((SuppressionScheme)bean).parameters();
        }
        return NO_PARAMETERS;
    }

    private class AuditELResolver
    extends ELResolver {
        private AuditELResolver() {
        }

        public Reference getReference(Object base, Object property) {
            if (property == null) {
                return null;
            }
            if (base == null) {
                base = AuditELContext.this.root;
            }
            String propertyName = property.toString();
            if (base instanceof Container) {
                Reference reference = ((Container)base).getReference(propertyName);
                if (reference != null) {
                    return reference;
                }
            } else if (base instanceof Collection) {
                if ("size".equals(propertyName) || "length".equals(propertyName)) {
                    return new ImmediateValueReference(((Collection)base).size(), Integer.class);
                }
            } else if (base instanceof Map) {
                if ("size".equals(propertyName) || "length".equals(propertyName)) {
                    return new ImmediateValueReference(((Map)base).size(), Integer.class);
                }
            } else if (base instanceof Object[] && ("size".equals(propertyName) || "length".equals(propertyName))) {
                return new ImmediateValueReference(((Object[])base).length, Integer.class);
            }
            return null;
        }

        public Object getValue(ELContext context, Object base, Object property) {
            if (context == null) {
                throw new NullPointerException("context null");
            }
            Reference reference = this.getReference(base, property);
            if (reference != null) {
                AuditELContext.this.setPropertyResolved(true);
                return reference.getValue();
            }
            return null;
        }

        public Class<?> getType(ELContext context, Object base, Object property) {
            if (context == null) {
                throw new NullPointerException("context null");
            }
            Reference reference = this.getReference(base, property);
            if (reference != null) {
                AuditELContext.this.setPropertyResolved(true);
                return reference.getType();
            }
            return null;
        }

        public void setValue(ELContext context, Object base, Object property, Object value) {
            if (context == null) {
                throw new NullPointerException("context null");
            }
            Reference reference = this.getReference(base, property);
            if (reference != null) {
                throw new PropertyNotWritableException();
            }
        }

        public boolean isReadOnly(ELContext context, Object base, Object property) {
            if (context == null) {
                throw new NullPointerException("context null");
            }
            Reference reference = this.getReference(base, property);
            if (reference != null) {
                AuditELContext.this.setPropertyResolved(true);
            }
            return reference != null;
        }

        public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
            if (context == null) {
                throw new NullPointerException("context null");
            }
            if (base == null) {
                base = AuditELContext.this.root;
            }
            if (base instanceof Container) {
                return ((Container)base).getFeatureDescriptors().iterator();
            }
            if (base instanceof Collection || base instanceof Map || base instanceof Object[]) {
                ArrayList<FeatureDescriptor> descriptors = new ArrayList<FeatureDescriptor>(1);
                FeatureDescriptor descriptor = new FeatureDescriptor();
                descriptor.setName("size");
                descriptor.setValue("type", Integer.class);
                descriptor.setValue("resolvableAtDesignTime", true);
                descriptors.add(descriptor);
                return descriptors.iterator();
            }
            return null;
        }

        public Class<?> getCommonPropertyType(ELContext context, Object base) {
            if (context == null) {
                throw new NullPointerException("context null");
            }
            if (base == null) {
                return String.class;
            }
            return null;
        }
    }

    private class RootDefinitionContainer
    extends RootContainer {
        private Object bean;
        private Map<String, PropertyReference> properties;

        private RootDefinitionContainer(Object bean) {
            this.bean = bean;
        }

        @Override
        public Reference getReference(String propertyName) {
            if (this.properties == null) {
                this.properties = new HashMap<String, PropertyReference>();
                for (PropertyDescriptor property : Beans.getPropertyDescriptors(this.bean)) {
                    this.properties.put(property.getName(), new PropertyReference(this.bean, property));
                }
            }
            if (this.properties.containsKey(propertyName)) {
                return this.properties.get(propertyName);
            }
            return super.getReference(propertyName);
        }

        @Override
        public List<FeatureDescriptor> getFeatureDescriptors() {
            ArrayList<FeatureDescriptor> descriptors = new ArrayList<FeatureDescriptor>();
            for (PropertyDescriptor property : Beans.getPropertyDescriptors(this.bean)) {
                FeatureDescriptor descriptor = new FeatureDescriptor();
                descriptor.setName(property.getName());
                descriptor.setValue("type", property.getPropertyType());
                descriptor.setValue("resolvableAtDesignTime", true);
                descriptors.add(descriptor);
            }
            super.getFeatureDescriptors(descriptors);
            return descriptors;
        }
    }

    private static interface Container {
        public Reference getReference(String var1);

        public List<FeatureDescriptor> getFeatureDescriptors();
    }

    private class RootBindingContainer
    extends RootContainer {
        private Transform transform;
        private ExtensionBean bean;
        private Violation issue;

        private RootBindingContainer(Transform transform, ExtensionBean bean, Violation issue) {
            this.transform = transform;
            this.bean = bean;
            this.issue = issue;
        }

        @Override
        public Reference getReference(String propertyName) {
            if ("transform".equals(propertyName)) {
                return new ImmediateValueReference(this.transform, this.transform.getClass());
            }
            if ("rule".equals(propertyName)) {
                return new ImmediateValueReference(this.bean, this.bean.getClass());
            }
            if ("scheme".equals(propertyName)) {
                return new ImmediateValueReference(this.bean, this.bean.getClass());
            }
            if ("issue".equals(propertyName)) {
                return new IssueProxy(this.bean, this.issue);
            }
            if ("report".equals(propertyName)) {
                if (this.issue == null) {
                    AuditELContext.this.log(Level.WARNING, "base object name \"report\" deprecated: use \"issue\"", new Object[0]);
                }
                return new IssueProxy(this.bean, this.issue);
            }
            Reference reference = super.getReference(propertyName);
            if (reference == null) {
                ArrayList<String> qualifiers = new ArrayList<String>();
                boolean issueQualifier = false;
                for (String variation : AuditELContext.variations(this.bean)) {
                    if (!propertyName.equals(variation)) continue;
                    issueQualifier = true;
                    break;
                }
                for (Parameter parameter : AuditELContext.parameters(this.bean)) {
                    if (!propertyName.equals(parameter.getName())) continue;
                    issueQualifier = true;
                    break;
                }
                if (issueQualifier) {
                    qualifiers.add("issue");
                }
                if (Beans.getPropertyDescriptor(this.bean, propertyName) != null) {
                    qualifiers.add("rule");
                }
                if (Beans.getPropertyDescriptor(this.transform, propertyName) != null) {
                    qualifiers.add("transform");
                }
                switch (qualifiers.size()) {
                    case 0: {
                        throw new PropertyNotFoundException(BUNDLE.get("resolution-failed-root-0", new Object[]{propertyName}));
                    }
                    case 1: {
                        throw new PropertyNotFoundException(BUNDLE.get("resolution-failed-root-1", new Object[]{propertyName, qualifiers.get(0)}));
                    }
                    case 2: {
                        throw new PropertyNotFoundException(BUNDLE.get("resolution-failed-root-2", new Object[]{propertyName, qualifiers.get(0), qualifiers.get(1)}));
                    }
                }
                throw new PropertyNotFoundException(BUNDLE.get("resolution-failed-root-3", new Object[]{propertyName, qualifiers.get(0), qualifiers.get(1), qualifiers.get(2)}));
            }
            return reference;
        }

        @Override
        public List<FeatureDescriptor> getFeatureDescriptors() {
            ArrayList<FeatureDescriptor> descriptors = new ArrayList<FeatureDescriptor>();
            FeatureDescriptor descriptor = new FeatureDescriptor();
            descriptor.setName("transform");
            descriptor.setValue("type", this.transform.getClass());
            descriptor.setValue("resolvableAtDesignTime", true);
            descriptors.add(descriptor);
            descriptor = new FeatureDescriptor();
            descriptor.setName("rule");
            descriptor.setValue("type", this.bean.getClass());
            descriptor.setValue("resolvableAtDesignTime", true);
            descriptors.add(descriptor);
            descriptor = new FeatureDescriptor();
            descriptor.setName("issue");
            descriptor.setValue("type", IssueProxy.class);
            descriptor.setValue("resolvableAtDesignTime", false);
            descriptors.add(descriptor);
            super.getFeatureDescriptors(descriptors);
            return descriptors;
        }
    }

    private static class ImmediateValueReference
    implements Reference {
        private Object value;
        private Class<?> type;

        public ImmediateValueReference(Object value, Class<?> type) {
            this.value = value;
            this.type = type;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }
    }

    private static interface Reference {
        public Object getValue();

        public Class<?> getType();
    }

    private static class DeferredValueReference
    implements Reference {
        private Class<?> type;

        public DeferredValueReference(Class<?> type) {
            this.type = type;
        }

        @Override
        public Object getValue() {
            throw new PropertyDeferredException();
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }
    }

    private static class PropertyReference
    implements Reference {
        private Object bean;
        private PropertyDescriptor descriptor;

        public PropertyReference(Object bean, PropertyDescriptor descriptor) {
            this.descriptor = descriptor;
            this.bean = bean;
        }

        @Override
        public Object getValue() {
            try {
                return this.descriptor.getReadMethod().invoke(this.bean, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new ELException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new ELException((Throwable)e);
            }
        }

        @Override
        public Class<?> getType() {
            return this.descriptor.getPropertyType();
        }
    }

    private static class IssueProxy
    implements Reference,
    Container {
        private ExtensionBean rule;
        private Violation issue;

        private IssueProxy(ExtensionBean rule, Violation issue) {
            this.rule = rule;
            this.issue = issue;
        }

        @Override
        public Object getValue() {
            return this;
        }

        @Override
        public Class<?> getType() {
            return this.getClass();
        }

        @Override
        public Reference getReference(String propertyName) {
            for (String variation : AuditELContext.variations(this.rule)) {
                if (!propertyName.equals(variation)) continue;
                if (this.issue == null) {
                    return BOOLEAN_REFERENCE;
                }
                if (propertyName.equals(this.issue.getVariation())) {
                    return TRUE_REFERENCE;
                }
                return FALSE_REFERENCE;
            }
            for (Parameter parameter : AuditELContext.parameters(this.rule)) {
                String name = parameter.getName();
                if (!propertyName.equals(name)) continue;
                if (this.issue == null) {
                    return new DeferredValueReference(parameter.getType());
                }
                return new ImmediateValueReference(this.issue.getParameterValue(propertyName), parameter.getType());
            }
            throw new PropertyNotFoundException(BUNDLE.get("resolution-failed-issue", new Object[]{propertyName, this.rule.id()}));
        }

        @Override
        public List<FeatureDescriptor> getFeatureDescriptors() {
            ArrayList<FeatureDescriptor> descriptors = new ArrayList<FeatureDescriptor>();
            for (String variation : AuditELContext.variations(this.rule)) {
                FeatureDescriptor descriptor = new FeatureDescriptor();
                descriptor.setName(variation);
                descriptor.setValue("type", Boolean.class);
                descriptor.setValue("resolvableAtDesignTime", false);
                descriptors.add(descriptor);
            }
            for (Parameter parameter : AuditELContext.parameters(this.rule)) {
                FeatureDescriptor descriptor = new FeatureDescriptor();
                descriptor.setName(parameter.getName());
                descriptor.setValue("type", parameter.getType());
                descriptor.setValue("resolvableAtDesignTime", false);
                descriptors.add(descriptor);
            }
            return descriptors;
        }
    }

    private abstract class RootContainer
    implements Container {
        private RootContainer() {
        }

        @Override
        public Reference getReference(String propertyName) {
            if (AuditELContext.this.expression != null) {
                Class type = AuditELContext.this.expression.getExpectedType();
                if (TypeSafeEnumeration.class.isAssignableFrom(type)) {
                    Object value = TypeSafeEnumerationFactory.factory(type).value(propertyName);
                    if (value != null) {
                        return new ImmediateValueReference(value, type);
                    }
                } else if (Enum.class.isAssignableFrom(type)) {
                    Enum[] values;
                    for (Enum value : values = (Enum[])type.getEnumConstants()) {
                        String name = value.name();
                        if (!propertyName.equalsIgnoreCase(name)) continue;
                        return new ImmediateValueReference(value, type);
                    }
                }
            }
            return null;
        }

        protected void getFeatureDescriptors(List<FeatureDescriptor> descriptors) {
            block2: {
                Class type;
                block3: {
                    if (AuditELContext.this.expression == null) break block2;
                    type = AuditELContext.this.expression.getExpectedType();
                    if (!TypeSafeEnumeration.class.isAssignableFrom(type)) break block3;
                    for (String tag : TypeSafeEnumerationFactory.factory(type).getTags()) {
                        FeatureDescriptor descriptor = new FeatureDescriptor();
                        descriptor.setName(tag);
                        descriptor.setValue("type", type);
                        descriptor.setValue("resolvableAtDesignTime", true);
                        descriptors.add(descriptor);
                    }
                    break block2;
                }
                if (!Enum.class.isAssignableFrom(type)) break block2;
                for (Enum value : (Enum[])type.getEnumConstants()) {
                    FeatureDescriptor descriptor = new FeatureDescriptor();
                    descriptor.setName(value.name());
                    descriptor.setValue("type", type);
                    descriptor.setValue("resolvableAtDesignTime", true);
                    descriptors.add(descriptor);
                }
            }
        }
    }
}

