/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.util.jdbc;

import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Locale;
import java.util.Vector;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.db.DataDescriptor;
import oracle.bali.dbUI.db.DataDescriptorProvider;
import oracle.bali.dbUI.db.Relationship;
import oracle.bali.dbUI.db.Schema;
import oracle.bali.dbUI.db.Table;
import oracle.bali.dbUI.db.impl.ColumnImpl;
import oracle.bali.dbUI.db.impl.RelationshipImpl;

public class JDBCTable
extends Table
implements DataDescriptorProvider {
    private static final int _COLUMN_NAME = 4;
    private static final int _DATA_TYPE = 5;
    private static final int _COLUMN_SIZE = 7;
    private static final int _DECIMAL_DIGITS = 9;
    private static final int _NULLABLE = 11;
    private static final int _ORDINAL = 17;
    private static final int _DEFAULT = 13;
    private static final int _PK_COLUMN_NAME = 4;
    private static final int _FK_COLUMN_NAME = 4;
    private static final int _FK_TABLE_NAME = 3;
    private static final int _FK_FK_COLUMN_NAME = 8;
    private static final int _FK_NAME = 12;
    private static final int _EK_COLUMN_NAME = 4;
    private static final int _EK_TABLE_NAME = 7;
    private static final int _EK_FK_COLUMN_NAME = 8;
    private static final int _EK_NAME = 12;
    private Connection _connection;
    private String _tableName;
    private Schema _schema;
    private Column[] _columns;
    private Column[] _primaryKey;
    private Relationship[] _foreignKey;
    private Relationship[] _exportedKey;
    private final Object _RESULTS_OBJECT = new Object();

    public JDBCTable(Connection connection, Schema schema, String tableName) {
        this._tableName = tableName;
        this._connection = connection;
        this._schema = schema;
    }

    @Override
    public Schema getSchema() {
        return this._schema;
    }

    @Override
    public String getName() {
        return this._tableName;
    }

    @Override
    public String getDisplayName(Locale locale) {
        return this.getName();
    }

    @Override
    public int getColumnCount() {
        Column[] columns = this._getColumns();
        return columns == null ? 0 : columns.length;
    }

    @Override
    public Column getColumn(int index) {
        Column[] columns = this._getColumns();
        return columns == null ? null : columns[index];
    }

    public Column getColumn(String columnName) {
        Column[] columns = this._getColumns();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!columns[i].getName().equals(columnName)) continue;
            return columns[i];
        }
        return null;
    }

    @Override
    public String getColumnDisplayName(int index, Locale locale) {
        return this.getColumnName(index);
    }

    @Override
    public String getColumnName(int index) {
        Column[] columns = this._getColumns();
        return columns == null ? null : columns[index].getName();
    }

    public synchronized Column[] getColumns() {
        if (this._columns == null) {
            this._columns = this.createColumns();
        }
        return this._columns;
    }

    @Override
    public int getDescriptorCount() {
        return this.getColumnCount();
    }

    @Override
    public DataDescriptor getDescriptor(int index) {
        return this.getColumn(index);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    @Override
    public int getPrimaryKeyCount() {
        if (this._primaryKey == null) {
            this._primaryKey = this._createPrimaryKey();
        }
        return this._primaryKey == null ? 0 : this._primaryKey.length;
    }

    @Override
    public Column getPrimaryKey(int index) {
        if (this._primaryKey == null) {
            this._primaryKey = this._createPrimaryKey();
        }
        return this._primaryKey == null ? null : this._primaryKey[index];
    }

    @Override
    public int getForeignKeyCount() {
        if (this._foreignKey == null) {
            this._foreignKey = this.createForeignKey();
        }
        return this._foreignKey == null ? 0 : this._foreignKey.length;
    }

    @Override
    public Relationship getForeignKey(int index) {
        if (this._foreignKey == null) {
            this._foreignKey = this.createForeignKey();
        }
        return this._foreignKey == null ? null : this._foreignKey[index];
    }

    @Override
    public int getUniqueKeyCount() {
        return 0;
    }

    @Override
    public Column getUniqueKey(int index) {
        return null;
    }

    @Override
    public int getExportedKeyCount() {
        if (this._exportedKey == null) {
            this._exportedKey = this.createExportedKey();
        }
        return this._exportedKey == null ? 0 : this._exportedKey.length;
    }

    @Override
    public Relationship getExportedKey(int index) {
        if (this._exportedKey == null) {
            this._exportedKey = this.createExportedKey();
        }
        return this._exportedKey == null ? null : this._exportedKey[index];
    }

    public Connection getConnection() {
        return this._connection;
    }

    public String toString() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Column[] createColumns() {
        Object[] columns = null;
        try {
            ResultSet data = this._connection.getMetaData().getColumns(null, this._getSchemaName(), this.getName(), null);
            Vector<ColumnImpl> temp = new Vector<ColumnImpl>();
            int dataType = 0;
            Object object = this._RESULTS_OBJECT;
            synchronized (object) {
                while (data.next()) {
                    String name;
                    String label = name = data.getString(4);
                    dataType = data.getInt(5);
                    int decimalDigits = data.getInt(9);
                    Class type = this._getClass(dataType, decimalDigits);
                    int nullable = data.getInt(11);
                    boolean allowsNull = nullable == 1;
                    String defaultValue = data.getString(13);
                    ColumnImpl column = new ColumnImpl(name, label, type, allowsNull, defaultValue, this);
                    temp.addElement(column);
                }
            }
            columns = new Column[temp.size()];
            if (temp.size() != 0) {
                temp.copyInto(columns);
            }
            data.close();
        }
        catch (SQLException e) {
            System.err.println("A SQLException occured " + e);
        }
        return columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Relationship[] createForeignKey() {
        Relationship[] key = null;
        try {
            int count = 0;
            DatabaseMetaData data = this._connection.getMetaData();
            Relationship[] temp = new Relationship[data.getMaxColumnsInTable()];
            ResultSet results = data.getImportedKeys(null, this._getSchemaName(), this.getName());
            Object object = this._RESULTS_OBJECT;
            synchronized (object) {
                while (results.next()) {
                    String refColumnName = results.getString(4);
                    String refTableName = results.getString(3);
                    String childColumnName = results.getString(8);
                    String keyName = results.getString(12);
                    JDBCTable refTable = new JDBCTable(this._connection, this.getSchema(), refTableName);
                    Column refColumn = refTable.getColumn(refColumnName);
                    Column childColumn = this.getColumn(childColumnName);
                    temp[count] = new RelationshipImpl(childColumn, refColumn, keyName);
                    ++count;
                }
            }
            key = new Relationship[count];
            System.arraycopy(temp, 0, key, 0, count);
            results.close();
        }
        catch (SQLException e) {
            System.err.println("A SQLException has occured: " + e);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Relationship[] createExportedKey() {
        Relationship[] key = null;
        try {
            int count = 0;
            DatabaseMetaData data = this._connection.getMetaData();
            Relationship[] temp = new Relationship[data.getMaxColumnsInTable()];
            ResultSet results = data.getExportedKeys(null, this._getSchemaName(), this.getName());
            Object object = this._RESULTS_OBJECT;
            synchronized (object) {
                while (results.next()) {
                    String refColumnName = results.getString(4);
                    String childColumnName = results.getString(8);
                    String childTableName = results.getString(7);
                    String keyName = results.getString(12);
                    JDBCTable childTable = new JDBCTable(this._connection, this.getSchema(), childTableName);
                    Column refColumn = this.getColumn(refColumnName);
                    Column childColumn = childTable.getColumn(childColumnName);
                    temp[count] = new RelationshipImpl(childColumn, refColumn, keyName);
                    ++count;
                }
            }
            key = new Relationship[count];
            System.arraycopy(temp, 0, key, 0, count);
            results.close();
        }
        catch (SQLException e) {
            System.err.println("A SQLException has occured: " + e);
        }
        return key;
    }

    private Column[] _getColumns() {
        if (this._columns == null) {
            this._columns = this.createColumns();
        }
        return this._columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Column[] _createPrimaryKey() {
        Column[] key = null;
        try {
            int count = 0;
            DatabaseMetaData data = this._connection.getMetaData();
            Column[] temp = new Column[data.getMaxColumnsInTable()];
            ResultSet results = data.getPrimaryKeys(null, this._getSchemaName(), this.getName());
            Object object = this._RESULTS_OBJECT;
            synchronized (object) {
                while (results.next()) {
                    String columnName = results.getString(4);
                    temp[count] = this.getColumn(columnName);
                    ++count;
                }
            }
            key = new Column[count];
            System.arraycopy(temp, 0, key, 0, count);
            results.close();
        }
        catch (SQLException e) {
            System.err.println("A SQLException has occured: " + e);
        }
        return key;
    }

    private Class _getClass(int sqlType, int digits) {
        return switch (sqlType) {
            case -6, -5, 4, 5 -> Long.class;
            case -4, -3, -2, 1111 -> Object.class;
            case -7 -> Boolean.class;
            case 91 -> Date.class;
            case 92 -> Time.class;
            case 93 -> Timestamp.class;
            case 2, 3, 7, 8 -> {
                if (digits == 0) {
                    yield Long.class;
                }
                yield Double.class;
            }
            case 6 -> Float.class;
            case 1 -> Character.class;
            case -1, 12 -> String.class;
            default -> null;
        };
    }

    private String _getSchemaName() {
        Schema s = this.getSchema();
        return s == null ? null : s.getName();
    }
}

