/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.resultsTable;

import java.text.Collator;
import oracle.bali.ewt.model.AbstractTwoDModel;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.NullTwoDModel;
import oracle.bali.ewt.model.Sortable;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.model.TwoDModelAdapter;
import oracle.bali.ewt.model.TwoDModelEvent;
import oracle.bali.ewt.model.TwoDModelListener;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.Sort;
import oracle.bali.share.sort.StringComparator;

class SortableWrapper
extends AbstractTwoDModel
implements Sortable {
    ArrayOneDModel _comparators;
    int _lastColumn;
    boolean _lastOrder;
    private TwoDModel _model;
    private ArrayOneDModel _sortedData;
    private Comparator _defaultComparator;
    private RowComparator _sorter;

    public SortableWrapper() {
        this(null);
    }

    public SortableWrapper(TwoDModel model) {
        if (model == null) {
            model = NullTwoDModel.getTwoDModel();
        }
        this._model = model;
        this._model.addModelListener((TwoDModelListener)new Listen());
        this._sorter = new RowComparator();
        this._lastColumn = -1;
        this._sortedData = new ArrayOneDModel(0);
    }

    public TwoDModel getModel() {
        return this._model;
    }

    public int getColumnCount() {
        return this.getModel().getColumnCount();
    }

    public int getRowCount() {
        return this.getModel().getRowCount();
    }

    public Object getData(int columnIndex, int rowIndex) {
        rowIndex = this._getRowIndex(rowIndex);
        return this.getModel().getData(columnIndex, rowIndex);
    }

    public void setData(int columnIndex, int rowIndex, Object data) {
        rowIndex = this._getRowIndex(rowIndex);
        this.getModel().setData(columnIndex, rowIndex, data);
    }

    public void setColumnComparator(int column, Comparator c) {
        if (this._comparators == null) {
            this._comparators = new ArrayOneDModel(this.getColumnCount());
        }
        this._comparators.setData(column, (Object)c);
    }

    public Comparator getColumnComparator(int column) {
        Comparator c;
        if (this._comparators != null && (c = (Comparator)this._comparators.getData(column)) != null) {
            return c;
        }
        return this.getDefaultComparator();
    }

    public Comparator getDefaultComparator() {
        if (this._defaultComparator == null) {
            this._defaultComparator = new StringComparator(Collator.getInstance());
        }
        return this._defaultComparator;
    }

    public void setDefaultComparator(Comparator comparator) {
        this._defaultComparator = comparator;
    }

    public void sort(int column, boolean ascending) {
        Comparator c = this.getColumnComparator(column);
        this._sorter.setComparisonData(c, ascending);
        int count = this.getRowCount();
        Object[] data = new Row[count];
        for (int i = 0; i < count; ++i) {
            data[i] = new Row(this._model.getData(column, i), i);
        }
        Sort.qSort((Object[])data, (int)data.length, (Comparator)this._sorter);
        this._sortedData.removeItems(0, count);
        this._sortedData.addItems(0, data);
        this._lastColumn = column;
        this._lastOrder = ascending;
        this.fireModelEvent(2007, 0, this.getColumnCount(), 0, this.getRowCount());
    }

    void fireEvent(int id, int index, int count) {
        this.fireModelEvent(id, index, count);
    }

    void resort() {
        if (this._lastColumn == -1) {
            this.fireModelEvent(2007, 0, this.getColumnCount(), 0, this.getRowCount());
        } else {
            this.sort(this._lastColumn, this._lastOrder);
        }
    }

    private int _getRowIndex(int index) {
        if (this._lastColumn == -1) {
            return index;
        }
        Row row = (Row)this._sortedData.getData(index);
        return row.getIndex();
    }

    class Listen
    extends TwoDModelAdapter {
        Listen() {
        }

        public void columnsAdded(TwoDModelEvent e) {
            int start = e.getColumnStartIndex();
            int count = e.getColumnCount();
            if (start <= SortableWrapper.this._lastColumn) {
                SortableWrapper.this._lastColumn += count;
            }
            if (SortableWrapper.this._comparators != null) {
                SortableWrapper.this._comparators.addItems(start, count);
            }
            SortableWrapper.this.fireEvent(2001, start, count);
        }

        public void columnsRemoved(TwoDModelEvent e) {
            int start = e.getColumnStartIndex();
            int count = e.getColumnCount();
            if (SortableWrapper.this._comparators != null) {
                SortableWrapper.this._comparators.removeItems(start, count);
            }
            SortableWrapper.this.fireEvent(2002, start, count);
            if (start <= SortableWrapper.this._lastColumn) {
                if (start + count >= SortableWrapper.this._lastColumn) {
                    SortableWrapper.this._lastColumn = -1;
                    SortableWrapper.this.resort();
                } else {
                    SortableWrapper.this._lastColumn -= count;
                }
            }
        }

        public void rowsAdded(TwoDModelEvent e) {
            int start = e.getRowStartIndex();
            int count = e.getRowCount();
            SortableWrapper.this.fireEvent(2004, start, count);
            SortableWrapper.this.resort();
        }

        public void rowsRemoved(TwoDModelEvent e) {
            int start = e.getRowStartIndex();
            int count = e.getRowCount();
            SortableWrapper.this.fireEvent(2005, start, count);
            SortableWrapper.this.resort();
        }

        public void invalidateRows(TwoDModelEvent e) {
            SortableWrapper.this.resort();
        }

        public void invalidateColumns(TwoDModelEvent e) {
            int start = e.getColumnStartIndex();
            int count = e.getColumnCount();
            if (start <= SortableWrapper.this._lastColumn && start + count >= SortableWrapper.this._lastColumn) {
                SortableWrapper.this.resort();
            }
        }

        public void invalidateCells(TwoDModelEvent e) {
            int start = e.getColumnStartIndex();
            int count = e.getColumnCount();
            if (start <= SortableWrapper.this._lastColumn && start + count >= SortableWrapper.this._lastColumn) {
                SortableWrapper.this.resort();
            }
        }
    }

    private class RowComparator
    implements Comparator {
        private boolean _ascending;
        private Comparator _compare;

        private RowComparator() {
        }

        public int compare(Object o1, Object o2) {
            Row row1 = (Row)o1;
            Row row2 = (Row)o2;
            Object data1 = row1.getData();
            Object data2 = row2.getData();
            if (this._ascending) {
                return this._compare.compare(data1, data2);
            }
            return this._compare.compare(data2, data1);
        }

        public void setComparisonData(Comparator c, boolean ascending) {
            this._compare = c;
            this._ascending = ascending;
        }
    }

    private class Row {
        private Object _data;
        private int _index;

        public Row(Object data, int index) {
            this._data = data;
            this._index = index;
        }

        public Object getData() {
            return this._data;
        }

        public int getIndex() {
            return this._index;
        }
    }
}

