/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.index;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.Ide;
import oracle.ide.file.FileSet;
import oracle.ide.file.Path;
import oracle.ide.index.Index;
import oracle.ide.index.IndexManager;
import oracle.ide.index.Indexer;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLPath;
import oracle.ideimpl.index.IndexImpl;
import oracle.javatools.util.MultiMap;
import oracle.javatools.util.NullArgumentException;

public class IndexManagerImpl
extends IndexManager {
    private MultiMap<Class<? extends Node>, Class<? extends Indexer>> indexers = new MultiMap();
    private ArrayList<Class<? extends Indexer>> genericIndexers = new ArrayList();

    @Override
    public Index getIndex(Workspace workspace) {
        if (workspace == null) {
            throw new NullArgumentException("workspace is null");
        }
        return new IndexImpl(workspace);
    }

    @Override
    public Index getIndex(Workspace workspace, ContentSet content) {
        if (workspace == null) {
            throw new NullArgumentException("workspace is null");
        }
        if (content == null) {
            throw new NullArgumentException("content set is null");
        }
        return new IndexImpl(workspace, content);
    }

    @Override
    public Index getIndex(Workspace workspace, URLPath path) {
        if (workspace == null) {
            throw new NullArgumentException("workspace is null");
        }
        if (path == null) {
            throw new NullArgumentException("path is null");
        }
        return new IndexImpl(workspace, path);
    }

    @Override
    public Index getIndex(Workspace workspace, URL url) {
        if (workspace == null) {
            throw new NullArgumentException("workspace is null");
        }
        if (url == null) {
            throw new NullArgumentException("url is null");
        }
        return new IndexImpl(workspace, url);
    }

    @Override
    public Index getIndex(Workspace workspace, Project project) {
        if (workspace == null) {
            throw new NullArgumentException("workspace is null");
        }
        if (project == null) {
            throw new NullArgumentException("project is null");
        }
        return new IndexImpl(workspace, project);
    }

    @Override
    public Index getIndex(Workspace workspace, Project project, ContentSet content) {
        if (workspace == null) {
            throw new NullArgumentException("workspace is null");
        }
        if (project == null) {
            throw new NullArgumentException("project is null");
        }
        if (content == null) {
            throw new NullArgumentException("content set is null");
        }
        return new IndexImpl(workspace, project, content);
    }

    @Override
    public Index getIndex(Workspace workspace, Project project, URLPath path) {
        if (workspace == null) {
            throw new NullArgumentException("workspace is null");
        }
        if (project == null) {
            throw new NullArgumentException("project is null");
        }
        if (path == null) {
            throw new NullArgumentException("path is null");
        }
        return new IndexImpl(workspace, project, path);
    }

    @Override
    public Index getIndex(Workspace workspace, Project project, Path path) {
        if (workspace == null) {
            throw new NullArgumentException("workspace is null");
        }
        if (project == null) {
            throw new NullArgumentException("null project");
        }
        if (path == null) {
            throw new NullArgumentException("null path");
        }
        return new IndexImpl(workspace, project, path);
    }

    @Override
    public Index getIndex(Workspace workspace, Project project, FileSet fileSet) {
        if (workspace == null) {
            throw new NullArgumentException("workspace is null");
        }
        if (project == null) {
            throw new NullArgumentException("null project");
        }
        if (fileSet == null) {
            throw new NullArgumentException("null file set");
        }
        return new IndexImpl(workspace, project, fileSet);
    }

    @Override
    public Index getIndex(Workspace workspace, Project project, URL url) {
        if (workspace == null) {
            throw new NullArgumentException("workspace is null");
        }
        if (project == null) {
            throw new NullArgumentException("project is null");
        }
        if (url == null) {
            throw new NullArgumentException("url is null");
        }
        return new IndexImpl(workspace, project, url);
    }

    @Override
    public Index getIndex(Project project) {
        if (project == null) {
            throw new IllegalArgumentException("project is null");
        }
        return new IndexImpl(IndexManagerImpl.getWorkspace(project), project);
    }

    @Override
    public Index getIndex(Project project, ContentSet content) {
        if (project == null) {
            throw new IllegalArgumentException("project is null");
        }
        return new IndexImpl(IndexManagerImpl.getWorkspace(project), project, content);
    }

    @Override
    public Index getIndex(Project project, URLPath path) {
        if (project == null) {
            throw new IllegalArgumentException("project is null");
        }
        if (path == null) {
            throw new NullArgumentException("path is null");
        }
        return new IndexImpl(IndexManagerImpl.getWorkspace(project), project, path);
    }

    @Override
    public Index getIndex(Project project, URL url) {
        if (project == null) {
            throw new IllegalArgumentException("project is null");
        }
        if (url == null) {
            throw new NullArgumentException("url is null");
        }
        return new IndexImpl(IndexManagerImpl.getWorkspace(project), project, url);
    }

    private static Workspace getWorkspace(Project project) {
        Workspace workspace = project.getWorkspace();
        return workspace == null ? Ide.getActiveWorkspace() : workspace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addIndexer(Class<? extends Indexer> indexer) {
        ArrayList<Class<? extends Indexer>> arrayList = this.genericIndexers;
        synchronized (arrayList) {
            this.genericIndexers.add(indexer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addIndexer(Class<? extends Node> nodeClass, Class<? extends Indexer> indexer) {
        MultiMap<Class<? extends Node>, Class<? extends Indexer>> multiMap = this.indexers;
        synchronized (multiMap) {
            this.indexers.add(nodeClass, indexer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Class<? extends Indexer>> getIndexers() {
        ArrayList<Class<? extends Indexer>> arrayList = this.genericIndexers;
        synchronized (arrayList) {
            return (List)this.genericIndexers.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MultiMap<Class<? extends Node>, Class<? extends Indexer>> getIndexerMap() {
        MultiMap<Class<? extends Node>, Class<? extends Indexer>> multiMap = this.indexers;
        synchronized (multiMap) {
            return new MultiMap(this.indexers);
        }
    }
}

