/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.util;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class ArrayListHeap {
    private static final int MAX_COUNT = 40;
    private static final int MAX_LIST_SIZE = 250;
    private static final ConcurrentLinkedQueue<ArrayList<? extends Object>> freeQueue = new ConcurrentLinkedQueue();
    private static AtomicInteger freeQueueCount = new AtomicInteger(0);

    protected static <T> ArrayList<T> allocArrayList() {
        ArrayList<Object> list = freeQueue.poll();
        if (list == null) {
            list = new ArrayList(250);
        } else {
            freeQueueCount.decrementAndGet();
        }
        return list;
    }

    protected static <T> void freeArrayList(ArrayList<T> list) {
        int count;
        if (list != null && (count = freeQueueCount.get()) < 40 && list.size() <= 250) {
            list.clear();
            freeQueue.add(list);
            freeQueueCount.incrementAndGet();
        }
    }
}

