/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceSwitchElement;
import oracle.javatools.parser.java.v2.model.SourceSwitchStatementGroup;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceSwitchLabel;

public class SwitchStatementGroupSym
extends TreeSym
implements SourceSwitchStatementGroup {
    private final SourceSwitchElement switchElement;
    private final SourceBlock block;
    private final List<SourceSwitchLabel> labels;
    private final List<SourceElement> elements;

    public SwitchStatementGroupSym(SourceSwitchElement switchElement, SourceBlock block, List<SourceSwitchLabel> labels, List<SourceElement> elements) {
        this.switchElement = switchElement;
        this.block = block;
        this.labels = labels;
        this.elements = elements;
        this.symFile = ((Sym)((Object)labels.get((int)0))).symFile;
        this.symParent = (Sym)((Object)block);
        this.symStart = ((Sym)((Object)labels.get((int)0))).symStart;
        this.symEnd = elements.isEmpty() ? ((Sym)((Object)labels.get((int)(labels.size() - 1)))).symEnd : ((Sym)elements.get((int)(elements.size() - 1))).symEnd;
    }

    @Override
    public final SourceSwitchElement getOwningSwitch() {
        return this.switchElement;
    }

    @Override
    public SourceBlock getOwningBlock() {
        return this.block;
    }

    @Override
    public boolean isDefault() {
        for (SourceSwitchLabel label : this.labels) {
            if (!label.isDefault()) continue;
            return true;
        }
        return false;
    }

    @Override
    public final List<SourceExpression> getExpressions() {
        if (this.isDefault()) {
            return Collections.emptyList();
        }
        ArrayList<SourceExpression> expressions = new ArrayList<SourceExpression>();
        for (SourceSwitchLabel label : this.labels) {
            expressions.addAll(label.getExpressions());
        }
        return expressions;
    }

    @Override
    public List<SourceElement> getElements() {
        return this.elements;
    }

    @Override
    public List<SourceSwitchLabel> getLabels() {
        return this.labels;
    }
}

