/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.css;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import oracle.javatools.parser.css.CSSBundle;
import oracle.javatools.parser.css.ParseException;
import oracle.javatools.parser.css.TokenizerUtil;

abstract class CSSTokenizer {
    protected static final int ERROR = -1;
    protected int line = 1;
    protected int column;
    protected int current;
    protected boolean _currentCharIsEscaped;
    protected int position;
    protected int type;
    protected int start;
    protected int end;
    protected int blankCharacters;
    protected String errorMessage;

    CSSTokenizer() {
    }

    public abstract boolean returnCompleteToken();

    protected abstract boolean returnErrorToken();

    public void reset() {
        this.setPosition(0, 1, 0);
    }

    public void setPosition(int newPosition, int newLine, int newColumn) {
        try {
            this.start = 0;
            this.end = newPosition;
            this.position = newPosition;
            this.column = newColumn;
            this.line = newLine;
            this.type = 13;
            this.setCurrentChar(this.nextChar());
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getType() {
        return this.type;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void scanAtRule() throws ParseException {
        try {
            block11: while (true) {
                switch (this.current) {
                    case 123: {
                        int brackets = 1;
                        block12: while (true) {
                            this.nextChar();
                            switch (this.current) {
                                case 125: {
                                    if (--brackets > 0) continue block12;
                                }
                                case -1: {
                                    break block11;
                                }
                                case 123: {
                                    ++brackets;
                                }
                            }
                        }
                    }
                    case -1: 
                    case 59: {
                        break block11;
                    }
                    default: {
                        this.nextChar();
                        continue block11;
                    }
                }
                break;
            }
            this.end = this.position;
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    public int scanTillOneOf(char char1, char char2) throws ParseException {
        try {
            block5: while (true) {
                switch (this.current) {
                    case -1: {
                        break block5;
                    }
                    default: {
                        if (char1 == this.current || char2 == this.current) break block5;
                        this.nextChar();
                        continue block5;
                    }
                }
                break;
            }
            this.end = this.position;
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
        return this.current;
    }

    public void moveForwardOneChar() throws ParseException {
        try {
            this.nextChar();
        }
        catch (IOException ioe) {
            throw new ParseException(ioe);
        }
    }

    public void setStartStringToCurrent() {
        this.start = this.position - 1;
    }

    public int next() throws ParseException {
        this.blankCharacters = 0;
        this.start = this.position - 1;
        this.type = 13;
        this.nextToken();
        this.end = this.position - this.endGap();
        if (!this.returnErrorToken() && this.type == -1) {
            throw new ParseException(this.errorMessage, this.line, this.column);
        }
        return this.type;
    }

    protected int endGap() {
        int result;
        int n = result = this.current == -1 ? 0 : 1;
        if (this.returnCompleteToken()) {
            return result;
        }
        switch (this.type) {
            case 19: 
            case 42: 
            case 43: 
            case 52: {
                ++result;
                break;
            }
            case 18: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 64: 
            case 70: 
            case 71: 
            case 74: 
            case 75: 
            case 76: {
                result += 2;
                break;
            }
            case 47: 
            case 48: 
            case 50: 
            case 65: 
            case 77: {
                result += 3;
                break;
            }
            case 49: 
            case 66: 
            case 67: 
            case 72: 
            case 73: 
            case 80: {
                result += 4;
            }
        }
        return result + this.blankCharacters;
    }

    protected final void setCurrentChar(int current, boolean escaped) {
        this.current = current;
        this._currentCharIsEscaped = escaped;
    }

    protected final void setCurrentChar(int current) {
        this.setCurrentChar(current, false);
    }

    protected final boolean isCurrentCharEscaped() {
        return this._currentCharIsEscaped;
    }

    protected final void setCurrentCharEscaped(boolean currentCharIsEscaped) {
        this._currentCharIsEscaped = currentCharIsEscaped;
    }

    protected int getCurrentChar() {
        return this.current;
    }

    protected void nextToken() throws ParseException {
        try {
            switch (this.current) {
                case -1: {
                    this.type = 0;
                    return;
                }
                case 123: {
                    this.nextChar();
                    this.type = 1;
                    return;
                }
                case 125: {
                    this.nextChar();
                    this.type = 2;
                    return;
                }
                case 61: {
                    this.nextChar();
                    this.type = 3;
                    return;
                }
                case 43: {
                    this.nextChar();
                    this.type = 4;
                    return;
                }
                case 44: {
                    this.nextChar();
                    this.type = 6;
                    return;
                }
                case 59: {
                    this.nextChar();
                    this.type = 8;
                    return;
                }
                case 62: {
                    this.nextChar();
                    this.type = 9;
                    return;
                }
                case 91: {
                    this.nextChar();
                    this.type = 11;
                    return;
                }
                case 93: {
                    this.nextChar();
                    this.type = 12;
                    return;
                }
                case 42: {
                    this.nextChar();
                    if (this.current == 61) {
                        this.nextChar();
                        this.type = 57;
                        return;
                    }
                    this.type = 13;
                    return;
                }
                case 40: {
                    this.nextChar();
                    this.type = 14;
                    return;
                }
                case 41: {
                    this.nextChar();
                    this.type = 15;
                    return;
                }
                case 58: {
                    if (this.nextChar() == 58) {
                        this.nextChar();
                        this.type = 63;
                    } else {
                        this.type = 16;
                    }
                    return;
                }
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 32: {
                    do {
                        this.nextChar();
                    } while (TokenizerUtil.isCSSSpace((char)this.current));
                    this.type = 17;
                    return;
                }
                case 47: {
                    this.nextChar();
                    if (this.current != 42) {
                        this.type = 10;
                        return;
                    }
                    this.nextChar();
                    if (!this.returnCompleteToken()) {
                        this.start = this.position - 1;
                    }
                    while (true) {
                        if (this.current != -1 && this.current != 42) {
                            this.nextChar();
                            continue;
                        }
                        do {
                            this.nextChar();
                        } while (this.current != -1 && this.current == 42);
                        if (this.current == -1 || this.current == 47) break;
                    }
                    if (this.current == -1) {
                        this.type = -1;
                        this.errorMessage = CSSTokenizer.getBundle().getString("MSG_UNEXPECTED_EOF");
                        return;
                    }
                    this.nextChar();
                    this.type = 18;
                    return;
                }
                case 39: {
                    this.type = this.string1();
                    return;
                }
                case 34: {
                    this.type = this.string2();
                    return;
                }
                case 60: {
                    this.nextChar();
                    if (this.current != 33) {
                        this.type = -1;
                        this.errorMessage = CSSTokenizer.format("MSG_EXPECTING_INSTEAD_OF_CHAR", "!");
                        return;
                    }
                    this.nextChar();
                    if (this.current == 45) {
                        this.nextChar();
                        if (this.current == 45) {
                            this.nextChar();
                            this.type = 21;
                            return;
                        }
                    }
                    this.type = -1;
                    this.errorMessage = CSSTokenizer.format("MSG_EXPECTING_INSTEAD_OF_CHAR", "-");
                    return;
                }
                case 45: {
                    this.Ident();
                    if (this.type == -1) {
                        return;
                    }
                    if (this.type == 20) {
                        if (this.current == 40) {
                            this.nextChar();
                            this.type = 52;
                            return;
                        }
                        return;
                    }
                    if (this.current != 45) {
                        this.type = 5;
                        return;
                    }
                    this.nextChar();
                    if (this.current == 62) {
                        this.nextChar();
                        this.type = 22;
                        return;
                    }
                    this.type = -1;
                    this.errorMessage = CSSTokenizer.format("MSG_EXPECTING_INSTEAD_OF_CHAR", ">");
                    return;
                }
                case 124: {
                    this.nextChar();
                    if (this.current == 61) {
                        this.nextChar();
                        this.type = 25;
                        return;
                    }
                    this.type = 56;
                    return;
                }
                case 126: {
                    this.nextChar();
                    if (this.current == 61) {
                        this.nextChar();
                        this.type = 26;
                        return;
                    }
                    this.type = 60;
                    return;
                }
                case 94: {
                    this.nextChar();
                    if (this.current == 61) {
                        this.nextChar();
                        this.type = 58;
                        return;
                    }
                    this.type = 61;
                    return;
                }
                case 36: {
                    this.nextChar();
                    if (this.current == 61) {
                        this.nextChar();
                        this.type = 59;
                        return;
                    }
                    this.type = 62;
                    return;
                }
                case 35: {
                    this.nextChar();
                    if (TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                        if (!this.returnCompleteToken()) {
                            this.start = this.position - 1;
                        }
                        do {
                            this.nextChar();
                            if (this.current != 92) continue;
                            this.nextChar();
                            this.escape();
                            if (this.type != -1) continue;
                            return;
                        } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
                        this.type = 27;
                        return;
                    }
                    this.type = -1;
                    this.errorMessage = CSSTokenizer.format("MSG_EXPECTING_INSTEAD_OF_CHAR", CSSTokenizer.getBundle().getString("NAME"));
                    return;
                }
                case 64: {
                    this.nextChar();
                    switch (this.current) {
                        case 67: 
                        case 99: {
                            int secondChar;
                            if (!this.returnCompleteToken()) {
                                this.start = this.position - 1;
                            }
                            if (CSSTokenizer.isEqualIgnoreCase(secondChar = this.nextChar(), 'h')) {
                                if (!CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 'a') || !CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 'r') || !CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 's') || !CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 'e') || !CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 't')) break;
                                this.nextChar();
                                this.type = 30;
                                return;
                            }
                            if (!CSSTokenizer.isEqualIgnoreCase(secondChar, 'o') || !CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 'u') || !CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 'n') || !CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 't') || !CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 'e') || !CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 'r') || !CSSTokenizer.isEqualIgnoreCase(this.nextChar(), '-') || !CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 's') || !CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 't') || !CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 'y') || !CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 'l') || !CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 'e')) break;
                            this.nextChar();
                            this.type = 69;
                            return;
                        }
                        case 70: 
                        case 102: {
                            if (!this.returnCompleteToken()) {
                                this.start = this.position - 1;
                            }
                            if (!CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 'o') || !CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 'n') || !CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 't') || !CSSTokenizer.isEqualIgnoreCase(this.nextChar(), '-') || !CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 'f') || !CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 'a') || !CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 'c') || !CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 'e')) break;
                            this.nextChar();
                            this.type = 31;
                            return;
                        }
                        case 73: 
                        case 105: {
                            if (!this.returnCompleteToken()) {
                                this.start = this.position - 1;
                            }
                            if (!CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 'm') || !CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 'p') || !CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 'o') || !CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 'r') || !CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 't')) break;
                            this.nextChar();
                            this.type = 28;
                            return;
                        }
                        case 77: 
                        case 109: {
                            if (!this.returnCompleteToken()) {
                                this.start = this.position - 1;
                            }
                            if (!CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 'e') || !CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 'd') || !CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 'i') || !CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 'a')) break;
                            this.nextChar();
                            this.type = 32;
                            return;
                        }
                        case 78: 
                        case 110: {
                            if (!this.returnCompleteToken()) {
                                this.start = this.position - 1;
                            }
                            if (!CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 'a') || !CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 'm') || !CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 'e') || !CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 's') || !CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 'p') || !CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 'a') || !CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 'c') || !CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 'e')) break;
                            this.nextChar();
                            this.type = 55;
                            return;
                        }
                        case 80: 
                        case 112: {
                            if (!this.returnCompleteToken()) {
                                this.start = this.position - 1;
                            }
                            if (!CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 'a') || !CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 'g') || !CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 'e')) break;
                            this.nextChar();
                            this.type = 33;
                            return;
                        }
                        case 82: 
                        case 114: {
                            if (!this.returnCompleteToken()) {
                                this.start = this.position - 1;
                            }
                            if (!CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 'e') || !CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 'g') || !CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 'i') || !CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 'o') || !CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 'n')) break;
                            this.nextChar();
                            this.type = 68;
                            return;
                        }
                        case 45: {
                            if (!this.returnCompleteToken()) {
                                this.start = this.position - 1;
                            }
                            if (TokenizerUtil.isCSSIdentifierNMStartCharacter((char)this.nextChar())) break;
                            this.type = -1;
                            this.errorMessage = CSSTokenizer.format("MSG_EXPECTING_INSTEAD_OF_CHAR", CSSTokenizer.getBundle().getString("IDENTIFIER"));
                            return;
                        }
                        default: {
                            if (!TokenizerUtil.isCSSIdentifierNMStartCharacter((char)this.current)) {
                                this.type = -1;
                                this.errorMessage = CSSTokenizer.format("MSG_EXPECTING_INSTEAD_OF_CHAR", CSSTokenizer.getBundle().getString("IDENTIFIER"));
                                return;
                            }
                            if (this.returnCompleteToken()) break;
                            this.start = this.position - 1;
                        }
                    }
                    if (TokenizerUtil.isCSSSpace((char)this.current)) {
                        this.type = 29;
                        return;
                    }
                    do {
                        this.nextChar();
                        if (this.current != 92) continue;
                        this.nextChar();
                        this.escape();
                        if (this.type != -1) continue;
                        return;
                    } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current) && !TokenizerUtil.isCSSSpace((char)this.current));
                    this.type = 29;
                    return;
                }
                case 33: {
                    do {
                        this.nextChar();
                    } while (this.current != -1 && TokenizerUtil.isCSSSpace((char)this.current));
                    if (CSSTokenizer.isEqualIgnoreCase(this.current, 'i') && CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 'm') && CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 'p') && CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 'o') && CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 'r') && CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 't') && CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 'a') && CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 'n') && CSSTokenizer.isEqualIgnoreCase(this.nextChar(), 't')) {
                        this.nextChar();
                        this.type = 23;
                        return;
                    }
                    if (this.current == -1) {
                        this.type = -1;
                        this.errorMessage = CSSTokenizer.getBundle().getString("MSG_UNEXPECTED_EOF");
                        return;
                    }
                    this.type = -1;
                    this.errorMessage = CSSTokenizer.format("MSG_EXPECTING_INSTEAD_OF_CHAR", "!important");
                    return;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.type = this.number();
                    return;
                }
                case 46: {
                    switch (this.nextChar()) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            this.type = this.dotNumber();
                            return;
                        }
                    }
                    this.type = 7;
                    return;
                }
                case 85: 
                case 117: {
                    this.nextChar();
                    switch (this.current) {
                        case 43: {
                            boolean range = false;
                            block72: for (int i = 0; i < 6; ++i) {
                                this.nextChar();
                                switch (this.current) {
                                    case 63: {
                                        range = true;
                                        continue block72;
                                    }
                                    default: {
                                        if (!range || TokenizerUtil.isCSSHexadecimalCharacter((char)this.current)) continue block72;
                                        this.type = -1;
                                        this.errorMessage = CSSTokenizer.format("MSG_EXPECTING_INSTEAD_OF_CHAR", CSSTokenizer.getBundle().getString("HEX"));
                                        return;
                                    }
                                }
                            }
                            this.nextChar();
                            if (range) {
                                this.type = 53;
                                return;
                            }
                            if (this.current == 45) {
                                this.nextChar();
                                if (!TokenizerUtil.isCSSHexadecimalCharacter((char)this.current)) {
                                    this.type = -1;
                                    this.errorMessage = CSSTokenizer.format("MSG_EXPECTING_INSTEAD_OF_CHAR", CSSTokenizer.getBundle().getString("HEX"));
                                    return;
                                }
                                this.nextChar();
                                if (!TokenizerUtil.isCSSHexadecimalCharacter((char)this.current)) {
                                    this.type = 53;
                                    return;
                                }
                                this.nextChar();
                                if (!TokenizerUtil.isCSSHexadecimalCharacter((char)this.current)) {
                                    this.type = 53;
                                    return;
                                }
                                this.nextChar();
                                if (!TokenizerUtil.isCSSHexadecimalCharacter((char)this.current)) {
                                    this.type = 53;
                                    return;
                                }
                                this.nextChar();
                                if (!TokenizerUtil.isCSSHexadecimalCharacter((char)this.current)) {
                                    this.type = 53;
                                    return;
                                }
                                this.nextChar();
                                if (!TokenizerUtil.isCSSHexadecimalCharacter((char)this.current)) {
                                    this.type = 53;
                                    return;
                                }
                                this.nextChar();
                                this.type = 53;
                                return;
                            }
                        }
                        case 82: 
                        case 114: {
                            this.nextChar();
                            switch (this.current) {
                                case 76: 
                                case 108: {
                                    this.nextChar();
                                    switch (this.current) {
                                        case 40: {
                                            do {
                                                this.nextChar();
                                            } while (this.current != -1 && TokenizerUtil.isCSSSpace((char)this.current));
                                            switch (this.current) {
                                                case 39: {
                                                    this.type = this.string1();
                                                    if (this.type == -1) {
                                                        return;
                                                    }
                                                    this.blankCharacters += 2;
                                                    while (this.current != -1 && TokenizerUtil.isCSSSpace((char)this.current)) {
                                                        ++this.blankCharacters;
                                                        this.nextChar();
                                                    }
                                                    if (this.current == -1) {
                                                        this.type = -1;
                                                        this.errorMessage = CSSTokenizer.getBundle().getString("MSG_UNEXPECTED_EOF");
                                                        return;
                                                    }
                                                    if (this.current != 41) {
                                                        this.type = -1;
                                                        this.errorMessage = CSSTokenizer.format("MSG_EXPECTING_INSTEAD_OF_CHAR", ")");
                                                        return;
                                                    }
                                                    this.nextChar();
                                                    this.type = 51;
                                                    return;
                                                }
                                                case 34: {
                                                    this.type = this.string2();
                                                    if (this.type == -1) {
                                                        return;
                                                    }
                                                    this.blankCharacters += 2;
                                                    while (this.current != -1 && TokenizerUtil.isCSSSpace((char)this.current)) {
                                                        ++this.blankCharacters;
                                                        this.nextChar();
                                                    }
                                                    if (this.current == -1) {
                                                        this.type = -1;
                                                        this.errorMessage = CSSTokenizer.getBundle().getString("MSG_UNEXPECTED_EOF");
                                                        return;
                                                    }
                                                    if (this.current != 41) {
                                                        this.type = -1;
                                                        this.errorMessage = CSSTokenizer.format("MSG_EXPECTING_INSTEAD_OF_CHAR", ")");
                                                        return;
                                                    }
                                                    this.nextChar();
                                                    this.type = 51;
                                                    return;
                                                }
                                                case 41: {
                                                    this.type = -1;
                                                    this.errorMessage = CSSTokenizer.format("MSG_UNEXPECTED_CHAR", ")");
                                                    return;
                                                }
                                            }
                                            if (!TokenizerUtil.isCSSURICharacter((char)this.current)) {
                                                this.type = -1;
                                                this.errorMessage = CSSTokenizer.format("MSG_EXPECTING_INSTEAD_OF_CHAR", CSSTokenizer.getBundle().getString("URI_CHAR"));
                                                return;
                                            }
                                            if (!this.returnCompleteToken()) {
                                                this.start = this.position - 1;
                                            }
                                            do {
                                                this.nextChar();
                                            } while (this.current != -1 && TokenizerUtil.isCSSURICharacter((char)this.current));
                                            ++this.blankCharacters;
                                            while (this.current != -1 && TokenizerUtil.isCSSSpace((char)this.current)) {
                                                ++this.blankCharacters;
                                                this.nextChar();
                                            }
                                            if (this.current == -1) {
                                                this.type = -1;
                                                this.errorMessage = CSSTokenizer.getBundle().getString("MSG_UNEXPECTED_EOF");
                                                return;
                                            }
                                            if (this.current != 41) {
                                                this.type = -1;
                                                this.errorMessage = CSSTokenizer.format("MSG_EXPECTING_INSTEAD_OF_CHAR", ")");
                                                return;
                                            }
                                            this.nextChar();
                                            this.type = 51;
                                            return;
                                        }
                                    }
                                }
                            }
                        }
                    }
                    while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current) || this.current == 92) {
                        if (this.current == 92) {
                            this.nextChar();
                            this.escape();
                            if (this.type != -1) continue;
                            return;
                        }
                        this.nextChar();
                    }
                    if (this.current == 40) {
                        this.nextChar();
                        this.type = 52;
                        return;
                    }
                    this.type = 20;
                    return;
                }
                case 92: {
                    this.nextChar();
                    this.escape(false);
                    if (this.type != -1) break;
                    return;
                }
            }
            this.Ident();
            if (this.type == -1) {
                return;
            }
            if (this.type == 20) {
                if (this.current == 40) {
                    this.nextChar();
                    this.type = 52;
                    return;
                }
                return;
            }
            char currentChar = (char)this.current;
            this.nextChar();
            this.type = -1;
            this.end = this.position - this.endGap();
            String stringValue = Character.toString(currentChar);
            this.errorMessage = CSSTokenizer.format("MSG_EXPECTING_INSTEAD_OF_THE_CHAR", stringValue, CSSTokenizer.getBundle().getString("IDENTIFIER"));
            return;
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    protected int string1() throws IOException {
        if (!this.returnCompleteToken()) {
            this.start = this.position;
        }
        boolean moveNext = true;
        block9: while (true) {
            if (moveNext) {
                this.nextChar();
            }
            switch (this.current) {
                case -1: {
                    this.errorMessage = CSSTokenizer.getBundle().getString("MSG_UNEXPECTED_EOF");
                    return -1;
                }
                case 39: {
                    moveNext = true;
                    break block9;
                }
                case 34: {
                    moveNext = true;
                    continue block9;
                }
                case 92: {
                    switch (this.nextChar()) {
                        case 10: 
                        case 12: {
                            moveNext = true;
                            continue block9;
                        }
                    }
                    this.escape();
                    moveNext = false;
                    if (this.type != -1) continue block9;
                    return -1;
                }
                default: {
                    if (!TokenizerUtil.isCSSStringCharacter((char)this.current)) {
                        this.errorMessage = CSSTokenizer.getBundle().getString("MSG_AN_UNEXPECTED_CHAR");
                        return -1;
                    }
                    moveNext = true;
                    continue block9;
                }
            }
            break;
        }
        this.nextChar();
        return 19;
    }

    protected int string2() throws IOException {
        if (!this.returnCompleteToken()) {
            this.start = this.position;
        }
        boolean moveNext = true;
        block9: while (true) {
            if (moveNext) {
                this.nextChar();
            }
            switch (this.current) {
                case -1: {
                    this.errorMessage = CSSTokenizer.getBundle().getString("MSG_UNEXPECTED_EOF");
                    return -1;
                }
                case 39: {
                    moveNext = true;
                    continue block9;
                }
                case 34: {
                    moveNext = true;
                    break block9;
                }
                case 92: {
                    switch (this.nextChar()) {
                        case 10: 
                        case 12: {
                            moveNext = true;
                            continue block9;
                        }
                    }
                    this.escape();
                    moveNext = false;
                    if (this.type != -1) continue block9;
                    return -1;
                }
                default: {
                    if (!TokenizerUtil.isCSSStringCharacter((char)this.current)) {
                        this.errorMessage = CSSTokenizer.getBundle().getString("MSG_AN_UNEXPECTED_CHAR");
                        return -1;
                    }
                    moveNext = true;
                    continue block9;
                }
            }
            break;
        }
        this.nextChar();
        return 19;
    }

    protected int number() throws IOException {
        block7: while (true) {
            switch (this.nextChar()) {
                case 46: {
                    switch (this.nextChar()) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            return this.dotNumber();
                        }
                    }
                    this.errorMessage = CSSTokenizer.format("MSG_EXPECTING_INSTEAD_OF_CHAR", CSSTokenizer.getBundle().getString("DIGIT"));
                    return -1;
                }
                default: {
                    break block7;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    continue block7;
                }
            }
            break;
        }
        return this.numberUnit(true);
    }

    protected int dotNumber() throws IOException {
        block3: while (true) {
            switch (this.nextChar()) {
                default: {
                    break block3;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    continue block3;
                }
            }
            break;
        }
        return this.numberUnit(false);
    }

    protected int numberUnit(boolean integer) throws IOException {
        switch (this.current) {
            case 37: {
                this.nextChar();
                return 42;
            }
            case 67: 
            case 99: {
                switch (this.nextChar()) {
                    case 72: 
                    case 104: {
                        this.nextChar();
                        if (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                            do {
                                this.nextChar();
                            } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
                            return 34;
                        }
                        return 75;
                    }
                    case 77: 
                    case 109: {
                        this.nextChar();
                        if (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                            do {
                                this.nextChar();
                            } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
                            return 34;
                        }
                        return 37;
                    }
                }
                while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                    this.nextChar();
                }
                return 34;
            }
            case 68: 
            case 100: {
                switch (this.nextChar()) {
                    case 66: 
                    case 98: {
                        this.nextChar();
                        if (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                            do {
                                this.nextChar();
                            } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
                            return 34;
                        }
                        return 76;
                    }
                    case 69: 
                    case 101: {
                        switch (this.nextChar()) {
                            case 71: 
                            case 103: {
                                this.nextChar();
                                if (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                                    do {
                                        this.nextChar();
                                    } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
                                    return 34;
                                }
                                return 47;
                            }
                        }
                    }
                    case 80: 
                    case 112: {
                        switch (this.nextChar()) {
                            case 73: 
                            case 105: {
                                this.nextChar();
                                if (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                                    do {
                                        this.nextChar();
                                    } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
                                    return 34;
                                }
                                return 65;
                            }
                            case 67: 
                            case 99: {
                                switch (this.nextChar()) {
                                    case 77: 
                                    case 109: {
                                        this.nextChar();
                                        if (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                                            do {
                                                this.nextChar();
                                            } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
                                            return 34;
                                        }
                                        return 66;
                                    }
                                }
                                while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                                    this.nextChar();
                                }
                                return 34;
                            }
                            case 80: 
                            case 112: {
                                switch (this.nextChar()) {
                                    case 88: 
                                    case 120: {
                                        this.nextChar();
                                        if (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                                            do {
                                                this.nextChar();
                                            } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
                                            return 34;
                                        }
                                        return 67;
                                    }
                                }
                                while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                                    this.nextChar();
                                }
                                return 34;
                            }
                        }
                        while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                            this.nextChar();
                        }
                        return 34;
                    }
                }
                while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                    this.nextChar();
                }
                return 34;
            }
            case 69: 
            case 101: {
                switch (this.nextChar()) {
                    case 77: 
                    case 109: {
                        this.nextChar();
                        if (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                            do {
                                this.nextChar();
                            } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
                            return 34;
                        }
                        return 36;
                    }
                    case 88: 
                    case 120: {
                        this.nextChar();
                        if (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                            do {
                                this.nextChar();
                            } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
                            return 34;
                        }
                        return 35;
                    }
                }
                while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                    this.nextChar();
                }
                return 34;
            }
            case 70: 
            case 102: {
                switch (this.nextChar()) {
                    case 82: 
                    case 114: {
                        this.nextChar();
                        if (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                            do {
                                this.nextChar();
                            } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
                            return 34;
                        }
                        return 64;
                    }
                }
                while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                    this.nextChar();
                }
                return 34;
            }
            case 71: 
            case 103: {
                switch (this.nextChar()) {
                    case 82: 
                    case 114: {
                        switch (this.nextChar()) {
                            case 65: 
                            case 97: {
                                switch (this.nextChar()) {
                                    case 68: 
                                    case 100: {
                                        this.nextChar();
                                        if (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                                            do {
                                                this.nextChar();
                                            } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
                                            return 34;
                                        }
                                        return 49;
                                    }
                                }
                            }
                        }
                    }
                }
                while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                    this.nextChar();
                }
                return 34;
            }
            case 72: 
            case 104: {
                this.nextChar();
                switch (this.current) {
                    case 90: 
                    case 122: {
                        this.nextChar();
                        if (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                            do {
                                this.nextChar();
                            } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
                            return 34;
                        }
                        return 41;
                    }
                }
                while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                    this.nextChar();
                }
                return 34;
            }
            case 73: 
            case 105: {
                switch (this.nextChar()) {
                    case 78: 
                    case 110: {
                        this.nextChar();
                        if (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                            do {
                                this.nextChar();
                            } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
                            return 34;
                        }
                        return 39;
                    }
                }
                while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                    this.nextChar();
                }
                return 34;
            }
            case 75: 
            case 107: {
                switch (this.nextChar()) {
                    case 72: 
                    case 104: {
                        switch (this.nextChar()) {
                            case 90: 
                            case 122: {
                                this.nextChar();
                                if (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                                    do {
                                        this.nextChar();
                                    } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
                                    return 34;
                                }
                                return 50;
                            }
                        }
                    }
                }
                while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                    this.nextChar();
                }
                return 34;
            }
            case 77: 
            case 109: {
                switch (this.nextChar()) {
                    case 77: 
                    case 109: {
                        this.nextChar();
                        if (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                            do {
                                this.nextChar();
                            } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
                            return 34;
                        }
                        return 38;
                    }
                    case 83: 
                    case 115: {
                        this.nextChar();
                        if (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                            do {
                                this.nextChar();
                            } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
                            return 34;
                        }
                        return 40;
                    }
                }
                while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                    this.nextChar();
                }
                return 34;
            }
            case 80: 
            case 112: {
                switch (this.nextChar()) {
                    case 67: 
                    case 99: {
                        this.nextChar();
                        if (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                            do {
                                this.nextChar();
                            } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
                            return 34;
                        }
                        return 44;
                    }
                    case 84: 
                    case 116: {
                        this.nextChar();
                        if (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                            do {
                                this.nextChar();
                            } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
                            return 34;
                        }
                        return 45;
                    }
                    case 88: 
                    case 120: {
                        this.nextChar();
                        if (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                            do {
                                this.nextChar();
                            } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
                            return 34;
                        }
                        return 46;
                    }
                }
                while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                    this.nextChar();
                }
                return 34;
            }
            case 82: 
            case 114: {
                switch (this.nextChar()) {
                    case 65: 
                    case 97: {
                        switch (this.nextChar()) {
                            case 68: 
                            case 100: {
                                this.nextChar();
                                if (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                                    do {
                                        this.nextChar();
                                    } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
                                    return 34;
                                }
                                return 48;
                            }
                        }
                    }
                    case 69: 
                    case 101: {
                        switch (this.nextChar()) {
                            case 77: 
                            case 109: {
                                this.nextChar();
                                if (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                                    do {
                                        this.nextChar();
                                    } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
                                    return 34;
                                }
                                return 77;
                            }
                        }
                        while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                            this.nextChar();
                        }
                        return 34;
                    }
                }
                while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                    this.nextChar();
                }
                return 34;
            }
            case 83: 
            case 115: {
                switch (this.nextChar()) {
                    case 84: 
                    case 116: {
                        this.nextChar();
                        return 74;
                    }
                }
                if (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                    do {
                        this.nextChar();
                    } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
                    return 34;
                }
                return 43;
            }
            case 84: 
            case 116: {
                switch (this.nextChar()) {
                    case 85: 
                    case 117: {
                        switch (this.nextChar()) {
                            case 82: 
                            case 114: {
                                switch (this.nextChar()) {
                                    case 78: 
                                    case 110: {
                                        this.nextChar();
                                        if (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                                            do {
                                                this.nextChar();
                                            } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
                                            return 34;
                                        }
                                        return 73;
                                    }
                                }
                            }
                        }
                    }
                }
                while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                    this.nextChar();
                }
                return 34;
            }
            case 86: 
            case 118: {
                block99 : switch (this.nextChar()) {
                    case 72: 
                    case 104: {
                        this.nextChar();
                        if (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                            do {
                                this.nextChar();
                            } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
                            return 34;
                        }
                        return 71;
                    }
                    case 87: 
                    case 119: {
                        this.nextChar();
                        if (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                            do {
                                this.nextChar();
                            } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
                            return 34;
                        }
                        return 70;
                    }
                    case 77: 
                    case 109: {
                        switch (this.nextChar()) {
                            case 73: 
                            case 105: {
                                switch (this.nextChar()) {
                                    case 78: 
                                    case 110: {
                                        this.nextChar();
                                        if (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                                            do {
                                                this.nextChar();
                                            } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
                                            return 34;
                                        }
                                        return 72;
                                    }
                                }
                                break block99;
                            }
                            case 65: 
                            case 97: {
                                switch (this.nextChar()) {
                                    case 88: 
                                    case 120: {
                                        this.nextChar();
                                        if (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                                            do {
                                                this.nextChar();
                                            } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
                                            return 34;
                                        }
                                        return 80;
                                    }
                                }
                            }
                        }
                    }
                }
                while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current)) {
                    this.nextChar();
                }
                return 34;
            }
        }
        if (this.current != -1 && TokenizerUtil.isCSSIdentifierNMStartCharacter((char)this.current)) {
            do {
                this.nextChar();
            } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
            return 34;
        }
        return integer ? 24 : 54;
    }

    protected final void escape() throws IOException {
        this.escape(true);
    }

    protected void escape(boolean moveToNextChar) throws IOException {
        int escPosition = this.position - 2;
        if (TokenizerUtil.isCSSHexadecimalCharacter((char)this.current)) {
            this.nextChar();
            if (!TokenizerUtil.isCSSHexadecimalCharacter((char)this.current)) {
                if (TokenizerUtil.isCSSSpace((char)this.current)) {
                    this.replaceEscapeSequance(escPosition, this.position);
                    if (moveToNextChar) {
                        this.nextChar();
                    }
                } else {
                    this.replaceEscapeSequance(escPosition, this.position - 1);
                }
                return;
            }
            this.nextChar();
            if (!TokenizerUtil.isCSSHexadecimalCharacter((char)this.current)) {
                if (TokenizerUtil.isCSSSpace((char)this.current)) {
                    this.replaceEscapeSequance(escPosition, this.position);
                    if (moveToNextChar) {
                        this.nextChar();
                    }
                } else {
                    this.replaceEscapeSequance(escPosition, this.position - 1);
                }
                return;
            }
            this.nextChar();
            if (!TokenizerUtil.isCSSHexadecimalCharacter((char)this.current)) {
                if (TokenizerUtil.isCSSSpace((char)this.current)) {
                    this.replaceEscapeSequance(escPosition, this.position);
                    if (moveToNextChar) {
                        this.nextChar();
                    }
                } else {
                    this.replaceEscapeSequance(escPosition, this.position - 1);
                }
                return;
            }
            this.nextChar();
            if (!TokenizerUtil.isCSSHexadecimalCharacter((char)this.current)) {
                if (TokenizerUtil.isCSSSpace((char)this.current)) {
                    this.replaceEscapeSequance(escPosition, this.position);
                    if (moveToNextChar) {
                        this.nextChar();
                    }
                } else {
                    this.replaceEscapeSequance(escPosition, this.position - 1);
                }
                return;
            }
            this.nextChar();
            if (!TokenizerUtil.isCSSHexadecimalCharacter((char)this.current)) {
                if (TokenizerUtil.isCSSSpace((char)this.current)) {
                    this.replaceEscapeSequance(escPosition, this.position);
                    if (moveToNextChar) {
                        this.nextChar();
                    }
                } else {
                    this.replaceEscapeSequance(escPosition, this.position - 1);
                }
                return;
            }
            this.replaceEscapeSequance(escPosition, this.position);
            if (moveToNextChar) {
                this.nextChar();
            }
            return;
        }
        if (this.current >= 32 && this.current <= 126 || this.current >= 128) {
            this.replaceEscapeSequance(escPosition, this.position);
            if (moveToNextChar) {
                this.nextChar();
            }
            return;
        }
        this.type = -1;
        this.errorMessage = CSSTokenizer.getBundle().getString("MSG_AN_UNEXPECTED_CHAR");
    }

    protected void replaceEscapeSequance(int escStart, int escEnd) {
    }

    protected static boolean isEqualIgnoreCase(int i, char c) {
        return i == -1 ? false : Character.toLowerCase((char)i) == c;
    }

    protected abstract int nextChar() throws IOException;

    private void Ident() throws IOException {
        if (this.current == 45) {
            this.nextChar();
        }
        if (this.isCurrentCharEscaped() || TokenizerUtil.isCSSIdentifierNMStartCharacter((char)this.current)) {
            do {
                this.nextChar();
                while (this.current == 92) {
                    this.nextChar();
                    this.escape();
                    if (this.type != -1) continue;
                    return;
                }
            } while (this.current != -1 && TokenizerUtil.isCSSNameCharacter((char)this.current));
            this.type = 20;
        }
    }

    private static String format(String key, Object param1) {
        return CSSTokenizer.format(key, new Object[]{param1});
    }

    private static String format(String key, Object param1, Object param2) {
        return CSSTokenizer.format(key, new Object[]{param1, param2});
    }

    private static String format(String key, Object[] params) {
        String s = CSSTokenizer.getBundle().getString(key);
        return MessageFormat.format(s, params);
    }

    private static ResourceBundle getBundle() {
        return ResourceBundle.getBundle(CSSBundle.class.getName());
    }
}

