/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import oracle.olapi.syntax.DataObject;
import oracle.olapi.syntax.NumberExpression;
import oracle.olapi.syntax.StringExpression;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.TypedExpression;
import oracle.olapi.syntax.ValidationContext;

public final class SimpleCase
extends DataObject {
    private TypedExpression m_WhenExpression = null;
    private TypedExpression m_ThenExpression = null;

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.append("WHEN ");
        syntaxPrintingContext.print(this.getWhenExpression());
        syntaxPrintingContext.append(" THEN ");
        syntaxPrintingContext.print(this.getThenExpression());
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.push(this);
        this.m_WhenExpression = validationContext.validateExp(this.m_WhenExpression);
        this.m_ThenExpression = validationContext.validateExp(this.m_ThenExpression);
        validationContext.pop();
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        return this.getWhenExpression().isDefinitionComplete() && this.getThenExpression().isDefinitionComplete();
    }

    public SimpleCase(TypedExpression typedExpression, TypedExpression typedExpression2) {
        SimpleCase.validateValue(typedExpression);
        SimpleCase.validateValue(typedExpression2);
        this.m_WhenExpression = typedExpression;
        this.m_ThenExpression = typedExpression2;
        this.initialize();
    }

    public SimpleCase(int n, TypedExpression typedExpression) {
        this(new NumberExpression(n), typedExpression);
    }

    public SimpleCase(String string, TypedExpression typedExpression) {
        this(new StringExpression(string), typedExpression);
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitSimpleCase(this, object);
    }

    public TypedExpression getWhenExpression() {
        return this.m_WhenExpression;
    }

    public TypedExpression getThenExpression() {
        return this.m_ThenExpression;
    }

    @Override
    public boolean isCompositeObject() {
        return true;
    }
}

