/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util.encoding;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.util.encoding.Decoder;
import oracle.dbtools.util.encoding.Encoding;
import oracle.dbtools.util.encoding.EncodingException;
import oracle.dbtools.util.encoding.EncodingType;
import oracle.dbtools.util.encoding.MimeType;

public class URIEncoding
extends Encoding
implements Decoder {
    public URIEncoding(MimeType mimeType) {
        super(EncodingType.ENCODING_URI, mimeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decode(Reader in, Writer out) throws URISyntaxException, IOException {
        boolean throwing = true;
        StringBuffer fileValue = new StringBuffer();
        int c = in.read();
        while (c != -1) {
            fileValue.append((char)c);
            c = in.read();
        }
        URI uri = new URI(fileValue.toString());
        File iFile = new File(uri);
        FileReader fr = new FileReader(iFile);
        try {
            BufferedReader ir = new BufferedReader(fr);
            int x = ir.read();
            while (x != -1) {
                out.write(x);
                x = ir.read();
            }
            out.flush();
            throwing = false;
        }
        finally {
            try {
                fr.close();
            }
            catch (IOException e) {
                if (throwing) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getLocalizedMessage(), e);
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decode(Reader in, OutputStream out) throws URISyntaxException, IOException {
        boolean throwing = true;
        StringBuffer fileValue = new StringBuffer();
        Reader is = in;
        OutputStream os = out;
        int c = is.read();
        while (c != -1) {
            fileValue.append((char)c);
            c = is.read();
        }
        URI uri = new URI(fileValue.toString());
        File iFile = new File(uri);
        FileInputStream fi = new FileInputStream(iFile);
        try {
            BufferedInputStream ir = new BufferedInputStream(fi);
            int x = ir.read();
            while (x != -1) {
                os.write(x);
                x = ir.read();
            }
            os.flush();
            throwing = false;
        }
        finally {
            try {
                fi.close();
            }
            catch (IOException e) {
                if (throwing) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getLocalizedMessage(), e);
                }
                throw e;
            }
        }
    }

    @Override
    public void decodeStream(Object in, Object out) throws EncodingException, IOException {
        try {
            if (out instanceof OutputStream) {
                this.decode((Reader)in, (OutputStream)out);
            } else {
                this.decode((Reader)in, (Writer)out);
            }
        }
        catch (URISyntaxException e) {
            throw new EncodingException(e);
        }
    }

    @Override
    public long getDecodeLength(long len) throws EncodingException {
        throw new EncodingException("Length of output cannot be reliably determined.");
    }

    @Override
    public int getDecodeBlocksize() {
        return 1;
    }
}

