/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import oracle.dbtools.raptor.utils.WindowsRegistry;
import oracle.dbtools.raptor.utils.WindowsUtility;

class WindowsRegistryImpl
implements WindowsRegistry {
    static final WindowsRegistryImpl INSTANCE = new WindowsRegistryImpl();

    private WindowsRegistryImpl() {
    }

    static WindowsRegistry instance() {
        return INSTANCE;
    }

    @Override
    public WindowsRegistry.Node node(WindowsRegistry.KeyHandle keyHandle, String path) {
        return new NodeImpl(keyHandle, path);
    }

    private static class NodeImpl
    implements WindowsRegistry.Node {
        private final WindowsRegistry.KeyHandle hkey;
        private final String path;

        private NodeImpl(WindowsRegistry.KeyHandle hkey, String path) {
            this.hkey = hkey;
            this.path = path;
        }

        @Override
        public Set<String> keys() {
            try {
                List<String> subKeys = WindowsUtility.readStringSubKeys(this.hkey.id(), this.path);
                return subKeys == null ? Collections.emptySet() : Collections.unmodifiableSet(new LinkedHashSet<String>(subKeys));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public String textValue(CharSequence name) {
            try {
                return WindowsUtility.readString(this.hkey.id(), this.path, name.toString());
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public WindowsRegistry.Node node(CharSequence path) {
            String fullPath = this.path + "\\" + path;
            return new NodeImpl(this.hkey, fullPath);
        }
    }
}

