/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.container;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import oracle.dbtools.raptor.newscriptrunner.util.container.Lifecycle;
import oracle.dbtools.raptor.newscriptrunner.util.container.ProviderFactory;

public class Container
implements AutoCloseable {
    private final Map<String, ComponentEntry<?>> componentMap;
    private final List<ProviderFactory<?>> providerFactories;

    public Container() {
        this.providerFactories = LoadedFactories.get();
        this.componentMap = this.buildComponentMap();
    }

    public Container(List<ProviderFactory<?>> factories) {
        this.providerFactories = new ArrayList(factories);
        this.componentMap = this.buildComponentMap();
    }

    public Container copy() {
        return new Container(this);
    }

    @Override
    public void close() {
        this.componentMap.values().forEach(e -> e.closeProviders());
        this.componentMap.clear();
    }

    public <S> S getService(Class<S> type) {
        String typeName = type.getName();
        ComponentEntry<?> entry = this.componentMap.get(typeName);
        if (entry == null) {
            throw new IllegalArgumentException("service type '" + typeName + "' not found");
        }
        return (S)entry.getService();
    }

    private Container(Container copyFrom) {
        this.providerFactories = copyFrom.providerFactories;
        this.componentMap = this.buildComponentMap();
        this.copyProviders(copyFrom);
    }

    private Map<String, ComponentEntry<?>> buildComponentMap() {
        LinkedHashMap newMap = new LinkedHashMap();
        try {
            LinkedHashMap lookupMap = new LinkedHashMap();
            StringBuilder errorBuff = new StringBuilder();
            this.providerFactories.forEach(f -> {
                Class type = f.getType();
                String typeName = type.getName();
                ProviderLookupEntry lookupEntry = (ProviderLookupEntry)lookupMap.get(typeName);
                if (lookupEntry == null) {
                    ComponentEntry componentEntry = new ComponentEntry(type);
                    newMap.put(typeName, componentEntry);
                    lookupEntry = new ProviderLookupEntry(f.getType(), componentEntry);
                    lookupMap.put(typeName, lookupEntry);
                }
                if (!lookupEntry.addComponentBuilderFor((ProviderFactory<?>)f)) {
                    if (errorBuff.length() == 0) {
                        errorBuff.append("found multiple implementations of service providers for:");
                    }
                    errorBuff.append("\n    ").append(typeName);
                }
            });
            if (errorBuff.length() > 0) {
                throw new IllegalArgumentException(errorBuff.toString());
            }
            ProviderLookup lookup = new ProviderLookup(lookupMap);
            lookupMap.values().forEach(e -> e.buildServiceIf(lookup));
        }
        catch (RuntimeException ex) {
            throw new IllegalArgumentException("unable to build container", ex);
        }
        return newMap;
    }

    private void copyProviders(Container copyFrom) {
        this.componentMap.keySet().forEach(typeName -> {
            ComponentEntry<?> componentEntry = this.componentMap.get(typeName);
            componentEntry.copyProviders(copyFrom.componentMap.get(typeName));
        });
    }

    private static class ComponentBuilder<P> {
        private final ProviderFactory<P> factory;
        private Component<P> component;
        private boolean building;

        ComponentBuilder(ProviderFactory<P> factory) {
            this.factory = factory;
        }

        ProviderFactory<P> getFactory() {
            return this.factory;
        }

        Component<P> getComponent(ProviderLookup lookup) {
            if (this.component == null) {
                if (this.building) {
                    throw new IllegalArgumentException("circular dependency detected for component '" + this.factory.getType().getName() + "'");
                }
                this.building = true;
                try {
                    CreateContext context = new CreateContext(lookup);
                    this.component = new Component<P>(this.factory.create(context), context.getLifecycle());
                }
                finally {
                    this.building = false;
                }
            }
            return this.component;
        }
    }

    private static class ProviderLookupEntry<P> {
        private final Class<P> type;
        private final ComponentEntry<P> componentEntry;
        private boolean serviceBuilt;
        private boolean featuresBuilt;
        private ComponentBuilder<P> serviceBuilder;
        private final List<ComponentBuilder<P>> featureBuilders = new ArrayList<ComponentBuilder<P>>();
        private P service;
        private List<P> features;

        ProviderLookupEntry(Class<P> type, ComponentEntry<P> componentEntry) {
            this.type = type;
            this.componentEntry = componentEntry;
        }

        boolean addComponentBuilderFor(ProviderFactory<?> factory) {
            switch (factory.getRole()) {
                case SERVICE: {
                    if (this.serviceBuilder != null && this.serviceBuilder.getFactory().getRole() != ProviderFactory.Role.DEFAULT) {
                        return false;
                    }
                    this.serviceBuilder = new ComponentBuilder(factory);
                    break;
                }
                case DEFAULT: {
                    if (this.serviceBuilder != null) break;
                    this.serviceBuilder = new ComponentBuilder(factory);
                    break;
                }
                default: {
                    this.featureBuilders.add(new ComponentBuilder(factory));
                }
            }
            return true;
        }

        Class<P> getType() {
            return this.type;
        }

        P getService(ProviderLookup lookup) {
            this.buildServiceIf(lookup);
            return this.service;
        }

        List<P> getFeatures(ProviderLookup lookup) {
            this.buildFeaturesIf(lookup);
            return this.features;
        }

        void buildServiceIf(ProviderLookup lookup) {
            if (!this.serviceBuilt) {
                if (this.serviceBuilder != null) {
                    Component<P> component = this.serviceBuilder.getComponent(lookup);
                    this.componentEntry.setServiceComponent(component);
                    this.service = component.getProvider();
                }
                this.serviceBuilt = true;
            }
        }

        void buildFeaturesIf(ProviderLookup lookup) {
            if (!this.featuresBuilt) {
                this.features = new ArrayList<P>(this.featureBuilders.size());
                this.featureBuilders.forEach(pb -> {
                    Component component = pb.getComponent(lookup);
                    this.componentEntry.addFeatureComponent(component);
                    this.features.add(component.getProvider());
                });
                this.featuresBuilt = true;
            }
        }
    }

    private static class ProviderLookup {
        private final Map<String, ProviderLookupEntry<?>> lookupMap;

        ProviderLookup(Map<String, ProviderLookupEntry<?>> lookupMap) {
            this.lookupMap = lookupMap;
        }

        Collection<Class<?>> getProviderTypes() {
            return this.lookupMap.values().stream().map(e -> e.getType()).collect(Collectors.toUnmodifiableList());
        }

        <S> S getServiceProvider(Class<S> type) {
            String typeName = type.getName();
            ProviderLookupEntry<?> entry = this.lookupMap.get(typeName);
            if (entry == null) {
                throw new IllegalArgumentException("service provider for '" + typeName + "' not found");
            }
            return (S)entry.getService(this);
        }

        <F> Collection<F> getFeatureProviders(Class<F> type) {
            ProviderLookupEntry<?> entry = this.lookupMap.get(type.getName());
            return entry != null ? Collections.unmodifiableCollection(entry.getFeatures(this)) : Collections.EMPTY_LIST;
        }
    }

    private static class Component<P> {
        private final P provider;
        private final Lifecycle<P> lifecycle;

        Component(P provider, Lifecycle<P> lifecycle) {
            this.provider = provider;
            this.lifecycle = lifecycle != null ? lifecycle : (provider instanceof Lifecycle ? (Lifecycle)provider : null);
        }

        P getProvider() {
            return this.provider;
        }

        void copyProvider(P from) {
            if (this.lifecycle != null) {
                this.lifecycle.copy(from);
            }
        }

        void closeProvider() {
            if (this.lifecycle != null) {
                this.lifecycle.close();
            }
        }
    }

    private static class ComponentEntry<P> {
        private final Class<P> type;
        private Component<P> serviceComponent;
        private final List<Component<P>> featureComponents = new ArrayList<Component<P>>();

        ComponentEntry(Class<P> type) {
            this.type = type;
        }

        P getService() {
            if (this.serviceComponent == null) {
                throw new IllegalArgumentException("service provider for '" + this.type.getName() + "' not found");
            }
            return this.serviceComponent.getProvider();
        }

        Component<P> getServiceComponent() {
            return this.serviceComponent;
        }

        void setServiceComponent(Component serviceComponent) {
            this.serviceComponent = serviceComponent;
        }

        List<Component<P>> getFeatureComponents() {
            return this.featureComponents;
        }

        void addFeatureComponent(Component<P> featureComponent) {
            this.featureComponents.add(featureComponent);
        }

        void copyProviders(ComponentEntry<P> copyFrom) {
            HashMap fromProviderMap = new HashMap();
            Component<P> fromServiceComponent = copyFrom.getServiceComponent();
            if (fromServiceComponent != null) {
                P fromServiceProvider = fromServiceComponent.getProvider();
                fromProviderMap.put(fromServiceProvider.getClass().getName(), fromServiceProvider);
            }
            List<Component<P>> fromFeatureComponents = copyFrom.getFeatureComponents();
            fromFeatureComponents.forEach(c -> {
                Object fromFeatureProvider = c.getProvider();
                fromProviderMap.put(fromFeatureProvider.getClass().getName(), fromFeatureProvider);
            });
            if (this.serviceComponent != null) {
                this.serviceComponent.copyProvider(fromProviderMap.get(this.serviceComponent.getProvider().getClass().getName()));
            }
            this.featureComponents.forEach(c -> c.copyProvider(fromProviderMap.get(c.getProvider().getClass().getName())));
        }

        void closeProviders() {
            if (this.serviceComponent != null) {
                this.serviceComponent.closeProvider();
            }
            this.featureComponents.forEach(c -> c.closeProvider());
        }
    }

    private static class CreateContext
    implements ProviderFactory.CreateContext {
        private final ProviderLookup lookup;
        private Lifecycle<?> lifecycle;

        CreateContext(ProviderLookup lookup) {
            this.lookup = lookup;
        }

        Lifecycle<?> getLifecycle() {
            return this.lifecycle;
        }

        @Override
        public Collection<Class<?>> getProviderTypes() {
            return this.lookup.getProviderTypes();
        }

        @Override
        public <S> S getServiceProvider(Class<S> type) {
            return this.lookup.getServiceProvider(type);
        }

        @Override
        public <F> Collection<F> getFeatureProviders(Class<F> type) {
            return this.lookup.getFeatureProviders(type);
        }

        @Override
        public void setLifecycle(Lifecycle<?> lifecycle) {
            this.lifecycle = lifecycle;
        }
    }

    private static class LoadedFactories {
        private static final List<ProviderFactory<?>> loadedFactories;

        private LoadedFactories() {
        }

        static List<ProviderFactory<?>> get() {
            return loadedFactories;
        }

        static {
            ArrayList lf = new ArrayList();
            ServiceLoader.load(ProviderFactory.class).forEach(f -> lf.add(f));
            loadedFactories = Collections.unmodifiableList(lf);
        }
    }
}

