/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.completer;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.app.CompletionItem;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.completer.SemanticCompleter;

public class FileCompleter
implements SemanticCompleter {
    private static final boolean OS_IS_WINDOWS;

    @Override
    public List<CompletionItem> complete(String prefix, ScriptRunnerContext ctx, Map<String, Object> transformedOptionsMap) {
        LinkedList<CompletionItem> ret = new LinkedList<CompletionItem>();
        Object translated = prefix;
        if (OS_IS_WINDOWS) {
            prefix = prefix.replace('/', '\\');
        }
        int index = prefix.lastIndexOf(File.separator);
        File homeDir = new File(System.getProperty("user.home"));
        File userDir = new File(FileUtils.getCWD(ctx));
        if (((String)translated).startsWith("~" + File.separator)) {
            translated = homeDir.getPath() + ((String)translated).substring(1);
        } else if (((String)translated).startsWith("~")) {
            translated = homeDir.getParentFile().getAbsolutePath();
        } else if (!new File((String)translated).isAbsolute()) {
            String cwd = userDir.getAbsolutePath();
            translated = cwd + File.separator + (String)translated;
        }
        File dir = ((String)translated).endsWith(File.separator) ? new File((String)translated) : new File((String)translated).getParentFile();
        File[] files = dir == null ? new File[]{} : dir.listFiles();
        int matches = 0;
        for (File file : files) {
            if (!file.getAbsolutePath().startsWith((String)translated)) continue;
            ++matches;
        }
        for (File file : files) {
            if (!file.getAbsolutePath().startsWith((String)translated)) continue;
            String name = file.getName() + (file.isDirectory() ? File.separator : " ");
            if (0 < index) {
                name = prefix.substring(0, index) + File.separator + name;
            }
            ret.add(new CompletionItem(name, CompletionItem.Type.FILE));
        }
        return ret;
    }

    public static void main(String[] args) {
        File file = new File("");
        System.out.println(file.isDirectory());
    }

    static {
        String os = System.getProperty("os.name");
        OS_IS_WINDOWS = os.startsWith("Windows");
    }
}

