/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.StoreRegistry;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.dbtools.util.Logger;

@Restricted(level=Restricted.Level.NONE)
public class ShowErrorLogging
implements IShowCommand,
IStoreCommand {
    private static final String[] SHOWNEWPAGE = new String[]{"errorl", "errorlo", "errorlog", "errorlogg", "errorloggi", "errorloggin", "errorlogging"};

    @Override
    public String[] getShowAliases() {
        return SHOWNEWPAGE;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        try {
            if (ctx.getProperty("sqlplus.error.logging") != null) {
                boolean value = (Boolean)ctx.getProperty("sqlplus.error.logging");
                if (value) {
                    String onoff = "ON";
                    String table = "";
                    Object identifier = "";
                    String schema = null;
                    if (ctx.getProperty("sqlplus.error.logging.table") != null) {
                        String displaySchemaTable;
                        if (ctx.getProperty("sqlplus.error.logging.schema") != null && (schema = (String)ctx.getProperty("sqlplus.error.logging.schema")).equalsIgnoreCase(conn.getSchema())) {
                            schema = null;
                        }
                        if ((displaySchemaTable = (String)ctx.getProperty("sqlplus.error.logging.displayschematable")) != null && !displaySchemaTable.equals("")) {
                            table = displaySchemaTable;
                        } else {
                            table = (String)ctx.getProperty("sqlplus.error.logging.table");
                            if (schema != null) {
                                table = MessageFormat.format("{0}.{1}", schema, table);
                            }
                        }
                        table = MessageFormat.format("TABLE {0}", table);
                    }
                    if (ctx.getProperty("sqlplus.error.logging.identifier") != null && ctx.getProperty("sqlplus.error.logging.identifier").toString().length() > 0) {
                        identifier = "IDENTIFIER " + ctx.getProperty("sqlplus.error.logging.identifier");
                    }
                    ctx.write(MessageFormat.format("errorlogging is {0} {1} {2}\n", onoff, table, identifier).trim() + "\n");
                } else {
                    ctx.write("errorlogging is OFF\n");
                }
            }
        }
        catch (SQLException e) {
            Logger.fine(this.getClass(), e);
        }
        return true;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        return StoreRegistry.getCommand("newpage", String.valueOf(ctx.getProperty("script.runner.newpage")));
    }
}

