/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;

@Restricted(level=Restricted.Level.NONE)
public class ShowAutotrace
implements IShowCommand,
IStoreCommand {
    private static final String[] SHOWAUTOTRACE = new String[]{"autot", "autotr", "autotra", "autotrac", "autotrace"};

    @Override
    public String[] getShowAliases() {
        return SHOWAUTOTRACE;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        return this.doShowAutotrace(conn, ctx, cmd);
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    private String getWriteString(ScriptRunnerContext ctx) {
        Object writeOut = "autotrace ON";
        Boolean state = (Boolean)ctx.getProperty("AUTOTRACE_STATE");
        if (state == null || state.equals(Boolean.FALSE)) {
            writeOut = "autotrace OFF";
        } else {
            String type = (String)ctx.getProperty("AUTOTRACE_TYPE");
            if (type != null) {
                if (type.equals("EXPLAIN")) {
                    writeOut = (String)writeOut + " EXPLAIN";
                } else if (type.equals("ALL")) {
                    writeOut = (String)writeOut + " EXPLAIN STATISTICS";
                } else if (type.equals("STATISTICS")) {
                    writeOut = (String)writeOut + " STATISTICS";
                }
            }
        }
        return writeOut;
    }

    private boolean doShowAutotrace(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String writeOut = this.getWriteString(ctx);
        ctx.write(writeOut + "\n");
        return true;
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        String writeOut = this.getWriteString(ctx);
        return "set " + writeOut;
    }
}

