/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.connector;

import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.Connector;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorArgs;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ParseConnectionSpecArgs;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.EditionProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.NamedConnectionProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.NamedConnectionsConnector;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.PasswordProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.RoleProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.StandardFormConnectorType;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.UserProperty;

public class NamedConnectionsConnectorType
extends StandardFormConnectorType {
    private static final String SHORT_NAME = "ST";
    static final String STORE = "STORE";

    public NamedConnectionsConnectorType() {
        super(NamedConnectionsConnectorType.createSelectorProperty(STORE, SHORT_NAME), false);
        this.addProperty(NamedConnectionProperty.NAME);
        this.addProperty(UserProperty.USER);
        this.addProperty(PasswordProperty.PASSWORD);
        this.addProperty(RoleProperty.ROLE);
        this.addProperty(EditionProperty.EDITION);
    }

    @Override
    public void parseConnectionSpec(ParseConnectionSpecArgs args) {
        String name = args.getPropertyValue(NamedConnectionProperty.NAME);
        if (!ModelUtil.hasLength(name)) {
            args.addError("Connection name required");
        } else if (NamedConnectionsConnector.lookupDefinition(name) == null) {
            args.addError("Unknown connection " + name);
        } else if (ModelUtil.hasLength(args.getConnectionSpec())) {
            args.addError("Connection spec cannot be used with connection name");
        }
    }

    @Override
    public String getName() {
        return STORE;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    protected boolean isSelectorMandatory() {
        return false;
    }

    @Override
    public Connector createConnector(ConnectorArgs args) {
        return new NamedConnectionsConnector(args);
    }
}

