/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.connector;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import oracle.dbtools.core.connections.helpers.ConnectionHelper;
import oracle.dbtools.core.connections.helpers.ConnectionHelperContext;
import oracle.dbtools.core.connections.helpers.ConnectionHelperFactory;
import oracle.dbtools.core.connections.helpers.ProductConnectDetails;
import oracle.dbtools.core.connections.storage.ConnectionDefinition;
import oracle.dbtools.core.connections.storage.ConnectionStorage;
import oracle.dbtools.core.secrets.TextSecret;
import oracle.dbtools.core.util.MessageLogger;
import oracle.dbtools.plusplus.util.CommandContext;
import oracle.dbtools.raptor.newscriptrunner.ConnectionDetails;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorArgs;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.NamedConnectionProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.OracleStandardFormConnector;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.StandardFormConnector;
import oracle.jdbc.datasource.OracleDataSource;

public class NamedConnectionsConnector
extends OracleStandardFormConnector {
    private final ConnectionHelper creator;

    static ConnectionDefinition lookupDefinition(String name) {
        ConnectionStorage fileSystem = ConnectionStorage.instance();
        Optional<ConnectionDefinition> opt = fileSystem.listConnectionDirectories().stream().map(arg_0 -> ((ConnectionStorage)fileSystem).loadConnection(arg_0)).filter(def -> Objects.equals(def.getConnectionName(), name)).findFirst();
        return opt.orElse(null);
    }

    NamedConnectionsConnector(ConnectorArgs args) {
        super(args);
        CommandContext cmdCtx = CommandContext.of(args.getScriptRunnerContext(), ConnectCommand.class);
        String name = args.getPropertyValues().getValueOf(NamedConnectionProperty.NAME);
        ConnectionDefinition def = NamedConnectionsConnector.lookupDefinition(name);
        this.creator = def != null ? ConnectionHelperFactory.findHelper((ConnectionHelperContext)ConnectionHelperContext.of((ConnectionDefinition)def, (MessageLogger)cmdCtx.getMessageLogger())) : ConnectionHelperFactory.createFallbackHelper();
    }

    @Override
    protected StandardFormConnector.ConnectionRec createOracleStandardFormConnection(List<String> urlMessage, String connectDB, Properties props) {
        Connection conn = null;
        String successfulAttempt = null;
        try {
            conn = this.logConnectionURL(urlMessage, "user", this.creator.getURL(), props, true);
            successfulAttempt = connectDB;
        }
        catch (Throwable e) {
            if (e instanceof ThreadDeath) {
                throw (ThreadDeath)e;
            }
            urlMessage.add(e.getLocalizedMessage());
        }
        if (conn != null && this.creator.requiresProxySession()) {
            try {
                this.creator.createProxySession(conn);
            }
            catch (SQLException e) {
                urlMessage.add(e.getLocalizedMessage());
                try {
                    conn.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                conn = null;
                successfulAttempt = null;
            }
        }
        return new StandardFormConnector.ConnectionRec(this, conn, successfulAttempt);
    }

    @Override
    protected boolean completeConnectionDetails(Connection conn, ConnectionDetails cd) {
        boolean complete = false;
        this.creator.completeConnectionDetails((ProductConnectDetails)SqlClConnectDetails.of(cd));
        ConnectionDetails updatedDetails = this.ctx.getConnectFieldsProvider().get3Fields(this.ctx, cd, false);
        if (updatedDetails != null) {
            cd.cloneFrom(updatedDetails);
            complete = true;
        }
        return complete;
    }

    @Override
    protected void configureDataSource(OracleDataSource datasource, String url, Properties filteredProps) throws SQLException {
        datasource.setURL(url);
        datasource.setConnectionProperties(filteredProps);
        this.creator.configureDataSource(datasource);
    }

    public static final class SqlClConnectDetails
    implements ProductConnectDetails {
        private final ConnectionDetails delegate;

        public static SqlClConnectDetails of(ConnectionDetails delegate) {
            return new SqlClConnectDetails(delegate);
        }

        SqlClConnectDetails(ConnectionDetails delegate) {
            this.delegate = delegate;
        }

        public String getUsername() {
            return this.delegate.getConnectName();
        }

        public void setUsername(String user) {
            this.delegate.setConnectName(user);
        }

        public TextSecret getPassword() {
            return this.delegate.getConnectPassword();
        }

        public void setPassword(TextSecret pwd) {
            this.delegate.setConnectPassword(pwd);
        }

        public String getConnectURL() {
            return this.delegate.getConnectDB();
        }

        public void setConnectURL(String url) {
            this.delegate.setConnectDB(url);
        }
    }
}

