/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Optional;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Connected;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.ddl.DbmsMetadataDDLGenerator;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpBundleBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPages;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPagesBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.CommandPageAssemblers;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Factory;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParameterBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Parser;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;

public class DDLCommand
extends CommandListener
implements IHelp,
Connected {
    protected static final String CMD = "ddl";
    protected static final SQLCommand.StmtSubType s_cmdStmtSubType = SQLCommand.StmtSubType.G_S_DDL;
    private final Type _typeCommand = Factory.type(TypeId.DDL).name("DDL").add(((ParameterBuilder)Factory.parameter(TypeId.OBJECT).name("object").dataType(String.class)).build()).add(((ParameterBuilder)Factory.parameter(TypeId.OBJECT_TYPE).name("objectType").dataType(String.class)).build()).add(((ParameterBuilder)Factory.parameter(TypeId.SAVE).name("save").dataType(String.class)).build()).add(((ParameterBuilder)Factory.parameter(TypeId.FILENAME).name("filename").dataType(String.class)).build()).build();
    private ScriptRunnerContext _ctx = null;

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        DbmsMetadataDDLGenerator ddlGen = new DbmsMetadataDDLGenerator(conn, ctx);
        try {
            if (conn == null || !conn.isValid(10)) {
                ctx.write(Messages.getString("DDLCommand.71"));
                return true;
            }
            this.setContext(ctx);
        }
        catch (SQLException e) {
            ctx.write(Messages.getString("DDLCommand.72"));
            return true;
        }
        Parser parser = new Parser(this._typeCommand, ctx.getEnvironment());
        Optional<ParsedCommand> parsedCommand = parser.parse(cmd.getSql(), error -> ctx.write(error + "\n"));
        boolean correctlyParsed = parsedCommand.isPresent();
        if (correctlyParsed) {
            ParsedCommand command = parsedCommand.get();
            int keywords = command.getCommand().split(" ").length;
            String object = (String)command.getParameterValue(TypeId.OBJECT);
            String objectType = (String)command.getParameterValue(TypeId.OBJECT_TYPE);
            if (objectType != null && objectType.equalsIgnoreCase("package_body")) {
                objectType = "package body";
            }
            String save = (String)command.getParameterValue(TypeId.SAVE);
            String filename = (String)command.getParameterValue(TypeId.FILENAME);
            if (object != null) {
                if (objectType != null && objectType.equalsIgnoreCase("SAVE")) {
                    filename = save;
                    save = objectType;
                    objectType = null;
                }
                if (save != null && filename == null) {
                    ctx.write("No file name specified for SAVE option.\n");
                    return true;
                }
                ddlGen.processDDL(object, objectType, filename, false);
                ctx.write("Operation completed successfully\n");
                return true;
            }
        }
        this.writeToCtx(MessageFormat.format(Messages.getString("DDL_PARSE_ERROR"), new Object[0]));
        return true;
    }

    protected void setContext(ScriptRunnerContext ctx) {
        this._ctx = ctx;
    }

    protected void writeToCtx(String message) {
        try {
            this.writeToCtx(message, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void writeToCtx(String message, BufferedWriter bw) throws IOException {
        if (message != null && bw == null) {
            this._ctx.write(message);
            this._ctx.write("\n");
        }
        if (message != null && bw != null) {
            bw.write(message);
            bw.newLine();
        }
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public String getCommand() {
        return "DDL";
    }

    @Override
    public Optional<String> getHelp(ScriptRunnerContext ctx, String pagePath) {
        return this.createHelpPages(ctx, this._typeCommand).get(pagePath);
    }

    private HelpPages createHelpPages(ScriptRunnerContext ctx, Type type) {
        int lineSize = Integer.parseInt(ctx.getProperty("script.runner.setlinesize").toString());
        return new HelpPagesBuilder(ctx.getEnvironment()).lineSize(lineSize).addHelpContainer(new HelpBundleBuilder("oracle.dbtools.raptor.newscriptrunner.commands.help.DDLHelp").build()).addPages(new CommandPageAssemblers(type, new Type[0])).build();
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public boolean needsConnection() {
        return true;
    }

    public static enum TypeId implements Id
    {
        DDL,
        OBJECT,
        OBJECT_TYPE,
        SAVE,
        FILENAME;

    }
}

