/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.datatypes.BindContext;
import oracle.dbtools.raptor.datatypes.BindingMode;
import oracle.dbtools.raptor.datatypes.BindingStrategy;
import oracle.dbtools.raptor.datatypes.DataBinding;
import oracle.dbtools.raptor.datatypes.DataParameter;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionReference;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionWrapper;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeFactoryExtension;
import oracle.dbtools.raptor.datatypes.DataTypeFactoryExtensionManager;
import oracle.dbtools.raptor.datatypes.DataTypeSQLException;
import oracle.dbtools.raptor.datatypes.DataVariable;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.extensions.OraclePLSQLDataTypeFactoryExtension;
import oracle.dbtools.raptor.datatypes.extensions.OracleSQLDataTypeFactoryExtension;
import oracle.dbtools.raptor.datatypes.extensions.UnsupportedDataTypeFactoryExtension;
import oracle.dbtools.raptor.datatypes.impl.BindContextImpl;
import oracle.dbtools.raptor.datatypes.impl.DataParameterImpl;
import oracle.dbtools.raptor.datatypes.impl.DataVariableImpl;
import oracle.dbtools.raptor.datatypes.oracle.plsql.OraclePLSQLDataTypeFactory;
import oracle.dbtools.raptor.datatypes.oracle.sql.OracleSQLDataTypeFactory;
import oracle.dbtools.raptor.datatypes.util.ConcurrentWeakIdentityHashMap;
import oracle.dbtools.util.Closeables;

public class DataTypeFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static List<DataTypeFactoryExtension.Builder> defaultExtensionList = DataTypeFactory.defaultExtensionList();
    private final DataTypeFactoryExtensionManager extensionManager;
    private final FactoryAccess factoryAccess;
    private final Map<Connection, DataTypeConnectionProvider.ConnectionProviderAccess> connectionProviderCache;
    private final Map<DataTypeConnectionProvider, DataTypeContext.ContextAccess> contextCache;
    private final PropertyChangeListener connectionChangeListener;
    private final PropertyChangeListener connectionProviderChangeListener;
    private final boolean local;
    private int creates = 0;
    private int frees = 0;
    private int reuses = 0;

    private DataTypeFactory readResolve() {
        return DataTypeFactoryInit.instance;
    }

    private DataTypeFactory(boolean local, List<DataTypeFactoryExtension.Builder> extensionList) {
        this.local = local;
        this.factoryAccess = new FactoryAccess();
        this.connectionProviderCache = new ConcurrentWeakIdentityHashMap<Connection, DataTypeConnectionProvider.ConnectionProviderAccess>();
        this.contextCache = new ConcurrentWeakIdentityHashMap<DataTypeConnectionProvider, DataTypeContext.ContextAccess>();
        this.extensionManager = new DataTypeFactoryExtensionManager(this.factoryAccess, extensionList);
        this.connectionChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("connection".equals(evt.getPropertyName())) {
                    DataTypeConnectionProvider.ConnectionProviderAccess oldConnectionProviderAccess;
                    DataTypeConnectionProvider.ConnectionProviderAccess srcConnectionProviderAccess = (DataTypeConnectionProvider.ConnectionProviderAccess)evt.getSource();
                    Connection oldConnection = (Connection)evt.getOldValue();
                    Connection newConnection = (Connection)evt.getNewValue();
                    if (oldConnection != null && (oldConnectionProviderAccess = DataTypeFactory.this.connectionProviderCache.get(oldConnection)) != null) {
                        if (oldConnectionProviderAccess == srcConnectionProviderAccess) {
                            DataTypeFactory.this.connectionProviderCache.remove(oldConnection);
                        } else {
                            Closeables.close(oldConnectionProviderAccess.getDataTypeConnectionProvider());
                        }
                    }
                    if (newConnection != null && srcConnectionProviderAccess != null) {
                        DataTypeFactory.this.connectionProviderCache.put(newConnection, srcConnectionProviderAccess);
                    }
                }
            }
        };
        this.connectionProviderChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("connection_provider".equals(evt.getPropertyName())) {
                    DataTypeContext.ContextAccess oldContextAccess;
                    DataTypeContext.ContextAccess srcContextAccess = (DataTypeContext.ContextAccess)evt.getSource();
                    DataTypeConnectionProvider.ConnectionProviderAccess oldProviderAccess = (DataTypeConnectionProvider.ConnectionProviderAccess)evt.getOldValue();
                    DataTypeConnectionProvider.ConnectionProviderAccess newProviderAccess = (DataTypeConnectionProvider.ConnectionProviderAccess)evt.getNewValue();
                    if (oldProviderAccess != null && (oldContextAccess = DataTypeFactory.this.contextCache.get(oldProviderAccess.getDataTypeConnectionProvider())) != null) {
                        if (oldContextAccess == srcContextAccess) {
                            DataTypeFactory.this.contextCache.remove(oldProviderAccess.getDataTypeConnectionProvider());
                        } else {
                            Closeables.close(oldContextAccess.getDataTypeContext());
                        }
                    }
                    if (newProviderAccess != null && srcContextAccess != null) {
                        DataTypeFactory.this.contextCache.put(newProviderAccess.getDataTypeConnectionProvider(), srcContextAccess);
                    }
                }
            }
        };
    }

    public static DataTypeFactory getInstance() {
        return DataTypeFactoryInit.instance;
    }

    public static DataTypeFactory getLocalInstance(List<DataTypeFactoryExtension.Builder> extensionList) {
        return new DataTypeFactory(true, extensionList);
    }

    public static DataTypeFactory getLocalInstance() {
        return new DataTypeFactory(true, defaultExtensionList != null ? defaultExtensionList : DataTypeFactory.defaultExtensionList());
    }

    public boolean isLocal() {
        return this.local;
    }

    public static void setDefaultExtensionList(List<DataTypeFactoryExtension.Builder> defaultExtensionList) {
        DataTypeFactory.defaultExtensionList = defaultExtensionList;
    }

    private static LinkedList<DataTypeFactoryExtension.Builder> defaultExtensionList() {
        LinkedList<DataTypeFactoryExtension.Builder> extensionList = new LinkedList<DataTypeFactoryExtension.Builder>();
        UnsupportedDataTypeFactoryExtension.Builder unsupportedExtension = UnsupportedDataTypeFactoryExtension.builder(UnsupportedDataTypeFactoryExtension.Builder.ID).setDataTypeProvider(UnsupportedDataTypeFactoryExtension.UnsupportedDataProvider.builder(UnsupportedDataTypeFactoryExtension.UnsupportedDataProvider.Builder.ID));
        extensionList.add(unsupportedExtension);
        OracleSQLDataTypeFactoryExtension.Builder sqlExtension = OracleSQLDataTypeFactoryExtension.builder(OracleSQLDataTypeFactoryExtension.Builder.ID).setSuperExtensionURI(UnsupportedDataTypeFactoryExtension.Builder.ID).setDataTypeProvider(OracleSQLDataTypeFactory.builder(OracleSQLDataTypeFactory.Builder.ID).setSuperDataTypeProviderURI(UnsupportedDataTypeFactoryExtension.UnsupportedDataProvider.Builder.ID));
        extensionList.add(sqlExtension);
        OraclePLSQLDataTypeFactoryExtension.Builder plsqlExtension = OraclePLSQLDataTypeFactoryExtension.builder(OraclePLSQLDataTypeFactoryExtension.Builder.ID).setSuperExtensionURI(OracleSQLDataTypeFactoryExtension.Builder.ID).setDataTypeProvider(OraclePLSQLDataTypeFactory.builder(OraclePLSQLDataTypeFactory.Builder.ID).setSuperDataTypeProviderURI(OracleSQLDataTypeFactory.Builder.ID));
        extensionList.add(plsqlExtension);
        return extensionList;
    }

    public DataType getDataType(Connection connection, TypeMetadata typeMetadata) {
        return this.getDataType(this.getDataTypeConnectionProvider(connection), typeMetadata);
    }

    public DataType getDataType(DataTypeConnectionProvider connectionProvider, TypeMetadata typeMetadata) {
        return this.getDataType(connectionProvider.getDataTypeContext(), typeMetadata);
    }

    public DataType getDataType(DataTypeContext context, TypeMetadata typeMetadata) {
        return context.getDataType(typeMetadata);
    }

    public DataType lookupDataType(Connection connection, TypeMetadata typeMetadata) {
        return this.lookupDataType(this.getDataTypeConnectionProvider(connection), typeMetadata);
    }

    public DataType lookupDataType(DataTypeConnectionProvider connectionProvider, TypeMetadata typeMetadata) {
        return this.lookupDataType(connectionProvider.getDataTypeContext(), typeMetadata);
    }

    public DataType lookupDataType(DataTypeContext context, TypeMetadata typeMetadata) {
        return context.lookupDataType(typeMetadata);
    }

    public void mapDataType(TypeMetadata typeMetadata, DataType dataType) {
        if (dataType != null) {
            dataType.getDataTypeConnectionProvider().getDataTypeContext().mapDataType(typeMetadata, dataType);
        }
    }

    public DataType buildDataType(DataTypeContext context, TypeMetadata typeMetadata) {
        return this.extensionManager.getDataType(context, typeMetadata);
    }

    public <P extends DataBinding> BindingStrategy getBind(BindContext context, P param) {
        return param.getDataType().getBind(context, param);
    }

    public boolean isSupportedType(DataTypeConnectionProvider connectionProvider, TypeMetadata typeMetadata) {
        try {
            DataType datatype = this.getDataType(connectionProvider, typeMetadata);
            return datatype != null && datatype.isSupported();
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getLocalizedMessage(), e);
            return false;
        }
    }

    public <P extends DataBinding> boolean isSupportedBinding(BindContext context, P param) {
        try {
            BindingStrategy binding = this.getBind(context, param);
            return binding.isSupported(param.getMode());
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getLocalizedMessage(), e);
            return false;
        }
    }

    public boolean isSupportedType(Connection connection, TypeMetadata typeMetadata) {
        return this.isSupportedType(this.getDataTypeConnectionProvider(connection), typeMetadata);
    }

    public boolean isSupportedType(DataTypeConnectionProvider connectionProvider, Integer oracleType) {
        try {
            TypeMetadata typeMetadata = this.getTypeMetadata(connectionProvider, oracleType);
            return this.isSupportedType(connectionProvider, typeMetadata);
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getLocalizedMessage(), e);
            return false;
        }
    }

    public boolean isSupportedType(Connection connection, Integer oracleType) {
        return this.isSupportedType(this.getDataTypeConnectionProvider(connection), oracleType);
    }

    public Set<String> getSupportedTypes(Class<? extends Connection> connectionClass) {
        return this.extensionManager.getSupportedTypes(connectionClass);
    }

    public Set<String> getSupportedTypes(DataTypeConnectionProvider connectionProvider) {
        return this.getSupportedTypes(connectionProvider.getDataTypeConnnectionClass());
    }

    public Set<String> getSupportedTypes(Connection connection) {
        return this.getSupportedTypes(connection.getClass());
    }

    public Set<Integer> getSupportedSQLTypes(Class<? extends Connection> connectionClass) {
        return this.extensionManager.getSupportedSQLTypes(connectionClass);
    }

    public Set<Integer> getSupportedSQLTypes(DataTypeConnectionProvider connectionProvider) {
        return this.getSupportedSQLTypes(connectionProvider.getDataTypeConnnectionClass());
    }

    public Set<Integer> getSupportedSQLTypes(Connection connection) {
        return this.getSupportedSQLTypes(connection.getClass());
    }

    public Map<String, TypeMetadata> getSupportedTypeMetadata(Class<? extends Connection> connectionClass) {
        return this.extensionManager.getSupportedTypeMetadata(connectionClass);
    }

    public Map<String, TypeMetadata> getSupportedTypeMetadata(DataTypeConnectionProvider connectionProvider) {
        return this.getSupportedTypeMetadata(connectionProvider.getDataTypeConnnectionClass());
    }

    public Map<String, TypeMetadata> getSupportedTypeMetadata(Connection connection) {
        return this.getSupportedTypeMetadata(connection.getClass());
    }

    public TypeMetadata getTypeMetadata(Map<TypeMetadata.Attribute, Object> attributes) {
        return new TypeMetadata(attributes);
    }

    public static TypeMetadata getTypeMetadata(Map<TypeMetadata.Attribute, Object> attributes, boolean syntaxSynonym) {
        return new TypeMetadata(attributes, syntaxSynonym);
    }

    public static TypeMetadata getTypeMetadata(TypeMetadata source, Map<TypeMetadata.Attribute, Object> attributes) {
        return TypeMetadata.overideTypeMetadata(source, attributes);
    }

    public static TypeMetadata getTypeMetadata(TypeMetadata source, TypeMetadata source2) {
        return TypeMetadata.overideTypeMetadata(source, source2);
    }

    public TypeMetadata getTypeMetadata(DataTypeConnectionProvider connectionProvider, Integer oracleType) {
        return this.extensionManager.getTypeMetadata(connectionProvider, oracleType);
    }

    public TypeMetadata getTypeMetadata(Connection connection, Integer oracleType) {
        return this.getTypeMetadata(this.getDataTypeConnectionProvider(connection), oracleType);
    }

    public TypeMetadata getTypeMetadata(DataTypeConnectionProvider connectionProvider, String typeName) {
        return this.extensionManager.getTypeMetadata(connectionProvider, typeName);
    }

    public TypeMetadata getTypeMetadata(Connection connection, String typeName) {
        return this.getTypeMetadata(this.getDataTypeConnectionProvider(connection), typeName);
    }

    public TypeMetadata getTypeMetadata(ResultSetMetaData resultSetMetadata, int column) {
        try {
            int typeCode = resultSetMetadata.getColumnType(column);
            String datatype = resultSetMetadata.getColumnTypeName(column);
            int precision = resultSetMetadata.getPrecision(column);
            int scale = resultSetMetadata.getScale(column);
            return this.getTypeMetadata(typeCode, datatype, precision != 0 ? Integer.valueOf(precision) : null, precision != 0 ? Integer.valueOf(scale) : null);
        }
        catch (SQLException e) {
            throw new DataTypeSQLException(e);
        }
    }

    public TypeMetadata getTypeMetadata(Integer oracleType, String typeName, Integer precision, Integer scale) {
        return new TypeMetadata(oracleType, typeName, precision, scale);
    }

    public TypeMetadata getTypeMetadata(Integer oracleType, String typeName) {
        return new TypeMetadata(oracleType, typeName, null, null);
    }

    public DataVariable getDataVariable(String name, DataType dataType, BindingMode mode) {
        return new DataVariableImpl(name, dataType, mode);
    }

    public DataParameter getDataParameter(String name, DataType dataType, BindingMode mode) {
        return new DataParameterImpl(name, dataType, mode);
    }

    public <S extends Statement> BindContext<S> getBindContext(Class<? extends S> stmtclass, DataTypeConnectionProvider connectionProvider) {
        return new BindContextImpl<S>(stmtclass, connectionProvider);
    }

    public <S extends Statement> BindContext<S> getBindContext(Class<? extends S> stmtclass, Connection connection) {
        return this.getBindContext(stmtclass, this.getDataTypeConnectionProvider(connection));
    }

    private final DataTypeContext.ContextAccess getContextAccess(DataTypeConnectionProvider.ConnectionProviderAccess connectionProviderAccess) {
        return this.resolveDataTypeContext(connectionProviderAccess);
    }

    private final DataTypeContext.ContextAccess peekContextAccess(DataTypeConnectionProvider.ConnectionProviderAccess connectionProviderAccess) {
        return this.contextCache.get(connectionProviderAccess.getDataTypeConnectionProvider());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DataTypeContext.ContextAccess resolveDataTypeContext(DataTypeConnectionProvider.ConnectionProviderAccess connectionProviderAccess) {
        DataTypeContext.ContextAccess contextAccess = this.peekContextAccess(connectionProviderAccess);
        if (contextAccess == null) {
            Map<DataTypeConnectionProvider, DataTypeContext.ContextAccess> map = this.contextCache;
            synchronized (map) {
                contextAccess = this.peekContextAccess(connectionProviderAccess);
                if (contextAccess == null) {
                    contextAccess = this.buildDataTypeContext(connectionProviderAccess);
                    ++this.creates;
                } else {
                    ++this.reuses;
                }
            }
        } else {
            ++this.reuses;
        }
        return contextAccess;
    }

    protected DataTypeContext.ContextAccess buildDataTypeContext(DataTypeConnectionProvider.ConnectionProviderAccess connectionProviderAccess) {
        DataTypeContext.ContextAccess contextAccess = this.extensionManager.buildDataTypeContext(connectionProviderAccess);
        this.addConnectionProviderChangeListener(contextAccess);
        if (connectionProviderAccess != null && contextAccess != null) {
            this.contextCache.put(connectionProviderAccess.getDataTypeConnectionProvider(), contextAccess);
        }
        return contextAccess;
    }

    public final <C extends Connection> DataTypeConnectionProvider getDataTypeConnectionProvider(C connection) {
        return this.resolveDataTypeConnectionProvider(connection).getDataTypeConnectionProvider();
    }

    public final <C extends Connection> DataTypeConnectionProvider getDataTypeConnectionProvider(DataTypeConnectionReference<C> connectionReference) {
        return this.getDataTypeConnectionProvider(connectionReference, null);
    }

    public final <C extends Connection> DataTypeConnectionProvider getDataTypeConnectionProvider(DataTypeConnectionReference<C> connectionReference, DataTypeConnectionWrapper<C> nlsWrapper) {
        return this.resolveDataTypeConnectionProvider(connectionReference, nlsWrapper).getDataTypeConnectionProvider();
    }

    public final <C extends Connection> void release(C Connection2) {
        DataTypeConnectionProvider.ConnectionProviderAccess provider = this.connectionProviderCache.get(Connection2);
        if (provider != null) {
            Closeables.close(provider.getDataTypeConnectionProvider());
        }
    }

    public final <C extends Connection> void release(DataTypeConnectionProvider<C> connectionProvider) {
        Closeables.close(connectionProvider);
    }

    public final <C extends Connection> DataTypeConnectionProvider<C> getDataTypeConnectionProvider(Class<C> connectionClass) {
        return this.buildDataTypeConnectionProvider(connectionClass).getDataTypeConnectionProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <C extends Connection> DataTypeConnectionProvider.ConnectionProviderAccess<C> resolveDataTypeConnectionProvider(C connection) {
        DataTypeConnectionProvider.ConnectionProviderAccess<C> connectionProviderAccess = this.connectionProviderCache.get(connection);
        if (connectionProviderAccess == null) {
            Map<Connection, DataTypeConnectionProvider.ConnectionProviderAccess> map = this.connectionProviderCache;
            synchronized (map) {
                connectionProviderAccess = this.connectionProviderCache.get(connection);
                if (connectionProviderAccess == null) {
                    connectionProviderAccess = this.buildDataTypeConnectionProvider(connection);
                    ++this.creates;
                } else {
                    ++this.reuses;
                }
            }
            ++this.creates;
        } else {
            ++this.reuses;
        }
        return connectionProviderAccess;
    }

    private final <C extends Connection> DataTypeConnectionProvider.ConnectionProviderAccess<C> resolveDataTypeConnectionProvider(DataTypeConnectionReference<C> connectionReference, DataTypeConnectionWrapper<C> nlsWrapper) {
        return this.buildDataTypeConnectionProvider(connectionReference, nlsWrapper);
    }

    protected <C extends Connection> DataTypeConnectionProvider.ConnectionProviderAccess<C> buildDataTypeConnectionProvider(C connection) {
        return this.buildDataTypeConnectionProvider(connection == null ? Connection.class : connection.getClass(), connection);
    }

    protected <C extends Connection> DataTypeConnectionProvider.ConnectionProviderAccess<C> buildDataTypeConnectionProvider(Class<C> connectionClass) {
        return this.buildDataTypeConnectionProvider(connectionClass, null);
    }

    protected <C extends Connection> void addConnectionChangeListener(DataTypeConnectionProvider.ConnectionProviderAccess<C> connectionProviderAccess) {
        connectionProviderAccess.addPropertyChangeListener(this.connectionChangeListener);
    }

    protected <C extends Connection> void addConnectionProviderChangeListener(DataTypeContext.ContextAccess contextAccess) {
        contextAccess.addPropertyChangeListener(this.connectionProviderChangeListener);
    }

    protected <C extends Connection> DataTypeConnectionProvider.ConnectionProviderAccess<C> buildDataTypeConnectionProvider(Class<C> connectionClass, C connection) {
        DataTypeConnectionProvider.ConnectionProviderAccess<C> connectionProviderAccess = this.extensionManager.buildDataTypeConnectionProvider(connectionClass, connection);
        this.addConnectionChangeListener(connectionProviderAccess);
        if (connection != null && connectionProviderAccess != null) {
            this.connectionProviderCache.put(connection, connectionProviderAccess);
        }
        return connectionProviderAccess;
    }

    protected <C extends Connection> DataTypeConnectionProvider.ConnectionProviderAccess<C> buildDataTypeConnectionProvider(DataTypeConnectionReference<C> connectionReference) {
        return this.buildDataTypeConnectionProvider(connectionReference, null);
    }

    protected <C extends Connection> DataTypeConnectionProvider.ConnectionProviderAccess<C> buildDataTypeConnectionProvider(DataTypeConnectionReference<C> connectionReference, DataTypeConnectionWrapper<C> nlsWrapper) {
        DataTypeConnectionProvider<C> provider;
        C connection;
        DataTypeConnectionProvider.ConnectionProviderAccess<C> connectionProviderAccess = this.extensionManager.buildDataTypeConnectionProvider(connectionReference, nlsWrapper);
        this.addConnectionChangeListener(connectionProviderAccess);
        if (connectionProviderAccess != null && (connection = (provider = connectionProviderAccess.getDataTypeConnectionProvider()).peekDataTypeConnection()) != null) {
            this.connectionProviderCache.put((Connection)connection, connectionProviderAccess);
        }
        return connectionProviderAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCleanupCache() {
        Map<DataTypeConnectionProvider, DataTypeContext.ContextAccess> map = this.contextCache;
        synchronized (map) {
            Iterator<Map.Entry<DataTypeConnectionProvider, DataTypeContext.ContextAccess>> contextCacheIter = this.contextCache.entrySet().iterator();
            while (contextCacheIter.hasNext()) {
                contextCacheIter.next().getValue().cleanupDataTypeCache();
            }
        }
    }

    public class FactoryAccess {
        private FactoryAccess() {
        }

        public DataTypeFactory getDataTypeFactory() {
            return DataTypeFactory.this;
        }

        public DataTypeContext.ContextAccess getContextAccess(DataTypeConnectionProvider.ConnectionProviderAccess connectionProviderAccess) {
            return DataTypeFactory.this.getContextAccess(connectionProviderAccess);
        }

        public DataTypeContext.ContextAccess peekContextAccess(DataTypeConnectionProvider.ConnectionProviderAccess connectionProviderAccess) {
            return DataTypeFactory.this.peekContextAccess(connectionProviderAccess);
        }
    }

    private static class DataTypeFactoryInit {
        public static final DataTypeFactory instance = new DataTypeFactory(false, defaultExtensionList != null ? defaultExtensionList : DataTypeFactory.defaultExtensionList());

        private DataTypeFactoryInit() {
        }
    }
}

