/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp.features;

import java.util.LinkedList;
import oracle.dbtools.lsp.features.SemanticToken;
import oracle.dbtools.lsp.features.SimpleToken;

class MultilineToken
implements SemanticToken {
    LinkedList<SimpleToken> tokens = new LinkedList();
    SemanticToken prior = null;

    public MultilineToken(SemanticToken prior, int startLine, int startChar, int endLine, int endChar, int tokenType, int tokenModifiers) {
        this.prior = prior;
        SemanticToken priorToken = prior;
        for (int line = startLine; line <= endLine; ++line) {
            int len = 999;
            if (startLine == endLine) {
                len = endChar - startChar;
            } else if (line == endLine) {
                len = endChar;
            }
            SimpleToken current = new SimpleToken(priorToken, line, line == startLine ? startChar : 0, len, tokenType, tokenModifiers);
            this.tokens.add(current);
            priorToken = current;
        }
    }

    @Override
    public String toString() {
        StringBuilder ret = new StringBuilder();
        for (SimpleToken t : this.tokens) {
            ret.append(t.toString());
        }
        return ret.toString();
    }

    @Override
    public int endLine() {
        return this.tokens.getLast().endLine();
    }

    @Override
    public int endChar() {
        return this.tokens.getLast().endChar();
    }
}

