/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.jdbc.DataSourceBuilder;
import oracle.dbtools.jdbc.OracleDataSources;
import oracle.dbtools.jdbc.wallet.DatabaseToolsProperties;
import oracle.dbtools.jdbc.wallet.OracleWalletArchive;
import oracle.dbtools.raptor.newscriptrunner.Messages;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.jdbc.datasource.impl.OracleDataSource;

public class WalletUtils {
    public static URI httpsProxy(ScriptRunnerContext ctx, String proxyValue) {
        URI httpsProxy = null;
        try {
            if (!((String)proxyValue).startsWith("http://") && !((String)proxyValue).startsWith("https://")) {
                proxyValue = "https://" + (String)proxyValue;
            }
            httpsProxy = new URI((String)proxyValue);
        }
        catch (URISyntaxException e) {
            ctx.write(MessageFormat.format(Messages.getString("CLOUD_INVALID_PROXY"), proxyValue) + "\n");
        }
        return httpsProxy;
    }

    public static OracleWalletArchive setWallet(ScriptRunnerContext ctx, String walletFileName, URI httpsProxy) {
        URLConnection fUrl = FileUtils.getFile(ctx, walletFileName);
        OracleWalletArchive walletArchive = null;
        try (InputStream contents = fUrl.getInputStream();){
            walletArchive = OracleWalletArchive.read((InputStream)contents);
            if (httpsProxy != null) {
                DatabaseToolsProperties oldProperties = walletArchive.getDatabaseToolsProperties();
                DatabaseToolsProperties.Builder propBuilder = oldProperties.modify();
                propBuilder.httpsProxy(httpsProxy);
                DatabaseToolsProperties newProperties = propBuilder.build();
                OracleWalletArchive.Builder archiveBuilder = walletArchive.modify();
                archiveBuilder.databaseToolsProperties(newProperties);
                walletArchive = archiveBuilder.build();
            }
            if (walletArchive.isConfigurable()) {
                ctx.putProperty("script.runner.walletarchive.zip", walletArchive);
                ctx.putProperty("script.runner.walletarchive.location", walletFileName);
            } else {
                ctx.write(MessageFormat.format(Messages.getString("CLOUD_ARCHIVE_INVALID"), walletFileName) + "\n");
            }
        }
        catch (Exception e) {
            ctx.write(MessageFormat.format(Messages.getString("CLOUD_INVALID"), walletFileName) + "\n");
        }
        return walletArchive;
    }

    public static oracle.jdbc.datasource.OracleDataSource configureDataSource(String url, Properties props, ScriptRunnerContext ctx) throws SQLException {
        OracleDataSource datasource = new OracleDataSource();
        Properties filteredProps = new Properties();
        filteredProps.putAll((Map<?, ?>)props);
        String user = (String)filteredProps.get("user");
        String password = (String)filteredProps.get("password");
        OracleWalletArchive walletArchive = (OracleWalletArchive)ctx.getProperty("script.runner.walletarchive.zip");
        String serviceAlias = WalletUtils.getCloudServiceAlias(url, ctx);
        if (walletArchive != null) {
            try {
                OracleDataSources.Builder builder = OracleDataSources.instance().builder();
                if (serviceAlias != null) {
                    builder.serviceAlias(serviceAlias);
                } else {
                    builder.serviceAlias("@");
                }
                walletArchive.configure((DataSourceBuilder)builder);
                builder.configure((DataSource)datasource);
                if (serviceAlias != null && serviceAlias.length() > 0) {
                    filteredProps.remove("oracle.net.tns_admin");
                    filteredProps.remove("oracle.net.wallet_location");
                    filteredProps.remove("oracle.net.ssl_server_dn_match");
                    filteredProps.putAll((Map<?, ?>)datasource.getConnectionProperties());
                    if (user != null && user.length() > 0) {
                        builder.user(user);
                    }
                    if (password != null && password.length() > 0) {
                        builder.password(password);
                    }
                }
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
        if (serviceAlias == null || serviceAlias.length() == 0) {
            datasource.setURL(url);
        }
        datasource.setConnectionProperties(filteredProps);
        return datasource;
    }

    public static String getCloudServiceAlias(String connectDB, ScriptRunnerContext ctx) {
        OracleWalletArchive walletArchive = (OracleWalletArchive)ctx.getProperty("script.runner.walletarchive.zip");
        if (walletArchive != null) {
            if (connectDB == null || connectDB.length() == 0) {
                return walletArchive.getDatabaseToolsProperties().serviceAlias();
            }
            String serviceAlias = connectDB;
            if (serviceAlias.startsWith("jdbc:oracle:thin:@")) {
                serviceAlias = serviceAlias.substring("jdbc:oracle:thin:@".length());
            }
            if (serviceAlias != null && serviceAlias.length() > 0 && !WalletUtils.hasUrlStub(serviceAlias) && walletArchive.getTNSNames().getTNSEntry(serviceAlias) != null) {
                return serviceAlias;
            }
        }
        return null;
    }

    private static boolean hasUrlStub(String url) {
        if (url != null) {
            for (String stub : new String[]{"jdbc:oracle:", "jdbc:oracle:thin", "jdbc:oracle:oci", "jdbc:oracle:kprb", "jdbc:default:connection", "jdbc:timesten:direct", "jdbc:timesten:client", "jdbc:oracle:orest", "http:", "https:"}) {
                if (!url.startsWith(stub)) continue;
                return true;
            }
        }
        return false;
    }
}

