/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.vcs;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.ide.util.MetaClass;
import oracle.ide.Context;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.ide.vcs.VCSManager;

public final class VCSUtil {
    private VCSUtil() {
    }

    public static final boolean checkOutOnUndoStack(Node node) {
        MetaClass mClass = VCSManager.getVCSManager().getMetaCheckOutCommand(node);
        if (mClass == null) {
            return false;
        }
        Command command = CommandProcessor.createCommandFromMeta(mClass, new Context(node));
        try {
            return CommandProcessor.getInstance().invoke(command) == 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static final URL[] coalesceURLs(URL[] urls) {
        for (URL url : urls) {
            String host = url.getHost();
            if (host == null || host.equals("")) continue;
            Assert.printStackTrace((Throwable)new IllegalStateException("Network access from URL.equals()"));
        }
        ArrayList<URL> urls0 = new ArrayList<URL>(Arrays.asList(urls));
        ArrayList<URL> urls1 = new ArrayList<URL>();
        while (!urls0.isEmpty()) {
            URL shallowUrl = (URL)urls0.iterator().next();
            String shallowUrlExternal = shallowUrl.toExternalForm();
            for (URL currentUrl : urls0) {
                String currentUrlExternal = currentUrl.toExternalForm();
                if (!URLFileSystem.isDirectoryPath((URL)currentUrl) || !shallowUrlExternal.startsWith(currentUrlExternal)) continue;
                shallowUrl = currentUrl;
                shallowUrlExternal = currentUrlExternal;
            }
            if (URLFileSystem.isDirectoryPath((URL)shallowUrl)) {
                Iterator itr = urls0.iterator();
                while (itr.hasNext()) {
                    if (!((URL)itr.next()).toExternalForm().startsWith(shallowUrlExternal)) continue;
                    itr.remove();
                }
            } else {
                urls0.remove(shallowUrl);
            }
            urls1.add(shallowUrl);
        }
        return urls1.toArray(new URL[0]);
    }
}

