/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.layout;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.util.MetaClass;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.layout.MenuSwitchLayoutListener;
import oracle.javatools.data.HashStructure;

public final class MenuSwitchTaskLayoutHook
extends HashStructureHook {
    private static final String LAYOUT_ARG = "layout";
    private static final String NAME_ARG = "name";
    private static final String CLASS_ARG = "listenerClass";
    private static final String DISPLAY_NAME_ARG = "displayName";
    private static final String ALWAYS_ENABLED_ARG = "alwaysEnabled";
    private Collection<ProxyLayout> layouts = new ArrayList<ProxyLayout>();
    private static MenuSwitchTaskLayoutHook taskLayout;
    private Map<String, MenuSwitchLayoutListener> listeners = new HashMap<String, MenuSwitchLayoutListener>();

    public static MenuSwitchTaskLayoutHook getDefault() {
        return taskLayout;
    }

    public MenuSwitchTaskLayoutHook() {
        taskLayout = this;
        this.addHashStructureHookListener(new HashStructureHookListener(){

            @Override
            public void elementVisited(HashStructureHookEvent e) {
                MenuSwitchTaskLayoutHook.this.addArgument(e.getNewElementHashStructure());
            }

            @Override
            public void listenerAttached(HashStructureHookEvent e) {
                MenuSwitchTaskLayoutHook.this.addArgument(e.getNewElementHashStructure());
            }
        });
    }

    private void addArgument(HashStructure hashStructure) {
        if (hashStructure == null) {
            return;
        }
        List list = hashStructure.getAsList(LAYOUT_ARG);
        if (list == null) {
            return;
        }
        for (Object obj : list) {
            HashStructure hs = (HashStructure)obj;
            String name = hs.getString(NAME_ARG);
            MetaClass listenerClass = LazyClassAdapter.getInstance(hs).getMetaClass(CLASS_ARG);
            boolean alwaysEnabled = hs.getBoolean(ALWAYS_ENABLED_ARG);
            String displayName = hs.getString(DISPLAY_NAME_ARG);
            String msg = "Menu Switch Task Layout - argument required - ";
            if (name == null) {
                Logger.getLogger("global").log(Level.SEVERE, msg + NAME_ARG);
            }
            if (displayName == null) {
                Logger.getLogger("global").log(Level.SEVERE, msg + DISPLAY_NAME_ARG);
            }
            if (alwaysEnabled && listenerClass == null) {
                Logger.getLogger("global").log(Level.SEVERE, msg + "listenerClass alwaysEnabled");
            }
            ProxyLayout proxyLayout = new ProxyLayout(name, listenerClass, displayName, alwaysEnabled);
            this.layouts.add(proxyLayout);
        }
    }

    public Collection<String> getRegisteredTaskLayouts() {
        ArrayList<String> names = new ArrayList<String>();
        for (ProxyLayout pl : this.layouts) {
            names.add(pl.getName());
        }
        return names;
    }

    public synchronized MenuSwitchLayoutListener getMenuSwitchLayoutListener(String layoutName) {
        if (this.listeners.get(layoutName) != null) {
            return this.listeners.get(layoutName);
        }
        ProxyLayout proxyLayout = null;
        for (ProxyLayout pl : this.layouts) {
            if (!pl.getName().equals(layoutName)) continue;
            proxyLayout = pl;
            break;
        }
        if (proxyLayout == null) {
            return null;
        }
        MenuSwitchLayoutListener listener = null;
        try {
            MetaClass<MenuSwitchLayoutListener> metaClass = proxyLayout.getMetaClass();
            if (metaClass == null) {
                return null;
            }
            listener = (MenuSwitchLayoutListener)metaClass.newInstance();
            this.listeners.put(layoutName, listener);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return listener;
    }

    private ProxyLayout getProxyLayout(String layoutName) {
        for (ProxyLayout pl : this.layouts) {
            if (!pl.getName().equals(layoutName)) continue;
            return pl;
        }
        return null;
    }

    public String getDisplayName(String layoutName) {
        ProxyLayout proxyLayout = this.getProxyLayout(layoutName);
        return proxyLayout == null ? null : proxyLayout.getDisplayName();
    }

    public boolean isEnabled(String layoutName) {
        ProxyLayout proxyLayout = this.getProxyLayout(layoutName);
        if (proxyLayout == null) {
            return false;
        }
        return proxyLayout.isAlwaysEnabled();
    }

    private class ProxyLayout {
        private String name;
        private String displayName;
        private MetaClass<MenuSwitchLayoutListener> metaClass;
        private boolean alwaysEnabled;

        ProxyLayout(String name, MetaClass<MenuSwitchLayoutListener> metaClass, String displayName, boolean alwaysEnabled) {
            this.name = name;
            this.metaClass = metaClass;
            this.displayName = displayName;
            this.alwaysEnabled = alwaysEnabled;
        }

        String getName() {
            return this.name;
        }

        MetaClass<MenuSwitchLayoutListener> getMetaClass() {
            return this.metaClass;
        }

        String getDisplayName() {
            return this.displayName;
        }

        boolean isAlwaysEnabled() {
            return this.alwaysEnabled;
        }
    }
}

