/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;
import oracle.ide.controls.PentaLayout;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ideimpl.ActiveViewHandlerImpl;
import oracle.ideimpl.IdeImpl;
import oracle.ideimpl.controls.dockLayout.DockInsertionPoint;
import oracle.ideimpl.controls.dockLayout.XMLDockLayoutPersistence;
import oracle.ideimpl.docking.AbstractDockPanelHost;
import oracle.ideimpl.docking.DividerControlledPanel;
import oracle.ideimpl.docking.DockPanel;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.docking.TitledPanel;
import oracle.ideimpl.docking.VisibleComponentAgent;
import oracle.ideimpl.docking.VisibleComponentEvent;
import oracle.ideimpl.docking.VisibleComponentListener;
import oracle.ideimpl.docking.shutter.ShutterManager;

final class SidePort
extends AbstractDockPanelHost {
    private static final int MIN_SIDE_WIDTH = 240;
    private static final int MIN_WEST_SIDE_WIDTH = 280;
    private static final int MIN_SIDE_HEIGHT = 150;
    private static final int MIN_SOUTH_SIDE_HEIGHT = 250;
    private static final String LAYOUT_KEY_DOCKSIZE = "dockSize";
    private static final String LAYOUT_KEY_FLOAT_SIZE = "floatSize";
    private static final String[] PANEL_NAMES = new String[]{"WEST", "EAST", "NORTH", "SOUTH"};
    private int _side;
    private DividerControlledPanel _dividerControlledPanel;
    private Container _container;

    public SidePort(Container container, int side) {
        this._container = container;
        this._side = side;
        this.addDividerPanel();
    }

    private void addDividerPanel() {
        DividerControlledPanel dividerControlledPanel;
        Integer[] ideConstantsToPentaLayout = new Integer[]{PentaLayout.WEST, PentaLayout.EAST, PentaLayout.NORTH, PentaLayout.SOUTH};
        Integer orient = ideConstantsToPentaLayout[this._side];
        String borderLayoutOrient = PentaLayout.getBorderLayoutEquivalent(orient);
        DockPanel dockPanel = new DockPanel();
        this._dividerControlledPanel = dividerControlledPanel = new DividerControlledPanel(dockPanel, borderLayoutOrient);
        Dimension dim = this.getDefaultSideSize();
        dividerControlledPanel.setRestoredSize(dim);
        this._container.add((Component)dividerControlledPanel, orient);
        VisibleComponentAgent vca = new VisibleComponentAgent();
        vca.attachTo(dockPanel);
        vca.addVisibleComponentListener(new VisibleComponentListener(){

            private DividerControlledPanel getDCP(VisibleComponentEvent e) {
                return (DividerControlledPanel)e.getContainer().getParent();
            }

            @Override
            public void visibleCountChanges(VisibleComponentEvent e) {
                DividerControlledPanel dcp = this.getDCP(e);
                if (e.getVisibleCount() == 0) {
                    dcp.setResizable(false);
                } else {
                    dcp.setResizable(true);
                }
            }
        });
    }

    private Dimension getDefaultSideSize() {
        int nWidth;
        Rectangle r = IdeImpl.getStartupCoordinates();
        return new Dimension(nWidth, switch (this._side) {
            case 0 -> {
                nWidth = Math.max(r.width / 5, 280);
                yield Math.max(r.height / 6, 150);
            }
            case 3 -> {
                nWidth = Math.max(r.width / 5, 240);
                yield Math.max(r.height / 4, 250);
            }
            default -> {
                nWidth = Math.max(r.width / 5, 240);
                yield Math.max(r.height / 6, 150);
            }
        });
    }

    private static int getDropZoneSize(int nSize, boolean bFeedback) {
        if (bFeedback) {
            return nSize / 4;
        }
        return 25;
    }

    private Rectangle getDropZone(boolean bFeedback) {
        Point pt = this._container.getLocationOnScreen();
        Dimension d = this._container.getSize();
        Rectangle r = new Rectangle(pt, d);
        switch (this._side) {
            case 0: {
                r.width = SidePort.getDropZoneSize(r.width, bFeedback);
                break;
            }
            case 1: {
                r.x = r.x + r.width - SidePort.getDropZoneSize(r.width, bFeedback);
                r.width = SidePort.getDropZoneSize(r.width, bFeedback);
                break;
            }
            case 2: {
                r.height = SidePort.getDropZoneSize(r.width, bFeedback);
                break;
            }
            default: {
                r.y = r.y + r.height - SidePort.getDropZoneSize(r.width, bFeedback);
                r.height = SidePort.getDropZoneSize(r.width, bFeedback);
            }
        }
        return r;
    }

    @Override
    public DockInsertionPoint getDockInsertionAt(Point pt) {
        Rectangle r;
        DockInsertionPoint dipRet = null;
        Point ptLocal = new Point();
        DockPanel dp = this.getDockPanel();
        ptLocal.setLocation(pt);
        SwingUtilities.convertPointFromScreen(ptLocal, dp);
        dipRet = dp.getDockInsertionAt(ptLocal);
        if ((dp.getWidth() == 0 || dp.getHeight() == 0) && (r = this.getDropZone(false)).contains(pt)) {
            r = this.getDropZone(true);
            Point ptLoc = dp.getLocationOnScreen();
            r.x -= ptLoc.x;
            r.y -= ptLoc.y;
            Point ptAnchor = new Point(r.x + r.width / 2, r.x + r.height / 2);
            dipRet = new DockInsertionPoint(null, 0, ptAnchor, r);
            dipRet.setContainer(dp);
        }
        return dipRet;
    }

    @Override
    public DockPanel getDockPanel() {
        return this._dividerControlledPanel.getDockPanel();
    }

    public DividerControlledPanel getDividerControlledPanel() {
        return this._dividerControlledPanel;
    }

    String getPanelName() {
        return PANEL_NAMES[this._side];
    }

    void loadLayout(XMLDockLayoutPersistence layoutPersistence, StructuredPropertyAccess dcpElement) {
        DockPanel dockPanel = this._dividerControlledPanel.getDockPanel();
        dockPanel.loadLayout(layoutPersistence, dcpElement);
        Dimension restoredSize = this._dividerControlledPanel.getRestoredSize();
        String dockSize = dcpElement.getProperty(LAYOUT_KEY_DOCKSIZE, "-1");
        int restoreValue = Integer.parseInt(dockSize);
        if (restoreValue != -1) {
            if (this._side <= 1) {
                restoredSize.width = restoreValue;
            } else {
                restoredSize.height = restoreValue;
            }
            this._dividerControlledPanel.setRestoredSize(restoredSize);
        }
        ShutterManager shutterManager = ShutterManager.getInstance();
        int floatingSize = shutterManager.getShutterPanelSize(this._side);
        String floatSizeProperty = dcpElement.getProperty(LAYOUT_KEY_FLOAT_SIZE, Integer.toString(floatingSize));
        shutterManager.setShutterPanelSize(this._side, Integer.parseInt(floatSizeProperty));
    }

    @Override
    public StructuredPropertyAccess saveLayout(XMLDockLayoutPersistence layoutPersistence) {
        int nSize;
        String panelName = this.getPanelName();
        DefaultStructuredPropertyAccess node = new DefaultStructuredPropertyAccess(panelName);
        Dimension d = this._dividerControlledPanel.getRestoredSize();
        int n = nSize = this._side <= 1 ? d.width : d.height;
        if (nSize > 4) {
            node.setProperty(LAYOUT_KEY_DOCKSIZE, Integer.toString(nSize));
        }
        int floatingSize = ShutterManager.getInstance().getShutterPanelSize(this._side);
        node.setProperty(LAYOUT_KEY_FLOAT_SIZE, Integer.toString(floatingSize));
        DockPanel dockPanel = this._dividerControlledPanel.getDockPanel();
        dockPanel.saveLayout(layoutPersistence, node);
        return node;
    }

    public void setActiveViewHandler(ActiveViewHandlerImpl activeViewHandler) {
        DockPanel dockPanel = this.getDockPanel();
        DockStationImpl dockStation = DockStationImpl.getInstance();
        activeViewHandler.addControllerProvider(dockPanel, dockStation);
    }

    public final void resetToDefaultSize() {
        TitledPanel[] titledPanels;
        this._dividerControlledPanel.setRestoredSize(this.getDefaultSideSize());
        for (TitledPanel titledPanel : titledPanels = this.getDockPanel().getAllTitledPanels()) {
            if (titledPanel == null || titledPanel.getPrefDockedSize() == null) continue;
            titledPanel.setSize(titledPanel.getPrefDockedSize());
        }
    }
}

