/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ElementName;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.net.URIFactory;
import javax.ide.net.VirtualFileSystem;
import javax.ide.util.MetaClass;
import javax.swing.ImageIcon;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.model.AbstractFileContentRecognizerTemplate;
import oracle.ide.model.ContentRecognizerHookHelper;
import oracle.ide.model.ContentType;
import oracle.ide.model.DocTypeRecognizerHookHelper;
import oracle.ide.model.DocumentInfoRecognizerHookHelper;
import oracle.ide.model.ExtensionToContentRecognizerHookHelper;
import oracle.ide.model.FileContentPatternRecognizer;
import oracle.ide.model.FileExtensionRecognizerHookHelper;
import oracle.ide.model.LowPriorityContentRecognizerHelper;
import oracle.ide.model.NamespaceRecognizerHookHelper;
import oracle.ide.model.NoNamespaceRecognizerHookHelper;
import oracle.ide.model.Node;
import oracle.ide.model.NodeConversionRecognizerHookHelper;
import oracle.ide.model.PatternRecognizerHookHelper;
import oracle.ide.model.ProtocolRecognizerHookHelper;
import oracle.ide.model.Recognizer;
import oracle.ide.model.RootElementRecognizerHookHelper;
import oracle.ide.model.SchemaRecognizerHookHelper;
import oracle.ide.xml.XMLRecognizer;
import oracle.ideimpl.extension.IDEExtension;
import oracle.ideimpl.extension.LayerRegistrationHook;
import oracle.javatools.data.HashStructure;
import oracle.javatools.util.ImageIconCache;
import oracle.javatools.util.Pair;

public class RecognizersHook
extends HashStructureHook {
    public static final ElementName HOOK_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "node-recognizers-hook");
    private static final Logger LOG = Logger.getLogger(RecognizersHook.class.getName());
    private final Map<String, Set<String>> nodeConversions = new ConcurrentHashMap<String, Set<String>>();
    private final Map<File, ContentType> extensionToContentTypes = new ConcurrentHashMap<File, ContentType>();
    private final Map<File, MetaClass<Node>> fileExtensionMappings = new ConcurrentHashMap<File, MetaClass<Node>>();
    private final Map<String, MetaClass<Node>> protocolMappings = new ConcurrentHashMap<String, MetaClass<Node>>();
    private final Map<XMLRecognizer.NSElem, MetaClass<Node>> namespaceMappings = new ConcurrentHashMap<XMLRecognizer.NSElem, MetaClass<Node>>();
    private final Map<XMLRecognizer.NSElem, Map<XMLRecognizer.Attributes, MetaClass<Node>>> namespaceAttributesMappings = new ConcurrentHashMap<XMLRecognizer.NSElem, Map<XMLRecognizer.Attributes, MetaClass<Node>>>();
    private final Map<XMLRecognizer.NSElem, MetaClass<Node>> schemaMappings = new ConcurrentHashMap<XMLRecognizer.NSElem, MetaClass<Node>>();
    private final Map<XMLRecognizer.Doctype, MetaClass<Node>> docTypeMappings = new ConcurrentHashMap<XMLRecognizer.Doctype, MetaClass<Node>>();
    private final Map<String, MetaClass<Node>> rootElementMappings = new ConcurrentHashMap<String, MetaClass<Node>>();
    private final Map<String, List<XMLRecognizer.NoNamespaceRule>> noNamespaceMappings = new ConcurrentHashMap<String, List<XMLRecognizer.NoNamespaceRule>>();
    private final Map<File, List<FileContentPatternRecognizer.FileContentPatternRule>> patternMappings = new ConcurrentHashMap<File, List<FileContentPatternRecognizer.FileContentPatternRule>>();
    private final Map<File, List<AbstractFileContentRecognizerTemplate.FileContentRule>> contentMappings = new ConcurrentHashMap<File, List<AbstractFileContentRecognizerTemplate.FileContentRule>>();
    private final Collection<AbstractFileContentRecognizerTemplate.FileContentRule> lowPriorityContentMappings = new CopyOnWriteArraySet<AbstractFileContentRecognizerTemplate.FileContentRule>();
    private final Map<String, Recognizer.DeclarativeDocumentInfo> documentInfoMappings = new ConcurrentHashMap<String, Recognizer.DeclarativeDocumentInfo>();
    private static final String NO_ICON = "";
    public static final String NO_PROTOCOL = "";
    private static final String NO_EXTENSION = "";
    private static final String NO_INCLUDES = "";
    private static final String NO_EXCLUDES = "";
    private static final String NO_TYPE = "";

    public static RecognizersHook getHook() {
        try {
            ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
            return (RecognizersHook)registry.getHook(HOOK_NAME);
        }
        catch (Exception e) {
            return null;
        }
    }

    public RecognizersHook() {
        super(true);
        Recognizer.mapExtensionToXML(".xml");
        HashStructure hs = this.getHashStructure();
        this.populateMappings(hs);
        this.addHashStructureHookListener(new HashStructureHookListener(){

            @Override
            public void listenerAttached(HashStructureHookEvent e) {
            }

            @Override
            public void elementVisited(HashStructureHookEvent e) {
                HashStructure newHs = e.getNewElementHashStructure();
                RecognizersHook.this.populateMappings(newHs);
            }
        });
    }

    private void populateMappings(HashStructure hs) {
        this.nodeConversions.putAll(NodeConversionRecognizerHookHelper.findNodeConversions(hs));
        this.extensionToContentTypes.putAll(ExtensionToContentRecognizerHookHelper.findExtensionToContentTypes(hs));
        this.fileExtensionMappings.putAll(FileExtensionRecognizerHookHelper.findFileExtensionMappings(hs));
        this.protocolMappings.putAll(ProtocolRecognizerHookHelper.findProtocolMappings(hs));
        Pair<Map<XMLRecognizer.NSElem, MetaClass<Node>>, Map<XMLRecognizer.NSElem, Map<XMLRecognizer.Attributes, MetaClass<Node>>>> nsMappings = NamespaceRecognizerHookHelper.findNamespaceMappings(hs);
        this.namespaceMappings.putAll((Map)nsMappings.first);
        this.namespaceAttributesMappings.putAll((Map)nsMappings.second);
        this.schemaMappings.putAll(SchemaRecognizerHookHelper.findSchemaMappings(hs));
        this.docTypeMappings.putAll(DocTypeRecognizerHookHelper.findDocTypeMappings(hs));
        this.rootElementMappings.putAll(RootElementRecognizerHookHelper.findRootElementMappings(hs));
        RecognizersHook.updateMultimap(this.noNamespaceMappings, NoNamespaceRecognizerHookHelper.findNoNamespaceMappings(hs));
        RecognizersHook.updateMultimap(this.patternMappings, PatternRecognizerHookHelper.findPatternMappings(hs));
        RecognizersHook.updateMultimap(this.contentMappings, ContentRecognizerHookHelper.findContentMappingsByExtension(hs));
        this.lowPriorityContentMappings.addAll(LowPriorityContentRecognizerHelper.findLowPriorityContentMappings(hs));
        this.documentInfoMappings.putAll(DocumentInfoRecognizerHookHelper.findDocumentInfoMappings(hs));
    }

    private static <K, V> void updateMultimap(Map<K, List<V>> target, Map<K, List<V>> src) {
        for (Map.Entry<K, List<V>> e : src.entrySet()) {
            K key = e.getKey();
            for (V value : e.getValue()) {
                RecognizersHook.addToMultimap(target, key, value);
            }
        }
    }

    private static <K, V> void updateSetMultimap(Map<K, Set<V>> target, Map<K, Set<V>> src) {
        for (Map.Entry<K, Set<V>> e : src.entrySet()) {
            K key = e.getKey();
            for (V value : e.getValue()) {
                RecognizersHook.addToSetMultimap(target, key, value);
            }
        }
    }

    static <K, V> void addToMultimap(Map<K, List<V>> target, K key, V value) {
        List<V> list = target.get(key);
        if (list == null) {
            list = new ArrayList<V>();
            target.put(key, list);
        }
        list.add(value);
    }

    static <K, V> void addToSetMultimap(Map<K, Set<V>> target, K key, V value) {
        Set<V> list = target.get(key);
        if (list == null) {
            list = new HashSet<V>();
            target.put(key, list);
        }
        list.add(value);
    }

    Map<String, Set<String>> nodeConversions() {
        return Collections.unmodifiableMap(this.nodeConversions);
    }

    Map<File, ContentType> extensionToContentTypes() {
        return Collections.unmodifiableMap(this.extensionToContentTypes);
    }

    Map<File, MetaClass<Node>> fileExtensionMappings() {
        return Collections.unmodifiableMap(this.fileExtensionMappings);
    }

    Map<String, MetaClass<Node>> protocolMappings() {
        return Collections.unmodifiableMap(this.protocolMappings);
    }

    public Map<XMLRecognizer.NSElem, MetaClass<Node>> namespaceMappings() {
        return Collections.unmodifiableMap(this.namespaceMappings);
    }

    public Map<XMLRecognizer.NSElem, Map<XMLRecognizer.Attributes, MetaClass<Node>>> namespaceAttributesMappings() {
        return Collections.unmodifiableMap(this.namespaceAttributesMappings);
    }

    public Map<XMLRecognizer.NSElem, MetaClass<Node>> schemaMappings() {
        return Collections.unmodifiableMap(this.schemaMappings);
    }

    public Map<XMLRecognizer.Doctype, MetaClass<Node>> docTypeMappings() {
        return Collections.unmodifiableMap(this.docTypeMappings);
    }

    public Map<String, MetaClass<Node>> rootElementMappings() {
        return Collections.unmodifiableMap(this.rootElementMappings);
    }

    public Map<String, List<XMLRecognizer.NoNamespaceRule>> noNamespaceMappings() {
        return Collections.unmodifiableMap(this.noNamespaceMappings);
    }

    Map<File, List<FileContentPatternRecognizer.FileContentPatternRule>> patternMappings() {
        return Collections.unmodifiableMap(this.patternMappings);
    }

    Map<File, List<AbstractFileContentRecognizerTemplate.FileContentRule>> contentMappings() {
        return Collections.unmodifiableMap(this.contentMappings);
    }

    Collection<AbstractFileContentRecognizerTemplate.FileContentRule> lowPriorityContentMappings() {
        return Collections.unmodifiableCollection(this.lowPriorityContentMappings);
    }

    Map<String, Recognizer.DeclarativeDocumentInfo> documentInfoMappings() {
        return Collections.unmodifiableMap(this.documentInfoMappings);
    }

    private void registerNodeConversions(NodeRecognizer nr) {
        HashMap m = new HashMap();
        for (NodeConversion nc : nr.nodeCoverisons()) {
            RecognizersHook.addToSetMultimap(m, nc.oldType(), nc.newType());
        }
        this.nodeConversions.putAll(m);
    }

    private void registerExtensionToContentType(NodeRecognizer nr) {
        HashMap<File, ContentType> m = new HashMap<File, ContentType>();
        for (ExtensionToContentType etc : nr.extensionToContentTypes()) {
            File ext = Recognizer.sanitizeExtension(etc.extension());
            m.put(ext, etc.content().toContentType());
        }
        this.extensionToContentTypes.putAll(m);
    }

    private void registerFileExtensionMappings(UrlRecognizer ur, IDEExtension info) {
        HashMap<File, MetaClass> m = new HashMap<File, MetaClass>();
        for (UrlRecognizer.FileExtension fex : ur.fileExtensions()) {
            String fileExt = fex.extension();
            String className = RecognizersHook.sanitizeClassName(fex.nodeType());
            MetaClass type = new MetaClass(RecognizersHook.getExtClassLoader(info), className);
            if (type == null) {
                LOG.log(Level.WARNING, "Missing type in <url-recognizer> registration for extension " + fileExt);
                return;
            }
            if (fileExt == null) {
                LOG.log(Level.WARNING, "Missing extension in <url-recognizer> registration for type " + (type == null ? "null" : type.getClassName()));
                return;
            }
            m.put(Recognizer.sanitizeExtension(fileExt), type);
        }
        this.fileExtensionMappings.putAll(m);
    }

    private void registerProtocolMappings(UrlRecognizer ur, IDEExtension info) {
        HashMap<String, MetaClass> m = new HashMap<String, MetaClass>();
        for (UrlRecognizer.Protocol pro : ur.protocols()) {
            MetaClass metaClass = new MetaClass(RecognizersHook.getExtClassLoader(info), RecognizersHook.sanitizeClassName(pro.nodeType()));
            m.put(pro.protocol(), metaClass);
        }
        this.protocolMappings.putAll(m);
    }

    private void registerNamespaceMappings(XmlRecognizer xr, IDEExtension info) {
        HashMap<XMLRecognizer.NSElem, MetaClass> m = new HashMap<XMLRecognizer.NSElem, MetaClass>();
        for (XmlRecognizer.Namespace ns : xr.namespace()) {
            MetaClass metaClass = new MetaClass(RecognizersHook.getExtClassLoader(info), RecognizersHook.sanitizeClassName(ns.nodeType()));
            RecognizersHook.registerXMLExtension(ns.fileExtension());
            m.put(new XMLRecognizer.NSElem(ns.uri(), ns.elemName()), metaClass);
        }
        this.namespaceMappings.putAll(m);
    }

    private void registerSchemaMappings(XmlRecognizer xr, IDEExtension info) {
        HashMap<XMLRecognizer.NSElem, MetaClass> m = new HashMap<XMLRecognizer.NSElem, MetaClass>();
        for (XmlRecognizer.Schema s : xr.schema()) {
            MetaClass metaClass = new MetaClass(RecognizersHook.getExtClassLoader(info), RecognizersHook.sanitizeClassName(s.nodeType()));
            RecognizersHook.registerXMLExtension(s.fileExtension());
            m.put(new XMLRecognizer.NSElem(s.uri(), s.rootElemName()), metaClass);
        }
        this.schemaMappings.putAll(m);
    }

    private void registerRootElementMappings(XmlRecognizer xr, IDEExtension info) {
        HashMap<String, MetaClass> m = new HashMap<String, MetaClass>();
        for (XmlRecognizer.RootElem r : xr.rootElem()) {
            MetaClass metaClass = new MetaClass(RecognizersHook.getExtClassLoader(info), RecognizersHook.sanitizeClassName(r.nodeType()));
            RecognizersHook.registerXMLExtension(r.fileExtension());
            m.put(r.elemName(), metaClass);
        }
        this.rootElementMappings.putAll(m);
    }

    private void registerDocTypeMappings(XmlRecognizer xr, IDEExtension info) {
        HashMap<XMLRecognizer.Doctype, MetaClass> m = new HashMap<XMLRecognizer.Doctype, MetaClass>();
        for (XmlRecognizer.DocType d : xr.docType()) {
            MetaClass metaClass = new MetaClass(RecognizersHook.getExtClassLoader(info), RecognizersHook.sanitizeClassName(d.nodeType()));
            RecognizersHook.registerXMLExtension(d.fileExtension());
            m.put(new XMLRecognizer.Doctype(d.publicId(), d.systemId()), metaClass);
        }
        this.docTypeMappings.putAll(m);
    }

    private void registerNoNamespaceMappings(XmlRecognizer xr, IDEExtension info) {
        HashMap<String, ArrayList<XMLRecognizer.NoNamespaceRule>> m = new HashMap<String, ArrayList<XMLRecognizer.NoNamespaceRule>>();
        for (XmlRecognizer.NoNamespace nn : xr.noNamespace()) {
            String rootElement = nn.elemName();
            String[] excludeFiles = RecognizersHook.split(nn.excludeFilenames());
            String[] includeFiles = RecognizersHook.split(nn.includeFilenames());
            MetaClass metaClass = new MetaClass(RecognizersHook.getExtClassLoader(info), RecognizersHook.sanitizeClassName(nn.nodeType()));
            XMLRecognizer.NoNamespaceRule rule = new XMLRecognizer.NoNamespaceRule(rootElement, excludeFiles, includeFiles, metaClass);
            ArrayList<XMLRecognizer.NoNamespaceRule> rules = (ArrayList<XMLRecognizer.NoNamespaceRule>)m.get(rootElement);
            if (rules == null) {
                rules = new ArrayList<XMLRecognizer.NoNamespaceRule>();
                m.put(rootElement, rules);
            }
            rules.add(rule);
        }
        RecognizersHook.updateMultimap(this.noNamespaceMappings, m);
    }

    private void registerPatternMappings(NodeRecognizer nr, IDEExtension info) {
        HashMap m = new HashMap();
        for (ContentPatternRecognizer.LinePattern lp : nr.contentPatternRecognizer().anyLineStartingWithPattern()) {
            MetaClass metaClass = new MetaClass(RecognizersHook.getExtClassLoader(info), RecognizersHook.sanitizeClassName(lp.nodeType()));
            FileContentPatternRecognizer.FileContentPatternRule rule = new FileContentPatternRecognizer.FileContentPatternRule(lp.maxLinesToRead(), lp.patterns(), (MetaClass<Node>)metaClass);
            RecognizersHook.addToMultimap(m, Recognizer.sanitizeExtension(lp.extension()), rule);
        }
        RecognizersHook.updateMultimap(this.patternMappings, m);
    }

    private void registerContentMappings(NodeRecognizer nr, IDEExtension info) {
        HashMap m = new HashMap();
        for (ContentRecognizer cr : nr.contentRecognizer()) {
            String ext = cr.extension();
            if (ext == null || ext.length() == 0) continue;
            File fExt = Recognizer.sanitizeExtension(ext);
            ArrayList<AbstractFileContentRecognizerTemplate.ContentToLookFor> contents = new ArrayList<AbstractFileContentRecognizerTemplate.ContentToLookFor>(cr.contains().length);
            for (ContentRecognizer.Contains c : cr.contains()) {
                contents.add(new AbstractFileContentRecognizerTemplate.ContentToLookFor(c.text(), c.position()));
            }
            MetaClass metaClass = new MetaClass(RecognizersHook.getExtClassLoader(info), RecognizersHook.sanitizeClassName(cr.nodeType()));
            RecognizersHook.addToMultimap(m, fExt, new AbstractFileContentRecognizerTemplate.FileContentRule(cr.protocol(), fExt, contents, (MetaClass<Node>)metaClass));
        }
        RecognizersHook.updateMultimap(this.contentMappings, m);
    }

    private void registerLowPriorityContentMappings(NodeRecognizer nr, IDEExtension info) {
        ArrayList<AbstractFileContentRecognizerTemplate.FileContentRule> m = new ArrayList<AbstractFileContentRecognizerTemplate.FileContentRule>();
        for (ContentRecognizer cr : nr.contentRecognizer()) {
            String ext = cr.extension();
            File fExt = ext != null && ext.length() > 0 ? Recognizer.sanitizeExtension(ext) : null;
            ArrayList<AbstractFileContentRecognizerTemplate.ContentToLookFor> contents = new ArrayList<AbstractFileContentRecognizerTemplate.ContentToLookFor>(cr.contains().length);
            for (ContentRecognizer.Contains c : cr.contains()) {
                contents.add(new AbstractFileContentRecognizerTemplate.ContentToLookFor(c.text(), c.position()));
            }
            MetaClass metaClass = new MetaClass(RecognizersHook.getExtClassLoader(info), RecognizersHook.sanitizeClassName(cr.nodeType()));
            m.add(new AbstractFileContentRecognizerTemplate.FileContentRule(cr.protocol(), fExt, contents, (MetaClass<Node>)metaClass));
        }
        this.lowPriorityContentMappings.addAll(m);
    }

    private void registerDocumentInfoMappings(NodeRecognizer nr, IDEExtension extInfo) {
        HashMap<String, Recognizer.DeclarativeDocumentInfo> m = new HashMap<String, Recognizer.DeclarativeDocumentInfo>();
        for (DocumentInfo di : nr.documentInfos()) {
            URL iconUrl;
            MetaClass type = new MetaClass(RecognizersHook.getExtClassLoader(extInfo), RecognizersHook.sanitizeClassName(di.nodeType()));
            oracle.ide.model.DocumentInfo info = new oracle.ide.model.DocumentInfo(di.label(), di.hidden());
            String icon = RecognizersHook.sanitizeClassName(di.icon());
            URL uRL = iconUrl = icon == null ? null : this.getURL(icon, "icon");
            if (iconUrl != null) {
                ImageIcon imageIcon = ImageIconCache.get((URL)iconUrl);
                ImageIcon result = null;
                if (imageIcon.getImageLoadStatus() == 8) {
                    result = imageIcon;
                }
                if (result != null) {
                    info.setIcon(result);
                }
            }
            m.put(type.getClassName(), new Recognizer.DeclarativeDocumentInfo(info, type));
        }
        this.documentInfoMappings.putAll(m);
    }

    private static String sanitizeClassName(String className) {
        if (className == null || (className = className.trim()).length() == 0) {
            return null;
        }
        return className;
    }

    private URL getURL(String resolvedValue, String attrName) {
        String path;
        URI uri;
        if (resolvedValue.startsWith("uri:") && (uri = URIFactory.newURI((String)(path = resolvedValue.substring(4)))) != null) {
            try {
                URL url = VirtualFileSystem.getVirtualFileSystem().toURL(uri);
                return url;
            }
            catch (MalformedURLException mue) {
                LOG.log(Level.WARNING, "Malformed URL exception for attribute '" + attrName + "' using path='" + path + "'.");
                return null;
            }
        }
        return null;
    }

    private static void registerXMLExtension(String extension) {
        if (extension != null && !extension.isEmpty()) {
            Recognizer.mapExtensionToXML(extension);
        }
    }

    private static String[] split(String s) {
        return s == null || s.isEmpty() ? new String[]{} : s.split(",");
    }

    private static ClassLoader getExtClassLoader(IDEExtension ext) {
        return ExtensionRegistry.getExtensionRegistry().getClassLoader(ext.getID());
    }

    public static @interface NodeRecognizer {
        @LayerRegistrationHook.Tag(value={"node-conversions", "node-conversion"})
        public NodeConversion[] nodeCoverisons() default {};

        @LayerRegistrationHook.Tag(value={"document-infos", "document-info"})
        public DocumentInfo[] documentInfos() default {};

        @LayerRegistrationHook.Tag(value={"extension-to-content-type", "mapping"})
        public ExtensionToContentType[] extensionToContentTypes() default {};

        @LayerRegistrationHook.Tag(value={"url-recognizer"})
        public UrlRecognizer urlRecognizer() default @UrlRecognizer;

        @LayerRegistrationHook.Tag(value={"content-pattern-recognizer"})
        public ContentPatternRecognizer contentPatternRecognizer() default @ContentPatternRecognizer;

        @LayerRegistrationHook.Tag(value={"content-recognizer", "content"})
        public ContentRecognizer[] contentRecognizer() default {};

        @LayerRegistrationHook.Tag(value={"low-priority-content-recognizer", "content"})
        public ContentRecognizer lowPrirorityContentRecognizer() default @ContentRecognizer;

        @LayerRegistrationHook.Tag(value={"xml-recognizer"})
        public XmlRecognizer xmlRecognizer() default @XmlRecognizer;
    }

    public static @interface NodeConversion {
        @LayerRegistrationHook.Tag(value={"old-type"})
        public String oldType();

        @LayerRegistrationHook.Tag(value={"new-type"})
        public String newType();
    }

    public static @interface ExtensionToContentType {
        @LayerRegistrationHook.Attr(value="extension")
        public String extension();

        @LayerRegistrationHook.Attr(value="content")
        public Content content();

        public static enum Content {
            TEXT(ContentType.TEXT),
            BINARY(ContentType.BINARY);

            private ContentType contentType;

            private Content(ContentType contentType) {
                this.contentType = contentType;
            }

            public ContentType toContentType() {
                return this.contentType;
            }
        }
    }

    public static @interface UrlRecognizer {
        @LayerRegistrationHook.Tag(value={"file-extension"})
        public FileExtension[] fileExtensions() default {};

        @LayerRegistrationHook.Tag(value={"protocol"})
        public Protocol[] protocols() default {};

        public static @interface Protocol {
            @LayerRegistrationHook.Tag(value={"protocol"})
            public String protocol();

            @LayerRegistrationHook.Tag(value={"node-type"})
            public String nodeType();
        }

        public static @interface FileExtension {
            @LayerRegistrationHook.Tag(value={"extension"})
            public String extension();

            @LayerRegistrationHook.Tag(value={"node-type"})
            public String nodeType();
        }
    }

    public static @interface XmlRecognizer {
        @LayerRegistrationHook.Tag(value={"namespace"})
        public Namespace[] namespace() default {};

        @LayerRegistrationHook.Tag(value={"schema"})
        public Schema[] schema() default {};

        @LayerRegistrationHook.Tag(value={"doctype"})
        public DocType[] docType() default {};

        @LayerRegistrationHook.Tag(value={"root-elem"})
        public RootElem[] rootElem() default {};

        @LayerRegistrationHook.Tag(value={"no-namespace"})
        public NoNamespace[] noNamespace() default {};

        public static @interface NoNamespace {
            @LayerRegistrationHook.Tag(value={"elem-name"})
            public String elemName();

            @LayerRegistrationHook.Tag(value={"node-type"})
            public String nodeType();

            @LayerRegistrationHook.Tag(value={"exclude-filenames"})
            public String excludeFilenames() default "";

            @LayerRegistrationHook.Tag(value={"include-filenames"})
            public String includeFilenames() default "";
        }

        public static @interface RootElem {
            @LayerRegistrationHook.Tag(value={"elem-name"})
            public String elemName();

            @LayerRegistrationHook.Tag(value={"node-type"})
            public String nodeType();

            @LayerRegistrationHook.Tag(value={"file-extension"})
            public String fileExtension() default "";
        }

        public static @interface DocType {
            @LayerRegistrationHook.Tag(value={"public-id"})
            public String publicId();

            @LayerRegistrationHook.Tag(value={"system-id"})
            public String systemId();

            @LayerRegistrationHook.Tag(value={"node-type"})
            public String nodeType();

            @LayerRegistrationHook.Tag(value={"file-extension"})
            public String fileExtension() default "";
        }

        public static @interface Schema {
            @LayerRegistrationHook.Tag(value={"uri"})
            public String uri();

            @LayerRegistrationHook.Tag(value={"root-elem-name"})
            public String rootElemName();

            @LayerRegistrationHook.Tag(value={"node-type"})
            public String nodeType();

            @LayerRegistrationHook.Tag(value={"file-extension"})
            public String fileExtension() default "";
        }

        public static @interface Namespace {
            @LayerRegistrationHook.Tag(value={"uri"})
            public String uri();

            @LayerRegistrationHook.Tag(value={"elem-name"})
            public String elemName();

            @LayerRegistrationHook.Tag(value={"node-type"})
            public String nodeType();

            @LayerRegistrationHook.Tag(value={"file-extension"})
            public String fileExtension() default "";
        }
    }

    public static @interface ContentPatternRecognizer {
        @LayerRegistrationHook.Tag(value={"any-line-starting-with-pattern"})
        public LinePattern[] anyLineStartingWithPattern() default {};

        public static @interface LinePattern {
            @LayerRegistrationHook.Tag(value={"extension"})
            public String extension();

            @LayerRegistrationHook.Tag(value={"node-type"})
            public String nodeType();

            @LayerRegistrationHook.Tag(value={"max-lines-to-read"})
            public int maxLinesToRead() default 250;

            @LayerRegistrationHook.Tag(value={"patterns", "pattern"})
            public String[] patterns();
        }
    }

    public static @interface ContentRecognizer {
        @LayerRegistrationHook.Tag(value={"extension"})
        public String extension() default "";

        @LayerRegistrationHook.Tag(value={"protocol"})
        public String protocol() default "";

        @LayerRegistrationHook.Tag(value={"contents", "contains"})
        public Contains[] contains() default {};

        @LayerRegistrationHook.Tag(value={"node-type"})
        public String nodeType() default "";

        public static @interface Contains {
            @LayerRegistrationHook.Tag(value={"text"})
            public String text();

            @LayerRegistrationHook.Tag(value={"position"})
            public int position();
        }
    }

    public static @interface DocumentInfo {
        @LayerRegistrationHook.Tag(value={"label"})
        public String label();

        @LayerRegistrationHook.Tag(value={"hidden"})
        public boolean hidden() default false;

        @LayerRegistrationHook.Tag(value={"icon"})
        public String icon() default "";

        @LayerRegistrationHook.Tag(value={"node-type"})
        public String nodeType();
    }
}

