/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ElementName;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.util.MetaClass;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.model.ContentSetProviderReference;
import oracle.ide.util.PatternFilters;
import oracle.javatools.data.HashStructure;

public class ContentSetProvidersHook
extends HashStructureHook {
    public static final ElementName HOOK_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "content-set-providers-hook");
    private static final Logger _logger = Logger.getLogger(ContentSetProvidersHook.class.getName());
    private final List<ContentSetProviderReference> references = new CopyOnWriteArrayList<ContentSetProviderReference>();

    public static ContentSetProvidersHook getHook() {
        ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
        return (ContentSetProvidersHook)registry.getHook(HOOK_NAME);
    }

    public ContentSetProvidersHook() {
        super(true);
        this.populateContentSetProviders(this.getHashStructure());
        this.addHashStructureHookListener(new HashStructureHookListener(){

            @Override
            public void elementVisited(HashStructureHookEvent e) {
                ContentSetProvidersHook.this.populateContentSetProviders(e.getNewElementHashStructure());
            }

            @Override
            public void listenerAttached(HashStructureHookEvent e) {
            }
        });
    }

    private void populateContentSetProviders(HashStructure hs) {
        this.references.addAll(ContentSetProvidersHook.contentSetProviders(hs));
    }

    private static List<ContentSetProviderReference> contentSetProviders(HashStructure hs) {
        ArrayList<ContentSetProviderReference> list = new ArrayList<ContentSetProviderReference>();
        List listeners = hs.getAsList("content-set-provider");
        if (listeners == null) {
            return list;
        }
        for (Object o : listeners) {
            if (!(o instanceof HashStructure)) continue;
            HashStructure childHs = (HashStructure)o;
            String extensionId = HashStructureHook.getExtensionId(childHs);
            ContentSetProviderReference c = ContentSetProvidersHook.contentSetProviderFrom(childHs);
            c.extensionId(extensionId);
            list.add(c);
            if (!c.isDefaultContentSet() || c.hasNavigable()) continue;
            _logger.log(Level.SEVERE, ContentSetProvidersHook.getExtensionId(hs) + " registers " + c.key() + " as the default content set, but does not provide a Navigable.");
        }
        return list;
    }

    private static ContentSetProviderReference contentSetProviderFrom(HashStructure hs) {
        String label = hs.getString("label/#text");
        String navigableLabel = hs.getString("navigable-label/#text");
        boolean isDefaultContentSetNavigable = hs.getBoolean("defaultContentSet", false);
        boolean showInDefaultProject = hs.getBoolean("showInDefaultProject", true);
        String key = hs.getString("key/#text");
        boolean displayFoldersAsPackages = hs.getBoolean("display-folders-as-packages/#text", false);
        boolean canContainJavaSources = hs.getBoolean("can-contain-java-sources/#text", false);
        boolean flatLevelEnabled = hs.getBoolean("flat-level-enabled/#text", false);
        boolean alwaysShowEmptyFolders = hs.getBoolean("always-show-empty-folders/#text", false);
        boolean applicationLevelContent = hs.getBoolean("application-level-content/#text", false);
        MetaClass metaClass = LazyClassAdapter.getInstance(hs).getMetaClass("class/#text");
        String defaultSourceFolder = hs.getString("default-source-folder/#text");
        String includes = hs.getString("filters/include/#text");
        String excludes = hs.getString("filters/exclude/#text");
        PatternFilters filters = ContentSetProvidersHook.createPatternFilters(includes, excludes);
        if (includes == null && excludes == null) {
            _logger.log(Level.SEVERE, ContentSetProvidersHook.getExtensionId(hs) + " must define include and/or exclude filters.");
        }
        String noAexIncludes = hs.getString("no-autoexpand-filters/include/#text");
        String noAexExcludes = hs.getString("no-autoexpand-filters/exclude/#text");
        PatternFilters noAexFilters = noAexIncludes == null && noAexExcludes == null ? null : ContentSetProvidersHook.createPatternFilters(noAexIncludes, noAexExcludes);
        ContentSetProviderReference cspr = new ContentSetProviderReference(label, navigableLabel, key, isDefaultContentSetNavigable, showInDefaultProject, applicationLevelContent, displayFoldersAsPackages, canContainJavaSources, flatLevelEnabled, alwaysShowEmptyFolders, metaClass, defaultSourceFolder, filters);
        cspr.setNoAutoexpandFilters(noAexFilters);
        return cspr;
    }

    private static PatternFilters createPatternFilters(String includes, String excludes) {
        PatternFilters filters = PatternFilters.getInstance(HashStructure.newInstance());
        if (includes != null) {
            for (String includeToken : includes.split(",")) {
                filters.addInclude(includeToken);
            }
        }
        if (excludes != null) {
            for (String excludeToken : excludes.split(",")) {
                filters.addExclude(excludeToken);
            }
        }
        return filters;
    }

    public List<ContentSetProviderReference> contentSetProviderReferences() {
        return Collections.unmodifiableList(this.references);
    }
}

