/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.log;

import java.awt.Component;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.text.Document;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeClipboard;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.layout.ViewId;
import oracle.ide.log.AbstractLogPage;
import oracle.ide.log.LogManager;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.resource.DialogsArb;
import oracle.ide.resource.IdeArb;
import oracle.ide.resource.LogArb;
import oracle.ide.util.AccessibleUtils;
import oracle.ide.util.Assert;
import oracle.ide.util.BitField;

public class DefaultLogPage
extends AbstractLogPage {
    private static int _shift = 0;
    public static final int HIDE_NO_MENUS = 0;
    public static final int HIDE_COPY_MENU = 1 << _shift++;
    public static final int HIDE_SAVE_AS_MENU = 1 << _shift++;
    public static final int HIDE_GOTO_SOURCE_MENU = 1 << _shift++;
    public static final int HIDE_FIX_SOURCE_MENU = 1 << _shift++;
    public static final int HIDE_ALL_MENUS = HIDE_COPY_MENU | HIDE_SAVE_AS_MENU | HIDE_GOTO_SOURCE_MENU | HIDE_FIX_SOURCE_MENU;
    protected static final int GOTO_SOURCE_CMD_ID = Ide.findOrCreateCmdID("GOTO_SOURCE_CMD_ID");
    protected static final int FIX_SOURCE_CMD_ID = Ide.findOrCreateCmdID("FIX_SOURCE_CMD_ID");
    private static URL _lastSaveToFileURL = null;
    protected MouseAdapter mouseAdapter = new DefaultAdapter();
    protected KeyAdapter keyAdapter = new DefaultKeyAdapter();
    private Controller _controller;
    private JMenuItem _copyMenu;
    private JMenuItem _saveAsMenu;
    private JMenuItem _gotoSourceMenu;
    private JMenuItem _fixSourceMenu;
    private boolean _popupMenuItemsInitialized;
    private JTree tree;
    private JTextArea textArea = new JTextArea();
    private JScrollPane scrollPane;

    protected DefaultLogPage(ViewId id, Icon icon, boolean addPage, int menuOptions) {
        super(id, icon, false);
        this.tree = this.getTree();
        this.scrollPane = new JScrollPane(this.tree);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.initPopupMenuItems(menuOptions);
        this.textArea.setEditable(false);
        this.textArea.setToolTipText(this.getToolTip());
        this.tree.addMouseListener(this.mouseAdapter);
        this.tree.addKeyListener(this.keyAdapter);
        this.tree.setRootVisible(false);
        this.tree.setToolTipText(this.getToolTip());
        this.tree.getSelectionModel().setSelectionMode(1);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        if (addPage) {
            LogManager.getLogManager().addPage(this);
        }
    }

    protected DefaultLogPage(ViewId id, Icon icon, boolean addPage) {
        this(id, icon, false, HIDE_FIX_SOURCE_MENU);
    }

    protected void setModel(TreeModel model) {
        if (this.tree == null || model == null) {
            return;
        }
        this.tree.setModel(model);
        int rowCount = this.tree.getRowCount();
        if (rowCount > 0) {
            if (this.tree.isRootVisible()) {
                this.tree.setSelectionRow(0);
            } else if (rowCount > 1) {
                this.tree.setSelectionRow(1);
            }
        }
    }

    private void initPopupMenuItems(int options) {
        if (!this._popupMenuItemsInitialized) {
            this._popupMenuItemsInitialized = true;
            ContextMenu cm = LogManager.getLogManager().getContextMenu();
            IdeAction action = null;
            if (!BitField.isSet(options, HIDE_COPY_MENU)) {
                action = IdeAction.find(18);
                this._copyMenu = cm.createMenuItem(action, MenuConstants.WEIGHT_EDIT_COPY);
            }
            if (!BitField.isSet(options, HIDE_SAVE_AS_MENU)) {
                action = IdeAction.find(12);
                this._saveAsMenu = cm.createMenuItem(action, MenuConstants.WEIGHT_LOG_WINDOW_SAVE_AS);
            }
            if (!BitField.isSet(options, HIDE_GOTO_SOURCE_MENU)) {
                action = IdeAction.get(GOTO_SOURCE_CMD_ID, null, StringUtils.stripMnemonic((String)LogArb.getString(10)), (String)null, (Integer)StringUtils.getMnemonicKeyCode((String)LogArb.getString(10)), LogArb.getInstance(), 12, null, true);
                this._gotoSourceMenu = cm.createMenuItem(action, MenuConstants.WEIGHT_NAVIGATE_GO_TO_CLASS);
            }
            if (!BitField.isSet(options, HIDE_FIX_SOURCE_MENU)) {
                action = IdeAction.get(FIX_SOURCE_CMD_ID, null, StringUtils.stripMnemonic((String)LogArb.getString(20)), (String)null, (Integer)StringUtils.getMnemonicKeyCode((String)LogArb.getString(20)), LogArb.getInstance(), 22, null, true);
                this._fixSourceMenu = cm.createMenuItem(action);
            }
            if (action != null) {
                cm.addContextMenuListener(new PrivateContextMenuListener());
            }
        }
    }

    private Object getNextLeaf(int direction) {
        int pos = -1;
        if (this.tree.getSelectionPath() != null) {
            pos = this.tree.getRowForPath(this.tree.getSelectionPath());
        }
        while ((pos += direction) >= 0 && pos < this.tree.getRowCount()) {
            TreePath path = this.tree.getPathForRow(pos);
            Object lastPath = path.getLastPathComponent();
            if (!this.tree.getModel().isLeaf(lastPath)) continue;
            this.tree.setSelectionPath(path);
            return lastPath;
        }
        return null;
    }

    @Override
    public String getTitleName() {
        String s = super.getTitleName();
        AccessibleUtils.updateAccessibleName((Accessible)this.getTree(), (String)s, (boolean)true);
        AccessibleUtils.updateAccessibleName((Accessible)this.getTextArea(), (String)s, (boolean)true);
        return s;
    }

    @Override
    public Component getGUI() {
        return this.scrollPane;
    }

    protected final DefaultMutableTreeNode getSelectedTreeNode() {
        Object c;
        TreePath path = this.tree.getSelectionPath();
        if (path != null && (c = path.getLastPathComponent()) instanceof DefaultMutableTreeNode) {
            return (DefaultMutableTreeNode)c;
        }
        return null;
    }

    protected String treeNodeToString(Object treeNode) {
        return String.valueOf(treeNode);
    }

    protected final void copy(Object copyObject) {
        if (copyObject instanceof TreePath[]) {
            TreePath[] paths;
            String lineSeparator = System.getProperty("line.separator", "\n");
            StringBuffer sb = new StringBuffer(100);
            for (TreePath path : paths = (TreePath[])copyObject) {
                Object p = path.getLastPathComponent();
                sb.append(this.treeNodeToString(p));
                sb.append(lineSeparator);
            }
            StringSelection text = new StringSelection(sb.toString());
            IdeClipboard.getClipboard().setContents(text, null);
        } else if (copyObject instanceof String) {
            StringSelection text = new StringSelection((String)copyObject);
            IdeClipboard.getClipboard().setContents(text, null);
        }
    }

    public void asTextForTestingOnly(StringBuilder buffer) {
        String lineSeparator = System.getProperty("line.separator", "\n");
        int firstPC = 0;
        buffer.append("* Log page: '").append(this.getTitleName()).append("':").append(lineSeparator);
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            TreePath path = this.tree.getPathForRow(i);
            if (path != null) {
                Object obj;
                if (i == 0) {
                    firstPC = path.getPathCount();
                }
                if ((obj = path.getLastPathComponent()) != null) {
                    int spaceCount = (path.getPathCount() - firstPC) * 4;
                    for (int j = 0; j < spaceCount; ++j) {
                        buffer.append(" ");
                    }
                    buffer.append(this.treeNodeToString(obj)).append(lineSeparator);
                }
            }
            this.tree.expandPath(path);
        }
        buffer.append(lineSeparator);
    }

    protected void saveToFile(Context context) {
        if (this.usingTree() ? this.tree == null || this.tree.getRowCount() <= 0 : this.textArea.getDocument().getLength() == 0) {
            return;
        }
        String title = LogArb.getString(13);
        URLChooser chooser = DialogUtil.newURLChooser(context);
        chooser.clearChooseableURLFilters();
        String txtSuffix = ".txt";
        DefaultURLFilter txtFilter = new DefaultURLFilter(DialogsArb.getString(42), ".txt");
        chooser.addChooseableURLFilter((URLFilter)txtFilter);
        chooser.addChooseableURLFilter(URLChooser.ALL_FILES_FILTER);
        chooser.setHelpID("f1_idedsaveasrename_html");
        if (_lastSaveToFileURL != null) {
            chooser.setSelectedURL(_lastSaveToFileURL);
        }
        if (chooser.showSaveDialog((Component)((Object)Ide.getMainWindow()), title) == 0) {
            URL url = chooser.getSelectedURL();
            URLFilter selectedUrlFilter = chooser.getSelectedFilter();
            if (url != null) {
                if (txtFilter.equals((Object)selectedUrlFilter) && !URLFileSystem.hasSuffix((URL)url, (String)".txt") || "".equals(URLFileSystem.getSuffix((URL)url))) {
                    url = URLFactory.newFileURL((String)(url.getPath() + ".txt"));
                }
                _lastSaveToFileURL = url;
                WaitCursor wc = Ide.getWaitCursor();
                wc.show();
                try {
                    PrintStream ps;
                    String encoding = Ide.getEnvironOptions().getEncoding();
                    OutputStream os = URLFileSystem.openOutputStream((URL)url);
                    PrintStream printStream = ps = encoding == null ? new PrintStream(os) : new PrintStream(os, false, encoding);
                    if (this.usingTree()) {
                        int firstPC = 0;
                        for (int i = 0; i < this.tree.getRowCount(); ++i) {
                            Object obj;
                            TreePath path = this.tree.getPathForRow(i);
                            if (path == null) continue;
                            if (i == 0) {
                                firstPC = path.getPathCount();
                            }
                            if ((obj = path.getLastPathComponent()) == null) continue;
                            int spaceCount = (path.getPathCount() - firstPC) * 4;
                            for (int j = 0; j < spaceCount; ++j) {
                                ps.print(" ");
                            }
                            ps.println(this.treeNodeToString(obj));
                        }
                    } else {
                        ps.print(this.textArea.getText());
                    }
                    ps.flush();
                    ps.close();
                }
                catch (Exception e) {
                    String fileName = URLFileSystem.getPlatformPathName((URL)url);
                    String msg = LogArb.format(29, fileName);
                    JOptionPane.showMessageDialog((Component)((Object)Ide.getMainWindow()), msg, IdeArb.getString(240), 0);
                }
                wc.hide();
            }
        }
    }

    private boolean usingTree() {
        return this.getCurrentView() != null && this.getCurrentView() instanceof JTree;
    }

    @Override
    public Controller getController() {
        if (this._controller == null) {
            this._controller = new DefaultLogPageController();
        }
        return this._controller;
    }

    @Override
    public ContextMenu getContextMenu() {
        ContextMenu cm = LogManager.getLogManager().getContextMenu();
        return cm;
    }

    @Override
    public void clearAll() {
        if (this.tree != null) {
            this.tree.setModel(null);
        }
        if (this.textArea != null) {
            this.textArea.setText("");
            Document document = this.textArea.getDocument();
            if (document != null) {
                this.textArea.setCaretPosition(document.getLength());
            }
        }
        this.forceResizeNotification(this.textArea);
        this.forceResizeNotification(this.tree);
    }

    protected void forceResizeNotification(Component comp) {
        ComponentListener[] compListeners = comp.getComponentListeners();
        if (compListeners != null) {
            ComponentEvent ce = new ComponentEvent(comp, 101);
            for (ComponentListener cl : compListeners) {
                cl.componentResized(ce);
            }
        }
    }

    @Override
    public void addMouseListener(MouseListener listener) {
        if (listener != null) {
            this.textArea.addMouseListener(listener);
            this.tree.addMouseListener(listener);
        }
    }

    @Override
    public void removeMouseListener(MouseListener listener) {
        if (listener != null) {
            this.tree.removeMouseListener(listener);
            this.textArea.removeMouseListener(listener);
        }
    }

    public void addKeyListener(KeyListener listener) {
        if (listener != null) {
            this.textArea.addKeyListener(listener);
            this.tree.addKeyListener(listener);
        }
    }

    public void removeKeyListener(KeyListener listener) {
        if (listener != null) {
            this.tree.removeKeyListener(listener);
            this.textArea.removeKeyListener(listener);
        }
    }

    @Override
    protected void logMsg(Object msg) {
        if (msg instanceof Collection) {
            if (this.getCurrentView() != this.tree) {
                this.setCurrentView(this.tree);
            }
            this.updateTreeModel((Collection)msg);
        } else {
            this.logText(msg.toString());
        }
    }

    protected void logText(String msg) {
        if (this.getCurrentView() != this.textArea) {
            this.setCurrentView(this.textArea);
        }
        this.textArea.append(msg);
        this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
    }

    protected final Component getCurrentView() {
        JViewport viewport = this.scrollPane.getViewport();
        return viewport != null ? viewport.getView() : null;
    }

    protected final void setCurrentView(Component view) {
        this.scrollPane.setViewportView(view);
    }

    protected JTree createTree() {
        JTree tree = new JTree(null){

            @Override
            public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                return DefaultLogPage.this.treeNodeToString(value);
            }
        };
        return tree;
    }

    protected final JTree getTree() {
        if (this.tree == null) {
            this.tree = this.createTree();
        }
        return this.tree;
    }

    protected final JTextArea getTextArea() {
        return this.textArea;
    }

    protected void activateObject(Object obj) {
    }

    protected void fixObject(Object obj) {
    }

    protected boolean canFixObject(DefaultMutableTreeNode node) {
        return false;
    }

    protected void updateTreeModel(Collection message) {
        try {
            SwingUtilities.invokeLater(new DefaultModelBuilder(message));
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
    }

    private final class DefaultAdapter
    extends MouseAdapter {
        private DefaultAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e == null || e.getClickCount() != 2) {
                return;
            }
            TreePath path = DefaultLogPage.this.tree.getPathForLocation(e.getX(), e.getY());
            Object obj = path != null ? path.getLastPathComponent() : null;
            TreeModel model = DefaultLogPage.this.tree.getModel();
            if (obj != null && model != null && model.isLeaf(obj)) {
                DefaultLogPage.this.activateObject(obj);
            }
        }
    }

    private final class DefaultKeyAdapter
    extends KeyAdapter {
        private DefaultKeyAdapter() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (e == null || e.isConsumed() || e.getKeyChar() != '\n') {
                return;
            }
            TreeModel model = DefaultLogPage.this.tree.getModel();
            Object obj = DefaultLogPage.this.tree.getLastSelectedPathComponent();
            if (obj != null && model != null && model.isLeaf(obj)) {
                DefaultLogPage.this.activateObject(obj);
            }
        }
    }

    private class PrivateContextMenuListener
    implements ContextMenuListener {
        private PrivateContextMenuListener() {
        }

        @Override
        public void menuWillShow(ContextMenu popup) {
            if (popup == null) {
                return;
            }
            Context ctxt = popup.getContext();
            if (ctxt == null || ctxt.getView() != DefaultLogPage.this) {
                return;
            }
            if (DefaultLogPage.this._gotoSourceMenu != null) {
                popup.add((Component)DefaultLogPage.this._gotoSourceMenu, MenuConstants.SECTION_NAVIGATE_CTXT_MENU);
            }
            if (DefaultLogPage.this._fixSourceMenu != null) {
                popup.add((Component)DefaultLogPage.this._fixSourceMenu, MenuConstants.SECTION_LOG_WINDOW_CTXT_MENU);
            }
            if (DefaultLogPage.this._copyMenu != null) {
                popup.add((Component)DefaultLogPage.this._copyMenu, MenuConstants.SECTION_EDIT_CTXT_MENU);
            }
            if (DefaultLogPage.this._saveAsMenu != null) {
                popup.add((Component)DefaultLogPage.this._saveAsMenu, MenuConstants.SECTION_LOG_WINDOW_CTXT_MENU);
            }
        }

        @Override
        public void menuWillHide(ContextMenu popup) {
        }

        @Override
        public boolean handleDefaultAction(Context context) {
            return false;
        }
    }

    private class DefaultLogPageController
    implements Controller {
        private DefaultLogPageController() {
        }

        @Override
        public boolean handleEvent(IdeAction action, Context context) {
            if (action != null) {
                int cmdId = action.getCommandId();
                if (cmdId == 30 || cmdId == 31) {
                    Object obj = DefaultLogPage.this.getNextLeaf(cmdId == 31 ? -1 : 1);
                    if (obj != null) {
                        DefaultLogPage.this.tree.scrollPathToVisible(DefaultLogPage.this.tree.getSelectionPath());
                        DefaultLogPage.this.activateObject(obj);
                    }
                    return true;
                }
                if (cmdId == GOTO_SOURCE_CMD_ID || cmdId == FIX_SOURCE_CMD_ID) {
                    Object p;
                    TreePath path = DefaultLogPage.this.tree.getSelectionPath();
                    if (path != null && (p = path.getLastPathComponent()) != null) {
                        if (cmdId == GOTO_SOURCE_CMD_ID) {
                            DefaultLogPage.this.activateObject(p);
                        } else if (cmdId == FIX_SOURCE_CMD_ID) {
                            DefaultLogPage.this.fixObject(p);
                        }
                    }
                    return true;
                }
                if (cmdId == 18) {
                    if (DefaultLogPage.this.usingTree()) {
                        Object p;
                        TreePath path = DefaultLogPage.this.tree.getSelectionPath();
                        if (path != null && (p = path.getLastPathComponent()) != null) {
                            TreePath[] paths = DefaultLogPage.this.tree.getSelectionModel().getSelectionPaths();
                            DefaultLogPage.this.copy(paths);
                        }
                    } else {
                        DefaultLogPage.this.copy(DefaultLogPage.this.textArea.getSelectedText());
                    }
                    return true;
                }
                if (cmdId == 12) {
                    DefaultLogPage.this.saveToFile(context);
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean update(IdeAction action, Context context) {
            if (action == null) {
                return true;
            }
            int cmdId = action.getCommandId();
            if (cmdId == 30 || cmdId == 31) {
                action.setEnabled(DefaultLogPage.this.tree != null && DefaultLogPage.this.tree.getRowCount() > 0);
                return true;
            }
            if (cmdId == 12) {
                if (DefaultLogPage.this.usingTree()) {
                    action.setEnabled(DefaultLogPage.this.tree != null && DefaultLogPage.this.tree.getRowCount() > 0);
                } else {
                    action.setEnabled(DefaultLogPage.this.textArea.getDocument().getLength() > 0);
                }
                return true;
            }
            if (cmdId == 18) {
                boolean enableAction = false;
                if (DefaultLogPage.this.usingTree()) {
                    TreePath path = DefaultLogPage.this.tree.getSelectionPath();
                    enableAction = path != null && path.getLastPathComponent() != null;
                } else if (DefaultLogPage.this.textArea.getSelectedText() != null) {
                    enableAction = true;
                }
                action.setEnabled(enableAction);
                return true;
            }
            if (cmdId == FIX_SOURCE_CMD_ID) {
                boolean enabled = false;
                DefaultMutableTreeNode tn = DefaultLogPage.this.getSelectedTreeNode();
                if (tn != null) {
                    enabled = !tn.isLeaf() ? false : DefaultLogPage.this.canFixObject(tn);
                }
                action.setEnabled(enabled);
                return true;
            }
            if (cmdId == GOTO_SOURCE_CMD_ID) {
                boolean enabled = false;
                DefaultMutableTreeNode tn = DefaultLogPage.this.getSelectedTreeNode();
                if (tn != null) {
                    enabled = tn.isLeaf();
                }
                action.setEnabled(enabled);
                return true;
            }
            return false;
        }
    }

    private final class DefaultModelBuilder
    implements Runnable {
        Collection message;

        DefaultModelBuilder(Collection message) {
            this.message = message;
        }

        @Override
        public void run() {
            if (this.message == null) {
                DefaultLogPage.this.tree.setModel(null);
                return;
            }
            DefaultMutableTreeNode root = new DefaultMutableTreeNode();
            DefaultTreeModel model = new DefaultTreeModel(root);
            Iterator iter = this.message.iterator();
            while (iter.hasNext()) {
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(iter.next());
                root.add(node);
            }
            DefaultLogPage.this.tree.setModel(model);
            for (int i = DefaultLogPage.this.tree.getRowCount() - 1; i >= 0; --i) {
                DefaultLogPage.this.tree.expandRow(i);
            }
        }
    }
}

