/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Set;
import javax.swing.KeyStroke;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.keyboard.KeyStroke2String;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.keyboard.MyNodeIterator;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

final class XMLKeystrokeContextDef {
    private Element _def;
    private static final String KPRESET = "preset";
    private static final String KPRESET_NAME = "name";
    private static final String KCONTEXT = "context";
    private static final String KCONTEXT_NAME = "name";
    private static final String KMAP = "map";
    private static final String KMAP_ACTION = "action";
    private static final String KMAP_SCOPE = "scope";
    private static final String KMAP_SCOPE_GLOBAL = "global";
    private static final String KACCEL = "accel";

    private XMLKeystrokeContextDef() {
    }

    final void addAllPresets(List list) {
        MyNodeIterator i = new MyNodeIterator(this._def, KPRESET);
        while (i.hasNext()) {
            Element item = i.nextElement();
            String s = item.getAttribute("name");
            if (s.length() == 0) continue;
            list.add(s);
        }
    }

    final void addAllActions(Set set, String sContext, boolean bGlobal) {
        MyNodeIterator iPreset = new MyNodeIterator();
        MyNodeIterator iContext = new MyNodeIterator();
        MyNodeIterator iMap = new MyNodeIterator();
        iPreset.set(this._def, KPRESET);
        while (iPreset.hasNext()) {
            Element preset = iPreset.nextElement();
            iContext.set(preset, KCONTEXT);
            while (iContext.hasNext()) {
                Element context = iContext.nextElement();
                String s = context.getAttribute("name");
                if (!s.equalsIgnoreCase(sContext)) continue;
                iMap.set(context, KMAP);
                while (iMap.hasNext()) {
                    IdeAction action;
                    String sAction;
                    Integer cmdID;
                    Element map = iMap.nextElement();
                    String sScope = map.getAttribute(KMAP_SCOPE);
                    if (sScope.equalsIgnoreCase(KMAP_SCOPE_GLOBAL) != bGlobal || (cmdID = Ide.findCmdID(sAction = map.getAttribute(KMAP_ACTION))) == null || (action = IdeAction.find(cmdID)) == null) continue;
                    set.add(action);
                }
            }
        }
    }

    final void addPresetKeyStrokeMap(KeyStrokeMap ksm, String sContext, String sPresetName, boolean bGlobal) {
        MyNodeIterator iPreset = new MyNodeIterator();
        MyNodeIterator iContext = new MyNodeIterator();
        MyNodeIterator iMap = new MyNodeIterator();
        MyNodeIterator iKS = new MyNodeIterator();
        iPreset.set(this._def, KPRESET);
        while (iPreset.hasNext()) {
            Element ePreset = iPreset.nextElement();
            String sName = ePreset.getAttribute("name");
            if (!sName.equalsIgnoreCase(sPresetName)) continue;
            iContext.set(ePreset, KCONTEXT);
            while (iContext.hasNext()) {
                Element eContext = iContext.nextElement();
                String sContextName = eContext.getAttribute("name");
                if (!sContextName.equalsIgnoreCase(sContext)) continue;
                iMap.set(eContext, KMAP);
                while (iMap.hasNext()) {
                    String sAction;
                    Integer cmdID;
                    Element eMap = iMap.nextElement();
                    String sScope = eMap.getAttribute(KMAP_SCOPE);
                    if (sScope.equalsIgnoreCase(KMAP_SCOPE_GLOBAL) != bGlobal || (cmdID = Ide.findCmdID(sAction = eMap.getAttribute(KMAP_ACTION))) == null) continue;
                    KeyStrokes kss = null;
                    iKS.set(eMap, KACCEL);
                    while (iKS.hasNext()) {
                        String sKS;
                        Element eKS = iKS.nextElement();
                        Node n = eKS.getFirstChild();
                        if (n == null || (sKS = n.getNodeValue()) == null || sKS.length() == 0) continue;
                        KeyStroke ks = KeyStroke2String.fromString(sKS);
                        if (kss == null) {
                            kss = new KeyStrokes();
                        }
                        kss.add(ks);
                    }
                    if (kss == null) continue;
                    ksm.put(kss, cmdID);
                }
            }
        }
    }

    static XMLKeystrokeContextDef load(String filename) {
        XMLKeystrokeContextDef ret = null;
        File f = new File(filename);
        try {
            FileInputStream is = new FileInputStream(f);
            XMLKeystrokeContextDef xmlKeystrokeContextDef = new XMLKeystrokeContextDef();
            if (xmlKeystrokeContextDef.load(is)) {
                ret = xmlKeystrokeContextDef;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    static XMLKeystrokeContextDef load(ClassLoader classLoader, String filename) {
        XMLKeystrokeContextDef xmlKeystrokeContextDef;
        XMLKeystrokeContextDef ret = null;
        InputStream inputStream = classLoader.getResourceAsStream(filename);
        if (inputStream != null && (xmlKeystrokeContextDef = new XMLKeystrokeContextDef()).load(inputStream)) {
            ret = xmlKeystrokeContextDef;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean load(InputStream is) {
        boolean ret = false;
        try {
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            DOMParser domParser = new DOMParser();
            domParser.setPreserveWhitespace(false);
            domParser.setDoctype(new DTD());
            try {
                domParser.parse((Reader)br);
                br.close();
                XMLDocument xdoc = domParser.getDocument();
                this._def = xdoc.getDocumentElement();
                ret = true;
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }
}

