/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.plaf.TabbedPaneUI;
import oracle.ide.controls.SingleRowTabbedPaneUI;

public class SingleRowTabbedPane
extends JTabbedPane {
    public static final String SCROLL_MENU_SORT_PROPERTY = "scrollMenuSorted";
    public static final String SCROLL_MENU_SHOW_VISIBLE_PROPERTY = "scrollMenuShowVisible";
    private static final String uiClassID = "SingleRowTabbedPaneUI";
    private static final int MAX_HOTKEYS = 9;
    protected int[] hotkeys = new int[9];
    protected boolean swapping;

    public SingleRowTabbedPane() {
        this.setOpaque(true);
        for (int i = 0; i < this.hotkeys.length; ++i) {
            this.hotkeys[i] = -1;
        }
    }

    public SingleRowTabbedPane(int tabPlacement) {
        super(tabPlacement);
    }

    public void showScrollMenu() {
        TabbedPaneUI ui = this.getUI();
        if (ui instanceof SingleRowTabbedPaneUI) {
            ((SingleRowTabbedPaneUI)ui).showScrollMenu();
        }
    }

    public boolean isScrollMenuSorted() {
        TabbedPaneUI ui = this.getUI();
        if (ui instanceof SingleRowTabbedPaneUI) {
            return ((SingleRowTabbedPaneUI)ui).isScrollMenuSorted();
        }
        return false;
    }

    public void setScrollMenuSorted(boolean sorted) {
        TabbedPaneUI ui = this.getUI();
        if (ui instanceof SingleRowTabbedPaneUI) {
            ((SingleRowTabbedPaneUI)ui).setScrollMenuSorted(sorted);
        }
    }

    public void setHotkeyAt(int index, int hotkey) {
        int i;
        if (index < 0 || index >= this.getTabCount() || hotkey < 1 || hotkey > 9) {
            throw new IllegalArgumentException();
        }
        --hotkey;
        int currentHotkey = -1;
        int toIndex = -1;
        for (i = 0; i < this.hotkeys.length; ++i) {
            int keyIndex = this.hotkeys[i];
            if (keyIndex == -1) {
                if (hotkey != i || toIndex != -1) continue;
                toIndex = i;
                continue;
            }
            if (keyIndex == index) {
                if (hotkey == i) {
                    return;
                }
                currentHotkey = i;
                if (i > hotkey) continue;
                toIndex = index;
                continue;
            }
            if (keyIndex < index) {
                if (i < hotkey) {
                    toIndex = keyIndex + 1;
                    continue;
                }
                if (i != hotkey) continue;
                toIndex = keyIndex;
                continue;
            }
            if (i > hotkey) continue;
            toIndex = keyIndex;
        }
        if (toIndex == -1) {
            toIndex = this.getTabCount() - 1;
        }
        if (index == toIndex) {
            if (currentHotkey != -1) {
                this.hotkeys[currentHotkey] = -1;
            }
            this.hotkeys[hotkey] = index;
            this.repaint();
            return;
        }
        if (this.hotkeys[hotkey] == -1) {
            this.moveTab(index, toIndex);
        } else {
            this.swapTabs(index, toIndex);
        }
        for (i = 0; i < this.hotkeys.length; ++i) {
            if (this.hotkeys[i] != toIndex) continue;
            this.hotkeys[i] = -1;
        }
        this.hotkeys[hotkey] = toIndex;
        this.repaint();
    }

    public int getHotkeyAt(int index) {
        if (index < 0 || index >= this.getTabCount()) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.hotkeys.length; ++i) {
            if (this.hotkeys[i] != index) continue;
            return i + 1;
        }
        return -1;
    }

    public int getIndexOfHotkey(int hotkey) {
        if (hotkey < 1 || hotkey > 9) {
            throw new IllegalArgumentException();
        }
        return this.hotkeys[hotkey - 1];
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        this.setUI((TabbedPaneUI)UIManager.getUI(this));
    }

    @Override
    public void setTabPlacement(int tabPlacement) {
        if (tabPlacement != 1) {
            throw new UnsupportedOperationException();
        }
        super.setTabPlacement(tabPlacement);
    }

    @Override
    public void addImpl(Component component, Object constraints, int index) {
        if (component instanceof JComponent) {
            ((JComponent)component).setBorder(null);
        }
        super.addImpl(component, constraints, index);
    }

    @Override
    public void insertTab(String title, Icon icon, Component component, String tip, int index) {
        int i;
        super.insertTab(title, icon, component, tip, index);
        if (this.swapping) {
            return;
        }
        int lowerBound = -1;
        int upperBound = -1;
        int freeIndex = -1;
        for (i = 0; i < this.hotkeys.length; ++i) {
            int keyIndex = this.hotkeys[i];
            if (keyIndex == -1) {
                if (freeIndex != -1 && freeIndex >= lowerBound) continue;
                freeIndex = i;
                continue;
            }
            if (keyIndex < index) {
                lowerBound = i;
                continue;
            }
            if (upperBound != -1) continue;
            upperBound = i;
        }
        if (freeIndex == -1) {
            return;
        }
        if (upperBound == -1) {
            this.hotkeys[lowerBound + 1] = index;
            return;
        }
        if (lowerBound != -1 && freeIndex < lowerBound) {
            for (i = freeIndex; i < lowerBound; ++i) {
                this.hotkeys[i] = this.hotkeys[i + 1];
            }
            this.hotkeys[lowerBound] = index;
        } else if (freeIndex > upperBound) {
            for (i = freeIndex; i > upperBound; --i) {
                this.hotkeys[i] = this.hotkeys[i - 1] + 1;
            }
            this.hotkeys[upperBound] = index;
            upperBound = freeIndex + 1;
        } else {
            this.hotkeys[freeIndex] = index;
        }
        for (i = upperBound; i < this.hotkeys.length; ++i) {
            if (this.hotkeys[i] == -1) continue;
            int n = i;
            this.hotkeys[n] = this.hotkeys[n] + 1;
        }
    }

    @Override
    public void removeTabAt(int index) {
        super.removeTabAt(index);
        if (this.swapping) {
            return;
        }
        for (int i = 0; i < this.hotkeys.length; ++i) {
            if (this.hotkeys[i] == index) {
                this.hotkeys[i] = -1;
                continue;
            }
            if (this.hotkeys[i] <= index) continue;
            int n = i;
            this.hotkeys[n] = this.hotkeys[n] - 1;
        }
    }

    @Override
    public void removeAll() {
        super.removeAll();
        for (int i = 0; i < this.hotkeys.length; ++i) {
            this.hotkeys[i] = -1;
        }
    }

    protected void moveTab(int fromIndex, int toIndex) {
        int tabCount = this.getTabCount();
        if (fromIndex < 0 || fromIndex >= tabCount || toIndex < 0 || toIndex >= tabCount) {
            throw new IllegalArgumentException();
        }
        if (fromIndex == toIndex) {
            return;
        }
        String fromTitle = this.getTitleAt(fromIndex);
        Icon fromIcon = this.getIconAt(fromIndex);
        Component fromComponent = this.getComponentAt(fromIndex);
        String fromTip = this.getToolTipTextAt(fromIndex);
        this.removeTabAt(fromIndex);
        this.insertTab(fromTitle, fromIcon, fromComponent, fromTip, toIndex);
        this.setSelectedComponent(fromComponent);
        fromComponent.setVisible(true);
    }

    protected void swapTabs(int fromIndex, int toIndex) {
        int tabCount = this.getTabCount();
        if (fromIndex < 0 || fromIndex >= tabCount || toIndex < 0 || toIndex >= tabCount) {
            throw new IllegalArgumentException();
        }
        if (fromIndex == toIndex) {
            return;
        }
        String fromTitle = this.getTitleAt(fromIndex);
        Icon fromIcon = this.getIconAt(fromIndex);
        Component fromComponent = this.getComponentAt(fromIndex);
        String fromTip = this.getToolTipTextAt(fromIndex);
        String toTitle = this.getTitleAt(toIndex);
        Icon toIcon = this.getIconAt(toIndex);
        Component toComponent = this.getComponentAt(toIndex);
        String toTip = this.getToolTipTextAt(toIndex);
        this.swapping = true;
        this.removeTabAt(Math.max(fromIndex, toIndex));
        this.removeTabAt(Math.min(fromIndex, toIndex));
        this.insertTab(toTitle, toIcon, toComponent, toTip, toIndex > fromIndex ? fromIndex : fromIndex - 1);
        this.insertTab(fromTitle, fromIcon, fromComponent, fromTip, toIndex);
        this.swapping = false;
        this.setSelectedComponent(fromComponent);
        fromComponent.setVisible(true);
    }
}

