/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import oracle.ide.Ide;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokes;

public final class JTextComponentUndoSupport {
    private static final String UNDO_ACTION_NAME = "undo";
    private static final String REDO_ACTION_NAME = "redo";
    private final UndoSupport m_UndoSupport = new UndoSupport();
    private final UndoManager m_UndoManager = new UndoManager();
    private final UndoAction m_UndoAction = new UndoAction();
    private final RedoAction m_RedoAction = new RedoAction();
    private CompoundEdit m_combinedEdit;

    public JTextComponentUndoSupport(JTextComponent textComponent) {
        textComponent.getDocument().addUndoableEditListener(this.m_UndoSupport);
        this.bindUndoRedo(textComponent);
        this.adjustActions();
    }

    public void clearUndo() {
        this.m_UndoManager.discardAllEdits();
        this.adjustActions();
    }

    public void startCombiningEdits() {
        if (this.m_combinedEdit != null) {
            this.m_combinedEdit = new CompoundEdit();
        }
    }

    public void commitCombinedEdit() {
        if (this.m_combinedEdit != null) {
            this.m_combinedEdit.end();
            this.m_UndoManager.addEdit(this.m_combinedEdit);
            this.m_combinedEdit = null;
        }
        this.adjustActions();
    }

    private void getBindings(KeyStrokeMap keyStrokeMap, int cmdID, String actionName, ArrayList bindings) {
        List<KeyStrokes> list = keyStrokeMap.getKeyStrokesFor(cmdID);
        if (!list.isEmpty()) {
            for (KeyStrokes kss : list) {
                KeyStroke accelerator;
                if (kss.getLength() != 1 || (accelerator = kss.getKeyStroke(0)) == null) continue;
                bindings.add(new JTextComponent.KeyBinding(accelerator, actionName));
            }
        }
    }

    private void bindUndoRedo(JTextComponent textComponent) {
        ArrayList bindings = new ArrayList();
        KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
        KeyStrokeMap keyStrokeMap = keyStrokeOptions.getGlobalKeyMap();
        this.getBindings(keyStrokeMap, 5, UNDO_ACTION_NAME, bindings);
        this.getBindings(keyStrokeMap, 6, REDO_ACTION_NAME, bindings);
        JTextComponent.loadKeymap(textComponent.getKeymap(), bindings.toArray(new JTextComponent.KeyBinding[bindings.size()]), new Action[]{this.m_UndoAction, this.m_RedoAction});
    }

    private void adjustActions() {
        this.m_UndoAction.setEnabled(this.m_UndoManager.canUndo());
        this.m_RedoAction.setEnabled(this.m_UndoManager.canRedo());
    }

    private final class UndoSupport
    implements UndoableEditListener {
        private UndoSupport() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            UndoableEdit ue = e.getEdit();
            boolean combinedIt = false;
            if (JTextComponentUndoSupport.this.m_combinedEdit != null) {
                if (JTextComponentUndoSupport.this.m_combinedEdit.addEdit(ue)) {
                    combinedIt = true;
                } else {
                    JTextComponentUndoSupport.this.commitCombinedEdit();
                    JTextComponentUndoSupport.this.startCombiningEdits();
                }
            }
            if (!combinedIt) {
                JTextComponentUndoSupport.this.m_UndoManager.addEdit(ue);
                JTextComponentUndoSupport.this.adjustActions();
            }
        }
    }

    private final class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super(JTextComponentUndoSupport.UNDO_ACTION_NAME);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponentUndoSupport.this.m_UndoManager.undo();
            JTextComponentUndoSupport.this.adjustActions();
        }
    }

    private final class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super(JTextComponentUndoSupport.REDO_ACTION_NAME);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponentUndoSupport.this.m_UndoManager.redo();
            JTextComponentUndoSupport.this.adjustActions();
        }
    }
}

