/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public final class Animator {
    private Animator() {
    }

    private static double[] getAdvanceSteps(int steps, double center, Gauss gauss) {
        int i;
        double[] advances = new double[steps];
        double sum = 0.0;
        for (i = 0; i < steps; ++i) {
            double value = (double)i / (double)steps - 0.5 + center;
            double advance = gauss.computeModifier(value);
            sum += advance;
            advances[i] = advance;
        }
        i = 0;
        while (i < advances.length) {
            int n = i++;
            advances[n] = advances[n] * (1.0 / sum);
        }
        return advances;
    }

    private static double[] animate(int steps, double center, Gauss gauss) {
        double[] advances = Animator.getAdvanceSteps(steps, center, gauss);
        double[] ret = new double[steps];
        double xPos = 0.0;
        for (int i = 0; i < advances.length; ++i) {
            double advance = advances[i];
            ret[i] = xPos += advance;
        }
        return ret;
    }

    public static int getInt(double currentValue, int from, int to) {
        return (int)Math.round((double)from + (double)(to - from) * currentValue);
    }

    public static Point getPoint(double currentValue, Point ptFrom, Point ptTo) {
        int deltaX = ptTo.x - ptFrom.x;
        int deltaY = ptTo.y - ptFrom.y;
        return new Point((int)Math.round((double)ptFrom.x + (double)deltaX * currentValue), (int)Math.round((double)ptFrom.y + (double)deltaY * currentValue));
    }

    public static Rectangle getRectangle(double currentValue, Rectangle rcFrom, Rectangle rcTo) {
        int deltaX = rcTo.x - rcFrom.x;
        int deltaY = rcTo.y - rcFrom.y;
        int deltaW = rcTo.width - rcFrom.width;
        int deltaH = rcTo.height - rcFrom.height;
        return new Rectangle((int)Math.round((double)rcFrom.x + (double)deltaX * currentValue), (int)Math.round((double)rcFrom.y + (double)deltaY * currentValue), (int)Math.round((double)rcFrom.width + (double)deltaW * currentValue), (int)Math.round((double)rcFrom.height + (double)deltaH * currentValue));
    }

    public static void animate(int stepTime, long maxTime, PropertyChangeListener listener) {
        Animator.animate(stepTime, maxTime, 10, 0.6f, 0.14f, listener);
    }

    public static void animate(int stepTime, long maxTime, int steps, double center, double sigma, PropertyChangeListener listener) {
        Gauss gauss = new Gauss();
        gauss.setSigma(sigma);
        long t0 = System.currentTimeMillis();
        double[] ratios = Animator.animate(steps, center, gauss);
        long tPerStep = maxTime / (long)ratios.length;
        Double oldValue = 0.0;
        for (int i = 0; i < ratios.length; ++i) {
            long t1 = System.currentTimeMillis();
            long tSpent = t1 - t0;
            if (i + 1 != ratios.length && tSpent >= (long)(i + 1) * tPerStep) continue;
            double newValue = ratios[i];
            PropertyChangeEvent event = new PropertyChangeEvent(Animator.class, "tick", oldValue, newValue);
            listener.propertyChange(event);
            oldValue = newValue;
            try {
                Thread.sleep(stepTime);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    static class Gauss {
        private double sigma;
        private double rho;
        private double exp_multiplier;
        private double exp_member;

        public Gauss() {
            this.setSigma(1.0);
        }

        public void setSigma(double sigma) {
            this.sigma = sigma;
            this.rho = 1.0;
            this.computeEquationParts();
            this.rho = this.computeModifierUnprotected(0.0);
            this.computeEquationParts();
        }

        private void computeEquationParts() {
            this.exp_multiplier = Math.sqrt(Math.PI * 2) / this.sigma / this.rho;
            this.exp_member = 4.0 * this.sigma * this.sigma;
        }

        public double computeModifier(double x) {
            double result = this.computeModifierUnprotected(x);
            if (result > 1.0) {
                result = 1.0;
            } else if (result < 0.0) {
                result = 0.0;
            }
            return result;
        }

        private double computeModifierUnprotected(double x) {
            return this.exp_multiplier * Math.exp(-x * x / this.exp_member);
        }
    }
}

