/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.xml.gui.swing.SwingXmlContext;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.util.CollectionUtils;

public final class UIUtils {
    public static final int PROMPT_SPACE = 12;
    public static final int ROW_SPACE = 5;
    public static final int POPUP_LEAD_SPACE = 3;

    public static Frame getParentFrame(XmlContext context) {
        Frame f;
        SwingXmlContext sxc;
        Component c;
        if (context instanceof SwingXmlContext && (c = (sxc = (SwingXmlContext)context).getRootDocumentUIComponent()) != null && (f = WindowUtils.parentFrame((Component)c)) != null) {
            return f;
        }
        return new JFrame();
    }

    public static void initializeJTable(JTable table) {
        if (table != null) {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
            table.getInputMap(1).put(keyStroke, "cancel");
            table.getActionMap().put("cancel", new EditingAction(table, false));
            keyStroke = KeyStroke.getKeyStroke(10, 0);
            table.getInputMap(1).put(keyStroke, "commit");
            table.getActionMap().put("commit", new EditingAction(table, true));
            keyStroke = KeyStroke.getKeyStroke(86, 2);
            table.getInputMap(1).put(keyStroke, "paste");
            table.getActionMap().put("paste", DummyAction.getInstance());
        }
    }

    public static void diposeJTable(JTable table) {
        if (table != null) {
            EditingAction a;
            ActionMap map = table.getActionMap();
            if (map.get("cancel") instanceof EditingAction) {
                a = (EditingAction)map.get("cancel");
                a.dispose();
                map.remove("cancel");
            }
            if (map.get("commit") instanceof EditingAction) {
                a = (EditingAction)map.get("commit");
                a.dispose();
                map.remove("commit");
            }
        }
    }

    public static Container createLabelFieldContainer() {
        return UIUtils.createLabelFieldPanel();
    }

    public static JPanel createLabelFieldPanel() {
        return new JPanel(new LabelFieldLayout());
    }

    public static JMenuItem createMenuItem(Action action) {
        return new JMenuItem(action);
    }

    public static List<Component> asComponentList(List<?> items) {
        List<Component> mutable = !CollectionUtils.isUnmodifiableList(items, (int)0) ? items : new ArrayList(items);
        ListIterator<?> itor = mutable.listIterator();
        while (itor.hasNext()) {
            Object next = itor.next();
            if (next instanceof Component) continue;
            if (next instanceof Action) {
                itor.set(UIUtils.createMenuItem((Action)next));
                continue;
            }
            itor.remove();
        }
        return mutable;
    }

    public static void setupListDoubleClickListener(final JList list, final JEWTDialog dialog) {
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index;
                if (e.getClickCount() == 2 && (index = list.locationToIndex(e.getPoint())) != -1) {
                    list.setSelectedIndex(index);
                    dialog.setVisible(false);
                }
            }
        };
        list.addMouseListener(mouseListener);
    }

    private UIUtils() {
    }

    private static class EditingAction
    extends AbstractAction {
        private JTable _table;
        private boolean _commit;

        public EditingAction(JTable table, boolean commit) {
            this._table = table;
            this._commit = commit;
        }

        public void dispose() {
            this._table = null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this._commit) {
                if (this._table.getCellEditor() != null) {
                    this._table.getCellEditor().stopCellEditing();
                }
            } else {
                this._table.removeEditor();
            }
        }

        @Override
        public boolean isEnabled() {
            return this._table.getEditorComponent() != null;
        }
    }

    private static class DummyAction
    extends AbstractAction {
        private static Action _instance;

        private DummyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
        }

        public static Action getInstance() {
            if (_instance == null) {
                _instance = new DummyAction();
            }
            return _instance;
        }

        @Override
        public boolean isEnabled() {
            return false;
        }
    }

    private static class LabelFieldLayout
    implements LayoutManager2 {
        private LabelFieldLayout() {
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public void invalidateLayout(Container target) {
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.5f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.5f;
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            return this._computeSize(target, true);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this._computeSize(parent, true);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this._computeSize(parent, false);
        }

        @Override
        public void layoutContainer(Container parent) {
            Dimension size = parent.getSize();
            Insets insets = parent.getInsets();
            int x = insets.left;
            int y = insets.top;
            size.width -= insets.left + insets.right;
            size.height -= insets.top + insets.bottom;
            int maxPromptWidth = 0;
            int count = parent.getComponentCount();
            for (int i = 0; i < count; i += 2) {
                Component label = parent.getComponent(i);
                Dimension labelSize = label.getPreferredSize();
                if (labelSize.width <= maxPromptWidth) continue;
                maxPromptWidth = labelSize.width;
            }
            int fieldWidth = size.width - (maxPromptWidth + 12 + x);
            for (int i = 0; i < count; i += 2) {
                Dimension fieldSize;
                Component field;
                Component label = parent.getComponent(i);
                Dimension labelSize = label.getPreferredSize();
                if (i + 1 < count) {
                    field = parent.getComponent(i + 1);
                    fieldSize = field.getPreferredSize();
                } else {
                    field = null;
                    fieldSize = new Dimension(0, 0);
                }
                int labelY = y;
                if (fieldSize.height > labelSize.height) {
                    labelY = y + (fieldSize.height - labelSize.height) / 2;
                }
                label.setBounds(x, labelY, maxPromptWidth, labelSize.height);
                x += maxPromptWidth + 12;
                if (field != null) {
                    int fieldY = y;
                    if (labelSize.height > fieldSize.height) {
                        fieldY = y + (labelSize.height - fieldSize.height) / 2;
                    }
                    field.setBounds(x, fieldY, fieldWidth, fieldSize.height);
                }
                x = insets.left;
                y += Math.max(fieldSize.height, labelSize.height) + 5;
            }
        }

        private Dimension _computeSize(Container parent, boolean preferred) {
            int maxPromptWidth = 0;
            int maxFieldWidth = 0;
            int height = 0;
            int count = parent.getComponentCount();
            for (int i = 0; i < count; i += 2) {
                Dimension fieldSize;
                Dimension labelSize;
                Component label = parent.getComponent(i);
                Dimension dimension = labelSize = preferred ? label.getPreferredSize() : label.getMinimumSize();
                if (labelSize.width > maxPromptWidth) {
                    maxPromptWidth = labelSize.width;
                }
                if (i + 1 < count) {
                    Component field = parent.getComponent(i + 1);
                    fieldSize = preferred ? field.getPreferredSize() : field.getMinimumSize();
                } else {
                    fieldSize = new Dimension(0, 0);
                }
                if (fieldSize.width > maxFieldWidth) {
                    maxFieldWidth = fieldSize.width;
                }
                height += Math.max(labelSize.height, fieldSize.height);
            }
            height += (count / 2 - 1) * 5;
            int width = maxFieldWidth + maxPromptWidth + 12;
            Insets i = parent.getInsets();
            if (i != null) {
                width += i.left + i.right;
                height += i.top + i.bottom;
            }
            return new Dimension(width, height);
        }
    }

    public static class NsChangeListener
    implements ItemListener {
        private JList _list;
        private Map _creationActionMap;
        private Map _nsDisplayNameMap;

        public NsChangeListener(Map creationActionMap, Map nsDisplayNameMap, JList list) {
            this._creationActionMap = creationActionMap;
            this._nsDisplayNameMap = nsDisplayNameMap;
            this._list = list;
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            if (event.getStateChange() == 1) {
                Collection actionsForNs;
                this._list.removeAll();
                String nsDisplayName = (String)event.getItem();
                String ns = (String)this._nsDisplayNameMap.get(nsDisplayName);
                if (ns != null && (actionsForNs = (Collection)this._creationActionMap.get(ns)) != null) {
                    this._list.setListData(actionsForNs.toArray());
                }
            }
        }
    }
}

