/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.operation;

import java.awt.datatransfer.DataFlavor;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.bali.xml.gui.swing.action.XmlKeyConvertible;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.datatransfer.XmlTransferUtils;
import oracle.bali.xml.model.datatransfer.operation.AbstractNodeTargetingOperation;
import oracle.bali.xml.share.TransactionToken;
import oracle.javatools.datatransfer.FetchMode;
import oracle.javatools.datatransfer.TransferDataInfo;
import org.w3c.dom.Node;

class ConvertOperation
extends AbstractNodeTargetingOperation {
    ConvertOperation() {
    }

    protected DataFlavor getRequiredDataFlavor() {
        return XmlTransferUtils.FLAVOR_XMLKEY;
    }

    protected boolean applyImpl(AbstractModel model, Node node, TransferDataInfo data, TransactionToken token) throws IOException, XmlCommitException {
        XmlKey key = (XmlKey)data.getData(FetchMode.STANDARD, false);
        XmlKeyConvertible convertible = new XmlKeyConvertible(model.getContext(), key);
        convertible.doConvert(node);
        return true;
    }

    protected List getApplicableNodesForDataImpl(AbstractModel model, List possibleNodes, TransferDataInfo data) {
        Iterator itor = possibleNodes.iterator();
        if (itor.hasNext()) {
            Node node = (Node)itor.next();
            return Collections.singletonList(node);
        }
        return Collections.EMPTY_LIST;
    }

    public String getDisplayName(AbstractModel model, TransferDataInfo info) {
        String infoDesc;
        String string = infoDesc = info == null ? null : (String)info.getMetadata(TransferDataInfo.METADATA_MEDIUM_DESCRIPTION);
        if (infoDesc == null) {
            return model.getTranslatedString("DragConvert");
        }
        return model.getTranslatedString("DragConvert_Data", infoDesc);
    }

    public float getSuitabilityRank() {
        return 0.45f;
    }

    public int getSupportedActions() {
        return 0;
    }
}

