/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.dnd;

import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.datatransfer.operation.Operation;
import oracle.bali.xml.model.datatransfer.operation.OperationProcessor;
import oracle.bali.xml.share.ActionProxy;
import oracle.bali.xml.share.GroupingAction;

class DropMenuInvoker
implements PopupMenuListener,
Runnable {
    private boolean _needsCleanup = true;
    private final DropTargetDropEvent _event;
    private final AbstractModel _model;
    private final OperationProcessor _processor;
    private final Runnable _cleanupTask;
    private final JPopupMenu _mainMenu = new JPopupMenu();
    private static final String _DROP_CANCEL_ACTION_KEY = "DropCancelAction";
    private static final int _POPUP_OFFSET_X = 3;
    private static final int _POPUP_OFFSET_Y = 3;
    private static final Object _UNSET = new Object();

    DropMenuInvoker(DropTargetDropEvent event, AbstractModel model, OperationProcessor processor, Runnable cleanupTask) {
        this._event = event;
        this._model = model;
        this._processor = processor;
        this._cleanupTask = cleanupTask;
    }

    public void invoke() {
        this._mainMenu.addPopupMenuListener(this);
        LinkedList<Action> actions = new LinkedList<Action>();
        boolean hadSubmenu = false;
        Iterator itor = this._processor.getSupportedOperations();
        while (itor.hasNext()) {
            List dataAndPositionsList;
            Operation operation = (Operation)itor.next();
            Action opAction = operation.createAsAction(this._model, dataAndPositionsList = this._processor.getListOfDataAndPositions(operation));
            if (opAction == null) continue;
            actions.add(opAction);
            if (!(opAction instanceof GroupingAction)) continue;
            hadSubmenu = true;
        }
        if (hadSubmenu && actions.size() <= 2) {
            Iterator actionItor = actions.iterator();
            while (actionItor.hasNext()) {
                Action action = (Action)actionItor.next();
                if (action instanceof GroupingAction) {
                    JLabel label = new JLabel(String.valueOf(action.getValue("Name")));
                    this._mainMenu.add(label);
                    Iterator children = ((GroupingAction)action).getChildIterator();
                    while (children.hasNext()) {
                        this._addToMenu(this._mainMenu, (Action)children.next(), _UNSET);
                    }
                } else {
                    this._addToMenu(this._mainMenu, action, _UNSET);
                }
                if (!actionItor.hasNext()) continue;
                this._mainMenu.addSeparator();
            }
        } else {
            Object lastGroup = _UNSET;
            for (Action action : actions) {
                lastGroup = this._addToMenu(this._mainMenu, action, lastGroup);
            }
        }
        this._mainMenu.addSeparator();
        this._mainMenu.add(new CancelAction());
        this._mainMenu.show(this._event.getDropTargetContext().getComponent(), this._event.getLocation().x + 3, this._event.getLocation().y + 3);
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
        this._detachAndClean(e);
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        if (e.getSource() == this._mainMenu) {
            this._detachAndClean(e);
        }
    }

    private void _detachAndClean(PopupMenuEvent e) {
        ((JPopupMenu)e.getSource()).removePopupMenuListener(this);
        this._cleanupIfNeeded();
    }

    @Override
    public void run() {
        this._cleanupIfNeeded();
    }

    private Object _addToMenu(JPopupMenu menu, Action action, Object lastGroup) {
        Object curGroup = GroupingAction.getGroupIdentifier((Action)action);
        if (lastGroup != _UNSET && curGroup != lastGroup) {
            menu.addSeparator();
        }
        if (action instanceof GroupingAction) {
            GroupingAction grouping = (GroupingAction)action;
            String menuName = (String)grouping.getValue("Name");
            JMenu submenu = new JMenu(menuName);
            submenu.getPopupMenu().addPopupMenuListener(this);
            Object index = action.getValue("SwingDisplayedMnemonicIndexKey");
            if (index != null) {
                this._setMnemonic(submenu, menuName, index);
                submenu.setDisplayedMnemonicIndex((Integer)index);
            }
            Object submenuLastGroup = _UNSET;
            Iterator itor = grouping.getChildIterator();
            while (itor.hasNext()) {
                Action next = (Action)itor.next();
                submenuLastGroup = this._addToMenu(submenu.getPopupMenu(), next, submenuLastGroup);
            }
            menu.add(submenu);
        } else {
            Object index = action.getValue("SwingDisplayedMnemonicIndexKey");
            action = new CleanupProxy((Action)action);
            JMenuItem newItem = menu.add((Action)action);
            if (index != null) {
                String actionName = (String)action.getValue("Name");
                this._setMnemonic(newItem, actionName, index);
                newItem.setDisplayedMnemonicIndex((Integer)index);
            }
        }
        return curGroup;
    }

    private void _setMnemonic(AbstractButton action, String actionName, Object index) {
        Integer idx;
        if (index instanceof Integer && (idx = (Integer)index) != -1 && idx < actionName.length()) {
            action.setMnemonic(actionName.charAt(idx));
        }
    }

    private void _cleanupIfNeeded() {
        if (this._needsCleanup) {
            this._needsCleanup = false;
            this._cleanupTask.run();
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super(DropMenuInvoker.this._model.getTranslatedString(DropMenuInvoker._DROP_CANCEL_ACTION_KEY));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DropMenuInvoker.this._cleanupIfNeeded();
        }
    }

    private class CleanupProxy
    extends ActionProxy {
        private final Action _base;

        public CleanupProxy(Action base) {
            this._base = base;
        }

        protected Action getBaseAction() {
            return this._base;
        }

        public void actionPerformed(final ActionEvent e) {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CleanupProxy.super.actionPerformed(e);
                    }
                });
            }
            finally {
                DropMenuInvoker.this._cleanupIfNeeded();
            }
        }
    }
}

