/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensekey;

import com.itextpdf.licensekey.LicenseKeyProductFeature;
import com.itextpdf.licensekey.util.DateUtil;
import com.itextpdf.licensekey.util.DateWorker;

public class LicenseKeyProduct {
    private String productName;
    private String majorVersion;
    private String minorVersion;
    private String type;
    private String deploymentType;
    private String expire;
    private String platform;
    private LicenseKeyProductFeature[] productFeatures;
    private static DateWorker dateWorker = new DateWorker("yyyy-MM-dd");

    public LicenseKeyProduct(String productName, String majorVersion, String minorVersion, String type, String deploymentType, String expire, String platform, LicenseKeyProductFeature[] productFeatures) {
        this.productName = productName;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.type = type;
        this.deploymentType = deploymentType;
        this.expire = expire;
        this.platform = platform;
        this.productFeatures = productFeatures;
    }

    public LicenseKeyProduct(String productName, String majorVersion, String type, String deploymentType, String expire, String platform, LicenseKeyProductFeature[] productFeatures) {
        this(productName, majorVersion, "", type, deploymentType, expire, platform, productFeatures);
    }

    public LicenseKeyProduct(String productName, String majorVersion, String minorVersion, LicenseKeyProductFeature[] productFeatures) {
        this(productName, majorVersion, minorVersion, "", "", dateWorker.format(DateUtil.getCurrent()), "java", productFeatures);
    }

    public LicenseKeyProduct(String productName, String majorVersion, String minorVersion, String type, LicenseKeyProductFeature[] productFeatures) {
        this(productName, majorVersion, minorVersion, type, "", dateWorker.format(DateUtil.getCurrent()), "java", productFeatures);
    }

    public LicenseKeyProduct(String productName, String majorVersion, LicenseKeyProductFeature[] productFeatures) {
        this(productName, majorVersion, "", "", dateWorker.format(DateUtil.getCurrent()), "java", productFeatures);
    }

    @Deprecated
    public LicenseKeyProduct(String productName, int majorVersion, int minorVersion, String type, String deploymentType, String expire, String platform, LicenseKeyProductFeature[] productFeatures) {
        this(productName, String.valueOf(majorVersion), String.valueOf(minorVersion), type, deploymentType, expire, platform, productFeatures);
    }

    @Deprecated
    public LicenseKeyProduct(String productName, int majorVersion, String type, String deploymentType, String expire, String platform, LicenseKeyProductFeature[] productFeatures) {
        this(productName, String.valueOf(majorVersion), type, deploymentType, expire, platform, productFeatures);
    }

    @Deprecated
    public LicenseKeyProduct(String productName, int majorVersion, int minorVersion, LicenseKeyProductFeature[] productFeatures) {
        this(productName, String.valueOf(majorVersion), String.valueOf(minorVersion), productFeatures);
    }

    @Deprecated
    public LicenseKeyProduct(String productName, int majorVersion, int minorVersion, String type, LicenseKeyProductFeature[] productFeatures) {
        this(productName, String.valueOf(majorVersion), String.valueOf(minorVersion), type, productFeatures);
    }

    @Deprecated
    public LicenseKeyProduct(String productName, int majorVersion, LicenseKeyProductFeature[] productFeatures) {
        this(productName, String.valueOf(majorVersion), productFeatures);
    }

    public String getProductName() {
        return this.productName;
    }

    public String getMajor() {
        return this.majorVersion;
    }

    public int getMajorVersion() {
        return LicenseKeyProduct.parseInteger(this.majorVersion, 0);
    }

    public String getMinor() {
        return this.minorVersion;
    }

    public int getMinorVersion() {
        return LicenseKeyProduct.parseInteger(this.minorVersion, 0);
    }

    public String getType() {
        return this.type;
    }

    public String getExpireDate() {
        return this.expire;
    }

    public String getPlatform() {
        return this.platform;
    }

    public LicenseKeyProductFeature[] getProductFeatures() {
        return this.productFeatures;
    }

    public String getDeploymentType() {
        return this.deploymentType;
    }

    private static int parseInteger(String stringValue, int defaultValue) {
        if (stringValue.trim().length() != 0) {
            return Integer.parseInt(stringValue);
        }
        return defaultValue;
    }
}

