/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.painter;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Locale;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.TruncatingTextPainter;
import oracle.ewt.textWrapper.TextWrapper;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.ewt.textWrapper.WrappedText;
import oracle.ewt.util.StringUtils;

public class WrappingTextPainter
extends TruncatingTextPainter {
    private TextWrapper _wrapper;
    private WrappedText _wrappedText;

    public WrappingTextPainter() {
        this(WordWrapper.getTextWrapper());
    }

    public WrappingTextPainter(TextWrapper textWrapper) {
        this._wrapper = textWrapper;
    }

    @Override
    public Dimension getSize(PaintContext paintContext, int n, int n2) {
        String string;
        FontMetrics fontMetrics;
        int n3 = 0;
        int n4 = 0;
        Font font = paintContext.getPaintFont();
        if (font != null && (fontMetrics = paintContext.getFontMetrics(font)) != null && (string = this.getStringData(paintContext)) != null) {
            WrappedText wrappedText = this._getWrappedText(string, n, fontMetrics, paintContext.getPaintLocale());
            int n5 = wrappedText.getLineCount();
            n3 = n5 == 1 ? fontMetrics.stringWidth(StringUtils.getDisplayString(string, paintContext)) : n;
            n4 = n5 * fontMetrics.getHeight() - fontMetrics.getLeading();
        }
        return new Dimension(n3, n4);
    }

    @Override
    public void paint(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        String string = this.getStringData(paintContext);
        if (string == null) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        WrappedText wrappedText = this._getWrappedText(string, n3, fontMetrics, paintContext.getPaintLocale());
        int n6 = wrappedText.getLineCount();
        float f = this.getAlignmentX(paintContext);
        float f2 = this.getAlignmentY(paintContext);
        int n7 = n2 + n4 - 1;
        if (f2 != 0.0f && (n5 = n6 * fontMetrics.getHeight()) < n4) {
            n2 = (int)((float)n2 + (float)(n4 - n5) * f2);
        }
        n2 += fontMetrics.getAscent();
        n5 = fontMetrics.getHeight();
        for (int i = 0; i < n6; ++i) {
            String string2 = wrappedText.getLine(i);
            if (n2 + n5 > n7 && i < n6 - 1) {
                string2 = this.getPaintText(paintContext, string2 + wrappedText.getLine(i + 1), fontMetrics, n3);
            }
            this.paintText(paintContext, graphics, fontMetrics, string2, n, n2, n3, f, -1);
            if ((n2 += n5) > n7) break;
        }
    }

    private synchronized WrappedText _getWrappedText(String string, int n, FontMetrics fontMetrics, Locale locale) {
        WrappedText wrappedText = this._wrappedText;
        if (wrappedText == null || wrappedText.getWrapWidth() != n || wrappedText.getText() != string || wrappedText.getFontMetrics() != fontMetrics) {
            this._wrappedText = wrappedText = new WrappedText(string, this._wrapper, n, fontMetrics, locale, true);
        }
        return wrappedText;
    }
}

