/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwMenu.laf;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import oracle.ewt.event.tracking.MouseGrabProvider;
import oracle.ewt.event.tracking.TrackingUtils;
import oracle.ewt.lwAWT.lwMenu.LWMenu;
import oracle.ewt.lwAWT.lwMenu.LWMenuItem;
import oracle.ewt.lwAWT.lwMenu.MenuUtils;
import oracle.ewt.lwAWT.lwMenu.laf.MenuItemController;
import oracle.ewt.util.InputEventUtils;

public class VertMenuController
implements MenuItemController,
MouseListener,
KeyListener,
PropertyChangeListener {
    private LWMenu _menu;
    private Dismisser _dismisser;
    private MouseGrabProvider _grabProvider;
    static final int __POPUP_DELAY = 300;

    @Override
    public void installController(LWMenuItem lWMenuItem) {
        this._menu = (LWMenu)lWMenuItem;
        lWMenuItem.addMouseListener(this);
        lWMenuItem.addKeyListener(this);
        lWMenuItem.addPropertyChangeListener(this);
    }

    @Override
    public void uninstallController(LWMenuItem lWMenuItem) {
        lWMenuItem.removeMouseListener(this);
        lWMenuItem.removeKeyListener(this);
        lWMenuItem.removePropertyChangeListener(this);
        this._removeMouseGrab();
        this._menu = null;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (this._isDisplayKey(n)) {
            if (!this._menu.isSubMenuDisplayed() && this._menu.isEnabled()) {
                this._menu.activate();
                keyEvent.consume();
            }
        } else if (this._isHideKey(n) && this._menu.isSubMenuDisplayed()) {
            this._menu.setSubMenuDisplayed(false);
            keyEvent.consume();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("selected")) {
            if (propertyChangeEvent.getNewValue() == Boolean.TRUE) {
                this._addMouseGrab();
            } else {
                this._removeMouseGrab();
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        LWMenu lWMenu = (LWMenu)mouseEvent.getSource();
        if (lWMenu.isEnabled() && mouseEvent.getClickCount() == 1 && InputEventUtils.isLeftMouseButton(mouseEvent) && !lWMenu.isSubMenuDisplayed()) {
            lWMenu.setSubMenuDisplayed(true);
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        LWMenu lWMenu = (LWMenu)mouseEvent.getSource();
        if (!lWMenu.isSubMenuDisplayed()) {
            if (lWMenu.isEnabled()) {
                lWMenu.setSubMenuDisplayed(true, 300);
            } else {
                lWMenu.setSelected(true);
            }
            mouseEvent.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    LWMenu __getMenu() {
        return this._menu;
    }

    private void _addMouseGrab() {
        if (this._dismisser == null) {
            this._dismisser = new Dismisser();
            this._grabProvider = TrackingUtils.getMouseGrabProvider(this._menu);
            this._grabProvider.addMouseGrab(this._dismisser);
        }
    }

    private boolean _isDisplayKey(int n) {
        int n2 = this._menu.getActualReadingDirection() == 1 ? 39 : 37;
        return n == n2 || n == 10;
    }

    private boolean _isHideKey(int n) {
        int n2 = this._menu.getActualReadingDirection() == 1 ? 37 : 39;
        return n == n2 || n == 27;
    }

    private void _removeMouseGrab() {
        if (this._dismisser != null) {
            this._grabProvider.removeMouseGrab(this._dismisser);
            this._grabProvider = null;
            this._dismisser = null;
        }
    }

    private class Dismisser
    extends MouseAdapter {
        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            Component component = (Component)mouseEvent.getSource();
            LWMenu lWMenu = VertMenuController.this.__getMenu();
            if (lWMenu != component && lWMenu.getMenuItemContainer() == MenuUtils.getMenuItemContainer(component) && lWMenu.isSubMenuDisplayed()) {
                lWMenu.setSubMenuDisplayed(false, 300, true);
            }
        }
    }
}

