/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT;

import oracle.ewt.dataSource.ArrayOneDDataSource;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.lwAWT.LWDataSourceList;

public class LWList
extends LWDataSourceList {
    private static final int _DEFAULT_VISIBLE_ROWS = 4;
    private Object[] _addArray = new Object[1];

    public LWList() {
        this(4, false);
    }

    public LWList(int n) {
        this(n, false);
    }

    public LWList(int n, boolean bl) {
        super(new ArrayOneDDataSource(null), n, bl);
    }

    public void add(String string) {
        this.addItem(string);
    }

    public void addItem(String string) {
        this.addItem(string, -1);
    }

    public synchronized void add(String string, int n) {
        this.addItem(string, n);
    }

    public synchronized void addItem(String string, int n) {
        ArrayOneDDataSource arrayOneDDataSource = (ArrayOneDDataSource)this.getDataSource();
        int n2 = this.getItemCount();
        if (n < 0 || n >= n2) {
            n = n2;
        }
        this._addArray[0] = string;
        arrayOneDDataSource.addItems(n, this._addArray);
    }

    public synchronized void replaceItem(String string, int n) {
        if (n < 0 || n >= this.getItemCount()) {
            throw new IllegalArgumentException("index " + n + " is not valid.");
        }
        this.deselect(n);
        ArrayOneDDataSource arrayOneDDataSource = (ArrayOneDDataSource)this.getDataSource();
        arrayOneDDataSource.setData(n, string);
    }

    @Override
    public synchronized void removeAll() {
        ArrayOneDDataSource arrayOneDDataSource = (ArrayOneDDataSource)this.getDataSource();
        int n = arrayOneDDataSource.getItemCount();
        arrayOneDDataSource.removeItems(0, n);
        this.repaint();
    }

    public synchronized void remove(String string) {
        int n = -1;
        int n2 = this.getItemCount();
        for (int i = 0; i < n2; ++i) {
            String string2 = this.getItem(i);
            if (!string2.equals(string)) continue;
            n = i;
            break;
        }
        if (n < 0) {
            throw new IllegalArgumentException(string + " not found in list");
        }
        this.remove(n);
    }

    @Override
    public synchronized void remove(int n) {
        this.delItem(n);
    }

    public synchronized void delItem(int n) {
        if (n < 0 || n >= this.getItemCount()) {
            throw new IllegalArgumentException("index " + n + " is not valid.");
        }
        this.deselect(n);
        ArrayOneDDataSource arrayOneDDataSource = (ArrayOneDDataSource)this.getDataSource();
        arrayOneDDataSource.removeItems(n, 1);
    }

    @Override
    public void setDataSource(OneDDataSource oneDDataSource) {
        throw new IllegalStateException("can't set datasource.");
    }
}

