/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.layout;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;

public class MaximumBorderLayout
extends BorderLayout {
    private Component _north;
    private Component _south;
    private Component _east;
    private Component _west;
    private Component _center;

    public MaximumBorderLayout() {
    }

    public MaximumBorderLayout(int n, int n2) {
        super(n, n2);
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        if (string == null) {
            return;
        }
        super.addLayoutComponent(string, component);
        if (string.equals("Center")) {
            this._center = component;
        } else if (string.equals("North")) {
            this._north = component;
        } else if (string.equals("South")) {
            this._south = component;
        } else if (string.equals("East")) {
            this._east = component;
        } else if (string.equals("West")) {
            this._west = component;
        }
    }

    @Override
    public void removeLayoutComponent(Component component) {
        super.removeLayoutComponent(component);
        if (component != this._center) {
            if (component == this._north) {
                this._north = null;
            } else if (component == this._south) {
                this._south = null;
            } else if (component == this._east) {
                this._east = null;
            } else if (component == this._west) {
                this._west = null;
            }
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        Dimension dimension = this._getMaximumSize(this._center);
        Dimension dimension2 = this._getMaximumSize(this._north);
        Dimension dimension3 = this._getMaximumSize(this._south);
        Dimension dimension4 = this._getMaximumSize(this._east);
        Dimension dimension5 = this._getMaximumSize(this._west);
        int n = this.getHgap();
        int n2 = this.getVgap();
        int n3 = 0;
        int n4 = Short.MAX_VALUE;
        if (dimension != null) {
            n3 += dimension.width;
            n4 = dimension.height;
        }
        if (dimension4 != null) {
            n3 += dimension4.width + n;
            if (dimension4.height < n4) {
                n4 = dimension4.height;
            }
        }
        if (dimension5 != null) {
            n3 += dimension5.width + n;
            if (dimension5.height < n4) {
                n4 = dimension5.height;
            }
        }
        if (n3 == 0) {
            n3 = Short.MAX_VALUE;
        }
        if (dimension2 != null) {
            if (dimension2.width < n3) {
                n3 = dimension2.width;
            }
            n4 += dimension2.height + n2;
        }
        if (dimension3 != null) {
            if (dimension3.width < n3) {
                n3 = dimension3.width;
            }
            n4 += dimension3.height + n2;
        }
        Insets insets = container.getInsets();
        return new Dimension(n3 += insets.left + insets.right, n4 += insets.top + insets.bottom);
    }

    protected Component getComponent(Object object) {
        Component component = null;
        if (object.equals("Center")) {
            component = this._center;
        } else if (object.equals("North")) {
            component = this._north;
        } else if (object.equals("South")) {
            component = this._south;
        } else if (object.equals("East")) {
            component = this._east;
        } else if (object.equals("West")) {
            component = this._west;
        }
        return component;
    }

    private Dimension _getMaximumSize(Component component) {
        if (component == null || !component.isVisible()) {
            return null;
        }
        Dimension dimension = component.getMaximumSize();
        if (dimension.width > Short.MAX_VALUE) {
            dimension.width = Short.MAX_VALUE;
        }
        if (dimension.height > Short.MAX_VALUE) {
            dimension.height = Short.MAX_VALUE;
        }
        return dimension;
    }
}

