/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.layout;

import java.awt.Component;
import java.awt.Dimension;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import oracle.ewt.EwtComponent;
import oracle.ewt.UIManager;
import oracle.ewt.access.AccessibleLWComponent;
import oracle.ewt.access.OracleAccessibleRole;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedSizePainter;
import oracle.ewt.painter.NullPainter;
import oracle.ewt.util.ImmInsets;

public class GroupBoxContainer
extends EwtComponent {
    private Component _title;
    private Component _content;
    private ImmInsets _insets;
    private static final int _LABEL_INSET = 10;
    private static final int _COMPONENT_INSET = 5;

    public GroupBoxContainer() {
        this(null, null);
    }

    public GroupBoxContainer(Component component, Component component2) {
        this.setTitle(component);
        this.setContent(component2);
        this.setLayout(null);
        BorderPainter borderPainter = UIManager.createGroupBoxPainter(NullPainter.getPainter());
        this._insets = borderPainter.getInsets(this.getPaintContext());
    }

    public void setTitle(Component component) {
        if (this._title != null) {
            this.remove(this._title);
        }
        this._title = component;
        if (component != null) {
            this.add(component);
        }
    }

    public Component getTitle() {
        return this._title;
    }

    public void setContent(Component component) {
        if (this._content != null) {
            this.remove(this._content);
        }
        this._content = component;
        if (component != null) {
            this.add(component);
        }
    }

    public Component getContent() {
        return this._content;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = this._title.getPreferredSize();
        Dimension dimension2 = this._content.getPreferredSize();
        return this._calculateSize(dimension, dimension2);
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = this._title.getMinimumSize();
        Dimension dimension2 = this._content.getMinimumSize();
        return this._calculateSize(dimension, dimension2);
    }

    @Override
    protected AccessibleContext createAccessibleContext() {
        return new Access();
    }

    @Override
    public void doLayout() {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this._title.getPreferredSize();
        ImmInsets immInsets = this._insets;
        int n = dimension.width - 30;
        int n2 = dimension2.width;
        if (n < n2) {
            n2 = n;
        }
        int n3 = 15 + (int)((float)(n - n2) * this.getInteriorAlignmentX());
        this._title.setBounds(n3, 0, n2, dimension2.height);
        this._content.setBounds(immInsets.left, dimension2.height, dimension.width - (immInsets.left + immInsets.right), dimension.height - (dimension2.height + immInsets.bottom));
        this.setBorderPainter(UIManager.createGroupBoxPainter(new FixedSizePainter(NullPainter.getPainter(), n2 + 10, dimension2.height)));
    }

    private Dimension _calculateSize(Dimension dimension, Dimension dimension2) {
        ImmInsets immInsets = this._insets;
        return new Dimension(Math.max(dimension2.width, dimension.width + 30) + immInsets.left + immInsets.right, dimension.height + dimension2.height + immInsets.bottom);
    }

    private class Access
    extends AccessibleLWComponent {
        public Access() {
            super(GroupBoxContainer.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return OracleAccessibleRole.GROUP_BOX;
        }

        @Override
        public String getAccessibleName() {
            String string = super.getAccessibleName();
            if ((string == null || string == "") && GroupBoxContainer.this._title instanceof Accessible) {
                Accessible accessible = (Accessible)((Object)GroupBoxContainer.this._title);
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                accessibleContext.setAccessibleParent(this.getAccessibleParent());
                string = accessibleContext.getAccessibleName();
            }
            return string;
        }
    }
}

