/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import oracle.ewt.layout.DirectionalLayout;
import oracle.ewt.layout.MaximumBorderLayout;
import oracle.ewt.lwAWT.VirtualComponent;

public class DirectionalBorderLayout
extends MaximumBorderLayout
implements DirectionalLayout {
    public DirectionalBorderLayout() {
    }

    public DirectionalBorderLayout(int n, int n2) {
        super(n, n2);
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        if (string == null) {
            string = "Center";
        }
        super.addLayoutComponent(string, component);
    }

    @Override
    public void layoutContainer(Container container) {
        super.layoutContainer(container);
        if (this._isRightToLeft(container)) {
            Rectangle rectangle;
            Insets insets = container.getInsets();
            Dimension dimension = container.getSize();
            int n = insets.left;
            int n2 = dimension.width - insets.right;
            int n3 = this.getHgap();
            Component component = this.getComponent("East");
            if (component != null && component.isVisible()) {
                rectangle = component.getBounds();
                component.setBounds(insets.left, rectangle.y, rectangle.width, rectangle.height);
                n += rectangle.width + n3;
            }
            if ((component = this.getComponent("West")) != null && component.isVisible()) {
                rectangle = component.getBounds();
                component.setBounds(n2 - rectangle.width, rectangle.y, rectangle.width, rectangle.height);
                n2 -= rectangle.width + n3;
            }
            if ((component = this.getComponent("Center")) != null && component.isVisible()) {
                rectangle = component.getBounds();
                component.setBounds(n, rectangle.y, n2 - n, rectangle.height);
            }
        }
    }

    private boolean _isRightToLeft(Component component) {
        return component instanceof VirtualComponent && ((VirtualComponent)((Object)component)).getActualReadingDirection() == 2;
    }
}

