/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.util;

import java.util.Arrays;
import java.util.List;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusFilter;

public final class VCSStatusFilters {
    private VCSStatusFilters() {
    }

    public static final VCSStatusFilter createStatusFilter(VCSStatus[] statuses) {
        final List<VCSStatus> statuses2 = Arrays.asList(statuses);
        return new VCSStatusFilter(){

            @Override
            public boolean accept(VCSStatus status) {
                return statuses2.contains(status);
            }
        };
    }

    public static final VCSStatusFilter createVersionedStatusFilter() {
        return new VCSStatusFilter(){

            @Override
            public boolean accept(VCSStatus status) {
                return status.isVersioned();
            }
        };
    }

    public static final VCSStatusFilter createCandidateStatusFilter() {
        return new VCSStatusFilter(){

            @Override
            public boolean accept(VCSStatus status) {
                return status.isCandidate();
            }
        };
    }

    public static final VCSStatusFilter createChainedANDFilter(final VCSStatusFilter[] filters) {
        return new VCSStatusFilter(){

            @Override
            public boolean accept(VCSStatus status) {
                for (int i = 0; i < filters.length; ++i) {
                    if (filters[i].accept(status)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static final VCSStatusFilter createChainedORFilter(final VCSStatusFilter[] filters) {
        return new VCSStatusFilter(){

            @Override
            public boolean accept(VCSStatus status) {
                for (int i = 0; i < filters.length; ++i) {
                    if (!filters[i].accept(status)) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

