/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.importer.writers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Locale;
import oracle.dbtools.common.utils.BasicDBObject;
import oracle.dbtools.data.formattors.ITypeFormattor;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.GenericTable;
import oracle.dbtools.data.model.LoadField;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.datatools.BaseDataFormat;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.importer.ImportResources;
import oracle.dbtools.importer.core.ImportDataFormat;
import oracle.dbtools.importer.core.ImportKeys;
import oracle.dbtools.importer.core.ImportProperties;
import oracle.dbtools.importer.core.ImportXMLUtil;
import oracle.dbtools.importer.formattors.DataTypeFormatterRegistry;
import oracle.dbtools.util.Logger;

public final class ImportGenHelper {
    public static final String getTableName(ImportProperties iProps) {
        GenericTable genTable = (GenericTable)iProps.get(ImportKeys.TABLE);
        if (genTable != null && genTable.getTable() != null) {
            return genTable.getTable().getTablename();
        }
        return (String)iProps.get(ImportKeys.TABLE_NAME);
    }

    public static final String addUser(ImportProperties iProps, String name) {
        String connUser = (String)iProps.get(ImportKeys.CONNECTION_USER);
        BasicDBObject dbo = (BasicDBObject)iProps.get(ImportKeys.DBOBJECT);
        if (connUser == null && dbo != null) {
            String connName = ((BasicDBObject)iProps.get(ImportKeys.DBOBJECT)).getConnectionName();
            try {
                Connection baseConn = ConnectionResolver.getConnection((String)connName);
                connUser = baseConn.getMetaData().getUserName();
                iProps.put(ImportKeys.CONNECTION_USER, connUser);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String schemaName = null;
        if (dbo != null && (schemaName = (String)iProps.get(ImportKeys.OBJECT_SCHEMA)) == null) {
            schemaName = ((BasicDBObject)iProps.get(ImportKeys.DBOBJECT)).getSchemaName();
        }
        if (connUser != null && schemaName != null && !connUser.equals(schemaName)) {
            return DBUtil.addDoubleQuote((String)schemaName) + "." + name;
        }
        return name;
    }

    public static final String getSchema(ImportProperties iProps) {
        String schemaName;
        String connUser = (String)iProps.get(ImportKeys.CONNECTION_USER);
        BasicDBObject dbo = (BasicDBObject)iProps.get(ImportKeys.DBOBJECT);
        if (connUser == null && dbo != null) {
            String connName = ((BasicDBObject)iProps.get(ImportKeys.DBOBJECT)).getConnectionName();
            try {
                Connection baseConn = ConnectionResolver.getConnection((String)connName);
                connUser = baseConn.getMetaData().getUserName();
                iProps.put(ImportKeys.CONNECTION_USER, connUser);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((schemaName = (String)iProps.get(ImportKeys.OBJECT_SCHEMA)) == null) {
            schemaName = ((BasicDBObject)iProps.get(ImportKeys.DBOBJECT)).getSchemaName();
        }
        return dbo == null ? connUser : ((BasicDBObject)iProps.get(ImportKeys.DBOBJECT)).getSchemaName();
    }

    public static final String addDoubleQuote(ImportProperties iProps, String name, boolean isEscape) {
        String value;
        if (iProps.getValueBoolean(ImportKeys.IS_EXISTING_TABLE).booleanValue() && (value = DBUtil.addDoubleQuote((String)name)).startsWith("\"")) {
            return "\\" + value.substring(0, value.length() - 1) + "\\";
        }
        return name;
    }

    public static final String addDoubleQuote(ImportProperties iProps, String name) {
        if (iProps.getValueBoolean(ImportKeys.IS_EXISTING_TABLE).booleanValue()) {
            return DBUtil.addDoubleQuote((String)name);
        }
        return name;
    }

    public static final String translateEOL(ImportProperties iProps, String content) {
        content = content.replaceAll("\\r", "");
        ImportDataFormat dataFormat = (ImportDataFormat)iProps.get(ImportKeys.IMPORT_DATA_FORMAT);
        String fileOutTerm = dataFormat.getRecordTerminatorValue((String)iProps.get(ImportKeys.FILEOUTNEWLINE));
        String formatTerm = dataFormat.getRecordTerminatorValue(dataFormat.getRecordTerminator());
        String term = fileOutTerm != null && !BaseDataFormat.isRecordTerminatorImportFile(fileOutTerm) ? fileOutTerm : formatTerm;
        content = content.replaceAll("\\n", term);
        return content;
    }

    public static final String dos(String content) {
        return content.replaceAll("\\r", "").replaceAll("\\n", "\r\n");
    }

    public static final String nix(String content) {
        return content.replaceAll("\\r", "");
    }

    public static final ImportProperties getConfig(URL configUrl) throws IOException {
        ImportXMLUtil util = new ImportXMLUtil();
        util.setImport(true);
        FileInputStream fIn = new FileInputStream(new File(configUrl.getPath()));
        util.parseXML(fIn, true);
        ((InputStream)fIn).close();
        return util.getProperties();
    }

    public static final String getTaskFullName(ImportProperties iProps) {
        LoadFile loadFile = (LoadFile)iProps.get(ImportKeys.LOAD_FILE);
        String inputFileName = iProps.getValueBoolean(ImportKeys.IS_SOURCE_OSS) != false ? (String)iProps.get(ImportKeys.OSS_PATH) : loadFile.getName();
        GenericTable table = (GenericTable)iProps.get(ImportKeys.TABLE);
        int loc = -1;
        loc = inputFileName.lastIndexOf("/");
        if (loc > 0) {
            inputFileName = inputFileName.substring(loc + 1);
        }
        String tableName = table.getTable().getTablename();
        return ImportResources.format("TASK_FULL_NAME", tableName, inputFileName);
    }

    public static final boolean lockConnectionForImport(Connection conn, boolean autoCommit, ExitCode exitCode) {
        boolean connLocked = false;
        try {
            connLocked = LockManager.lock((Connection)conn);
            if (!connLocked) {
                Logger.warn(ImportGenHelper.class, (String)ImportResources.getString("LOCK_CONN_ERR"));
                exitCode = ExitCode.EXIT_SEVERE;
                exitCode.setShortMessage(ImportResources.getString("LOCK_CONN_ERR"));
                return false;
            }
            autoCommit = conn.getAutoCommit();
            conn.setAutoCommit(false);
        }
        catch (Exception e) {
            Logger.warn(ImportGenHelper.class, (Throwable)e);
            exitCode = ExitCode.EXIT_SEVERE;
            exitCode.setShortMessage(e.getMessage());
            return false;
        }
        return connLocked;
    }

    public static final String[] formatTableColumns(ImportProperties iProps) {
        return ImportGenHelper.formatTableColumns(iProps, false);
    }

    public static final String[] formatTableColumns(ImportProperties iProps, boolean addDoubleQuote) {
        String[] strCols = null;
        Column[] cols = null;
        String type = null;
        ITypeFormattor fmtor = null;
        cols = (Column[])iProps.get(ImportKeys.SELECTED_COLUMNS);
        strCols = new String[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            type = cols[i].getType();
            fmtor = DataTypeFormatterRegistry.getInstance().getFormattor(type.toUpperCase());
            if (fmtor != null) {
                fmtor.setLocale((Locale)iProps.get(ImportKeys.LOCALE));
            } else {
                fmtor = DataTypeFormatterRegistry.getInstance().getFormattor("VARCHAR2");
            }
            fmtor.isAddDoubleQuote(addDoubleQuote);
            strCols[i] = fmtor.formatColumn(cols[i]);
        }
        return strCols;
    }

    public static final void genControlFileFields(ArrayList<String> al, ImportProperties iProps, boolean isMetaTable) {
        GenericTable genericTable = (GenericTable)iProps.get(ImportKeys.TABLE);
        for (Column c : genericTable.getColumns()) {
            al.add(ImportGenHelper.getField(iProps, isMetaTable, c));
        }
    }

    public static final void genFieldsFromLoadFile(ArrayList<String> al, ImportProperties iProps, boolean isMetaTable, boolean isEscape) {
        LoadFile loadfile = (LoadFile)iProps.get(ImportKeys.LOAD_FILE);
        GenericTable genericTable = (GenericTable)iProps.get(ImportKeys.TABLE);
        if (genericTable != null) {
            Column c;
            Column[] cols = genericTable.getColumns();
            int i = 0;
            boolean newOrder = false;
            for (LoadField f : loadfile.getFields()) {
                c = f.getColumn();
                if (c != null && !cols[i].getName().equals(c.getName())) {
                    newOrder = true;
                    break;
                }
                ++i;
            }
            if (cols.length > i) {
                newOrder = true;
            }
            if (newOrder) {
                for (LoadField f : loadfile.getFields()) {
                    c = f.getColumn();
                    if (c == null) continue;
                    al.add(ImportGenHelper.getField(iProps, isMetaTable, c, isEscape));
                }
            }
        }
    }

    public static final String getField(ImportProperties iProps, boolean isMetaTable, Column c) {
        return ImportGenHelper.getField(iProps, isMetaTable, c, false);
    }

    public static final String getField(ImportProperties iProps, boolean isMetaTable, Column c, boolean isEscape) {
        String checkIsNumber = (String)iProps.get(ImportKeys.CHARNUMCHARACTERS);
        boolean useNumChars = false;
        if (checkIsNumber != null && checkIsNumber.length() != 0 && checkIsNumber.replaceAll("[0-9]*", "").equals("")) {
            useNumChars = true;
        }
        String type = c.getType().toUpperCase();
        String q = isEscape ? "\\\"" : "\"";
        switch (type) {
            case "NUMBER": 
            case "INTEGER": 
            case "FLOAT": {
                return ImportGenHelper.addDoubleQuote(iProps, c.getName(), isEscape);
            }
            case "DATE": {
                if (c.getFormat() == null) {
                    return ImportGenHelper.addDoubleQuote(iProps, c.getName(), isEscape) + " DATE";
                }
                return ImportGenHelper.addDoubleQuote(iProps, c.getName(), isEscape) + " DATE " + q + c.getFormat() + q;
            }
            case "TIMESTAMP": {
                if (c.getFormat() == null) {
                    return ImportGenHelper.addDoubleQuote(iProps, c.getName(), isEscape) + " TIMESTAMP";
                }
                return ImportGenHelper.addDoubleQuote(iProps, c.getName(), isEscape) + " TIMESTAMP " + q + c.getFormat() + q;
            }
            case "CHAR": 
            case "NCHAR": {
                if (isMetaTable) {
                    return ImportGenHelper.addDoubleQuote(iProps, c.getName(), isEscape) + " CHAR(" + c.getPrecision() + ")";
                }
                if (useNumChars) {
                    return ImportGenHelper.addDoubleQuote(iProps, c.getName(), isEscape) + " CHAR(" + checkIsNumber + ")";
                }
                return ImportGenHelper.addDoubleQuote(iProps, c.getName(), isEscape) + " CHAR(2000)";
            }
            case "VARCHAR2": 
            case "NVARCHAR2": {
                if (isMetaTable) {
                    return ImportGenHelper.addDoubleQuote(iProps, c.getName(), isEscape) + " CHAR(" + c.getPrecision() + ")";
                }
                if (useNumChars) {
                    return ImportGenHelper.addDoubleQuote(iProps, c.getName(), isEscape) + " CHAR(" + checkIsNumber + ")";
                }
                return ImportGenHelper.addDoubleQuote(iProps, c.getName(), isEscape) + " CHAR(32767)";
            }
            case "CLOB": {
                if (useNumChars) {
                    return ImportGenHelper.addDoubleQuote(iProps, c.getName(), isEscape) + " CHAR(" + checkIsNumber + ")";
                }
                return ImportGenHelper.addDoubleQuote(iProps, c.getName(), isEscape) + " CHAR(32767)";
            }
        }
        if (useNumChars) {
            return ImportGenHelper.addDoubleQuote(iProps, c.getName(), isEscape) + " CHAR(" + checkIsNumber + ")";
        }
        return ImportGenHelper.addDoubleQuote(iProps, c.getName(), isEscape) + " CHAR(4000)";
    }
}

